/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.protocol.v2;

import java.util.List;
import javax.xml.ws.Holder;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.wsrp.consumer.ProducerInfo;
import org.gatein.wsrp.protocol.v2.InteropServiceDescriptionTestCase;
import org.gatein.wsrp.test.ExtendedAssert;
import org.gatein.wsrp.test.protocol.v2.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v2.behaviors.GroupedPortletsServiceDescriptionBehavior;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.ExportDescription;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.ItemDescription;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModelTypes;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;

public class ServiceDescriptionTestCase
extends InteropServiceDescriptionTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setStrict(true);
    }

    @Override
    public void testUsesRelaxedMode() {
        ExtendedAssert.assertTrue((boolean)this.isStrict());
    }

    public void testGetPortlet() throws Exception {
        Portlet portlet = this.consumer.getPortlet(PortletContext.createPortletContext((String)"SamplePortletHandle", (boolean)false));
        this.checkPortlet(portlet, "", "SamplePortletHandle");
        portlet = this.consumer.getPortlet(PortletContext.createPortletContext((String)"SecondPortletHandle", (boolean)false));
        this.checkPortlet(portlet, "2", "SecondPortletHandle");
    }

    public void testRequiresInitCookieIsProperlySetOnConsumerInitiatedRefresh() throws OperationFailed, ResourceSuspended, ModifyRegistrationRequired, InvalidRegistration, PortletInvokerException {
        BehaviorRegistry registry = this.producer.getBehaviorRegistry();
        Holder offeredPortlets = new Holder();
        registry.getServiceDescriptionBehavior().getServiceDescription(null, null, null, null, (Holder<Boolean>)new Holder(), (Holder<List<PortletDescription>>)offeredPortlets, (Holder<List<ItemDescription>>)new Holder(), null, (Holder<List<ItemDescription>>)new Holder(), (Holder<List<ItemDescription>>)new Holder(), (Holder<CookieProtocol>)new Holder(), (Holder<ModelDescription>)new Holder(), (Holder<List<String>>)new Holder(), (Holder<ResourceList>)new Holder(), (Holder<List<EventDescription>>)new Holder(), (Holder<ModelTypes>)new Holder(), (Holder<List<String>>)new Holder(), (Holder<ExportDescription>)new Holder(), (Holder<Boolean>)new Holder(), (Holder<List<Extension>>)new Holder());
        this.setServiceDescriptionBehavior(new GroupedPortletsServiceDescriptionBehavior((List)offeredPortlets.value));
        GroupedPortletsServiceDescriptionBehavior sdb = new GroupedPortletsServiceDescriptionBehavior((List)offeredPortlets.value);
        sdb.setRequiresInitCookie(CookieProtocol.PER_GROUP);
        this.setServiceDescriptionBehavior(sdb);
        this.consumer.refreshProducerInfo();
        ProducerInfo producerInfo = this.consumer.getProducerInfo();
        ServiceDescriptionTestCase.assertEquals((Object)CookieProtocol.PER_GROUP, (Object)producerInfo.getRequiresInitCookie());
        ServiceDescriptionTestCase.assertTrue((boolean)this.consumer.getSessionHandler().requiresInitCookie());
    }

    public void testRequiresInitCookieIsProperlySetOnProducerInfoInitiatedRefresh() throws OperationFailed, ResourceSuspended, ModifyRegistrationRequired, InvalidRegistration, PortletInvokerException {
        BehaviorRegistry registry = this.producer.getBehaviorRegistry();
        Holder offeredPortlets = new Holder();
        registry.getServiceDescriptionBehavior().getServiceDescription(null, null, null, null, (Holder<Boolean>)new Holder(), (Holder<List<PortletDescription>>)offeredPortlets, (Holder<List<ItemDescription>>)new Holder(), null, (Holder<List<ItemDescription>>)new Holder(), (Holder<List<ItemDescription>>)new Holder(), (Holder<CookieProtocol>)new Holder(), (Holder<ModelDescription>)new Holder(), (Holder<List<String>>)new Holder(), (Holder<ResourceList>)new Holder(), (Holder<List<EventDescription>>)new Holder(), (Holder<ModelTypes>)new Holder(), (Holder<List<String>>)new Holder(), (Holder<ExportDescription>)new Holder(), (Holder<Boolean>)new Holder(), (Holder<List<Extension>>)new Holder());
        this.setServiceDescriptionBehavior(new GroupedPortletsServiceDescriptionBehavior((List)offeredPortlets.value));
        GroupedPortletsServiceDescriptionBehavior sdb = new GroupedPortletsServiceDescriptionBehavior((List)offeredPortlets.value);
        sdb.setRequiresInitCookie(CookieProtocol.PER_GROUP);
        this.setServiceDescriptionBehavior(sdb);
        this.consumer.getProducerInfo().refresh(true);
        ProducerInfo producerInfo = this.consumer.getProducerInfo();
        ServiceDescriptionTestCase.assertEquals((Object)CookieProtocol.PER_GROUP, (Object)producerInfo.getRequiresInitCookie());
        ServiceDescriptionTestCase.assertTrue((boolean)this.consumer.getSessionHandler().requiresInitCookie());
    }
}

