/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1;

import java.util.HashMap;
import java.util.Map;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.gatein.wsrp.test.protocol.v1.MarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.PortletManagementBehavior;
import org.gatein.wsrp.test.protocol.v1.RegistrationBehavior;
import org.gatein.wsrp.test.protocol.v1.ServiceDescriptionBehavior;
import org.oasis.wsrp.v1.V1InvalidHandle;

public class BehaviorRegistry {
    private final Map<String, MarkupBehavior> behaviors = new HashMap<String, MarkupBehavior>();
    private PortletManagementBehavior portletManagementBehavior;
    private ServiceDescriptionBehavior serviceDescriptionBehavior;
    private RegistrationBehavior registrationBehavior;

    public ServiceDescriptionBehavior getServiceDescriptionBehavior() {
        if (this.serviceDescriptionBehavior == null) {
            return ServiceDescriptionBehavior.DEFAULT;
        }
        return this.serviceDescriptionBehavior;
    }

    public void clear() {
        this.behaviors.clear();
    }

    public MarkupBehavior getMarkupBehaviorFor(String handle) throws V1InvalidHandle {
        if (this.behaviors.containsKey(handle)) {
            return this.behaviors.get(handle);
        }
        throw (V1InvalidHandle)WSRP1ExceptionFactory.throwWSException(V1InvalidHandle.class, (String)("There is no registered MarkupBehavior for handle '" + handle + "'"), null);
    }

    public void registerMarkupBehavior(MarkupBehavior behavior) {
        for (String handle : behavior.getSupportedHandles()) {
            MarkupBehavior existing = this.behaviors.get(handle);
            if (existing != null) {
                throw new IllegalArgumentException("Cannot register behavior " + behavior.getClass().getName() + " because it uses a handle '" + handle + "' that's already associated with behavior " + existing.getClass().getName());
            }
            this.behaviors.put(handle, behavior);
        }
    }

    public PortletManagementBehavior getPortletManagementBehavior() {
        return this.portletManagementBehavior;
    }

    public void setPortletManagementBehavior(PortletManagementBehavior portletManagementBehavior) {
        this.portletManagementBehavior = portletManagementBehavior;
    }

    public void setServiceDescriptionBehavior(ServiceDescriptionBehavior serviceDescriptionBehavior) {
        this.serviceDescriptionBehavior = serviceDescriptionBehavior;
    }

    public RegistrationBehavior getRegistrationBehavior() {
        return this.registrationBehavior;
    }

    public void setRegistrationBehavior(RegistrationBehavior registrationBehavior) {
        this.registrationBehavior = registrationBehavior;
    }
}

