/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v1.behaviors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jws.WebParam;
import javax.xml.ws.Holder;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.spec.v1.WSRP1ExceptionFactory;
import org.gatein.wsrp.spec.v1.WSRP1TypeFactory;
import org.gatein.wsrp.test.protocol.v1.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v1.MarkupBehavior;
import org.gatein.wsrp.test.protocol.v1.PortletManagementBehavior;
import org.oasis.wsrp.v1.V1AccessDenied;
import org.oasis.wsrp.v1.V1DestroyFailed;
import org.oasis.wsrp.v1.V1Extension;
import org.oasis.wsrp.v1.V1InconsistentParameters;
import org.oasis.wsrp.v1.V1InvalidHandle;
import org.oasis.wsrp.v1.V1InvalidRegistration;
import org.oasis.wsrp.v1.V1InvalidUserCategory;
import org.oasis.wsrp.v1.V1MissingParameters;
import org.oasis.wsrp.v1.V1OperationFailed;
import org.oasis.wsrp.v1.V1PortletContext;
import org.oasis.wsrp.v1.V1PortletDescription;
import org.oasis.wsrp.v1.V1Property;
import org.oasis.wsrp.v1.V1PropertyList;
import org.oasis.wsrp.v1.V1RegistrationContext;
import org.oasis.wsrp.v1.V1ResetProperty;
import org.oasis.wsrp.v1.V1ResourceList;
import org.oasis.wsrp.v1.V1UserContext;

public class BasicPortletManagementBehavior
extends PortletManagementBehavior {
    private static final String CLONE_SUFFIX = "_clone";
    public static final String PROPERTY_NAME = "prop1";
    public static final String PROPERTY_VALUE = "value1";
    public static final String PROPERTY_NEW_VALUE = "value2";
    public static final String CLONED_HANDLE = "SamplePortletHandle_clone";
    public static final String CANNOT_BOTH_SET_AND_RESET_A_PROPERTY_AT_THE_SAME_TIME = "Cannot both set and reset a property at the same time!";
    private BehaviorRegistry registry;
    private String propValue = "value1";

    public BasicPortletManagementBehavior(BehaviorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void clonePortlet(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(mode=WebParam.Mode.OUT, name="portletHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> portletHandle, @WebParam(mode=WebParam.Mode.OUT, name="portletState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> portletState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        String handle = this.getHandleFrom(portletContext, "portlet context");
        if (!"SamplePortletHandle".equals(handle)) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.throwWSException(V1OperationFailed.class, (String)("Cannot modify portlet '" + handle + "'"), null);
        }
        portletHandle.value = CLONED_HANDLE;
    }

    @Override
    public void getPortletDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> desiredLocales, @WebParam(mode=WebParam.Mode.OUT, name="portletDescription", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1PortletDescription> portletDescription, @WebParam(mode=WebParam.Mode.OUT, name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<V1ResourceList> resourceList, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        super.getPortletDescription(registrationContext, portletContext, userContext, desiredLocales, portletDescription, resourceList, extensions);
        String handle = this.getHandleFrom(portletContext, "portlet context");
        int index = handle.indexOf(CLONE_SUFFIX);
        if (index != -1) {
            handle = handle.substring(0, index);
        }
        MarkupBehavior markupBehaviorFor = this.registry.getMarkupBehaviorFor(handle);
        V1PortletDescription description = markupBehaviorFor.getPortletDescriptionFor(handle);
        if (index != -1) {
            description.setPortletHandle(handle + CLONE_SUFFIX);
        }
        portletDescription.value = description;
    }

    @Override
    public void getPortletProperties(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="names", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> names, @WebParam(mode=WebParam.Mode.OUT, name="properties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Property>> properties, @WebParam(mode=WebParam.Mode.OUT, name="resetProperties", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1ResetProperty>> resetProperties, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        String handle = this.getHandleFrom(portletContext, "portlet context");
        ArrayList<V1Property> propertyList = new ArrayList<V1Property>(1);
        if ("SamplePortletHandle".equals(handle)) {
            propertyList.add(WSRP1TypeFactory.createProperty((String)PROPERTY_NAME, (String)"en", (String)PROPERTY_VALUE));
        } else if (CLONED_HANDLE.equals(handle)) {
            if (this.propValue != null) {
                propertyList.add(WSRP1TypeFactory.createProperty((String)PROPERTY_NAME, (String)"en", (String)this.propValue));
            }
            if (this.callCount > 4) {
                throw new IllegalStateException("Shouldn't have been called more than four times!");
            }
        } else {
            WSRP1ExceptionFactory.throwWSException(V1InvalidHandle.class, (String)("Unknown handle '" + handle + "'"), null);
        }
        this.incrementCallCount();
        properties.value = propertyList;
    }

    @Override
    public void setPortletProperties(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PortletContext portletContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1UserContext userContext, @WebParam(name="propertyList", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1PropertyList propertyList, @WebParam(mode=WebParam.Mode.OUT, name="portletHandle", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<String> portletHandle, @WebParam(mode=WebParam.Mode.OUT, name="portletState", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<byte[]> portletState, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidHandle, V1InvalidRegistration, V1InvalidUserCategory, V1AccessDenied, V1OperationFailed {
        String name;
        String handle = this.getHandleFrom(portletContext, "portlet context");
        if (!CLONED_HANDLE.equals(handle)) {
            throw (V1OperationFailed)WSRP1ExceptionFactory.throwWSException(V1OperationFailed.class, (String)("Cannot modify portlet '" + handle + "'"), null);
        }
        List properties = propertyList.getProperties();
        List resetProperties = propertyList.getResetProperties();
        if (ParameterValidation.existsAndIsNotEmpty((Collection)properties) && ParameterValidation.existsAndIsNotEmpty((Collection)resetProperties)) {
            if (properties.size() != 1 && resetProperties.size() != 1) {
                WSRP1ExceptionFactory.throwWSException(V1InconsistentParameters.class, (String)"Invalid number of properties!", null);
            }
            if (((V1Property)properties.get(0)).getName().equals(((V1ResetProperty)resetProperties.get(0)).getName())) {
                WSRP1ExceptionFactory.throwWSException(V1InconsistentParameters.class, (String)CANNOT_BOTH_SET_AND_RESET_A_PROPERTY_AT_THE_SAME_TIME, null);
            }
        }
        if (ParameterValidation.existsAndIsNotEmpty((Collection)properties)) {
            V1Property property;
            if (properties.size() != 1) {
                WSRP1ExceptionFactory.throwWSException(V1InconsistentParameters.class, (String)"Invalid number of properties!", null);
            }
            if ((name = (property = (V1Property)properties.get(0)).getName()).equals(PROPERTY_NAME)) {
                this.propValue = property.getStringValue();
            } else {
                WSRP1ExceptionFactory.throwWSException(V1InconsistentParameters.class, (String)("Unknown property '" + name + "'"), null);
            }
        }
        if (ParameterValidation.existsAndIsNotEmpty((Collection)resetProperties)) {
            V1ResetProperty resetProperty;
            if (resetProperties.size() != 1) {
                WSRP1ExceptionFactory.throwWSException(V1InconsistentParameters.class, (String)"Invalid number of reset properties!", null);
            }
            if ((name = (resetProperty = (V1ResetProperty)resetProperties.get(0)).getName()).equals(PROPERTY_NAME)) {
                this.propValue = PROPERTY_VALUE;
            } else {
                WSRP1ExceptionFactory.throwWSException(V1InconsistentParameters.class, (String)("Unknown property '" + name + "'"), null);
            }
        }
        portletHandle.value = handle;
    }

    private String getHandleFrom(V1PortletContext portletContext, String context) throws V1MissingParameters, V1InvalidHandle {
        WSRP1ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)portletContext, (String)"portlet context", (String)context);
        String handle = portletContext.getPortletHandle();
        WSRP1ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)handle, (String)"portlet handle", (String)"PortletContext");
        if (handle.length() == 0) {
            throw (V1InvalidHandle)((Object)WSRP1ExceptionFactory.throwWSException(V1InvalidHandle.class, (String)"Portlet handle is empty", null));
        }
        return handle;
    }

    @Override
    public void destroyPortlets(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") V1RegistrationContext registrationContext, @WebParam(name="portletHandles", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") List<String> portletHandles, @WebParam(mode=WebParam.Mode.OUT, name="destroyFailed", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1DestroyFailed>> destroyFailed, @WebParam(mode=WebParam.Mode.OUT, name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v1:types") Holder<List<V1Extension>> extensions) throws V1MissingParameters, V1InconsistentParameters, V1InvalidRegistration, V1OperationFailed {
        ArrayList<V1DestroyFailed> list;
        super.destroyPortlets(registrationContext, portletHandles, destroyFailed, extensions);
        WSRP1ExceptionFactory.throwMissingParametersIfValueIsMissing(portletHandles, (String)"portlet handles", (String)"destroyPortlets");
        if (portletHandles.isEmpty()) {
            WSRP1ExceptionFactory.throwMissingParametersIfValueIsMissing(portletHandles, (String)"portlet handles", (String)"DestroyPortlets");
        }
        if ((list = (ArrayList<V1DestroyFailed>)destroyFailed.value) == null) {
            destroyFailed.value = list = new ArrayList<V1DestroyFailed>();
        }
        for (String handle : portletHandles) {
            if (CLONED_HANDLE.equals(handle)) continue;
            list.add(WSRP1TypeFactory.createDestroyFailed((String)handle, (String)("Handle '" + handle + "' doesn't exist")));
        }
    }
}

