/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v2;

import org.gatein.common.NotYetImplemented;
import org.gatein.common.util.Version;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.services.MarkupService;
import org.gatein.wsrp.services.PortletManagementService;
import org.gatein.wsrp.services.RegistrationService;
import org.gatein.wsrp.services.ServiceDescriptionService;
import org.gatein.wsrp.services.ServiceFactory;
import org.gatein.wsrp.services.v2.V2MarkupService;
import org.gatein.wsrp.services.v2.V2PortletManagementService;
import org.gatein.wsrp.services.v2.V2RegistrationService;
import org.gatein.wsrp.services.v2.V2ServiceDescriptionService;
import org.gatein.wsrp.test.protocol.v2.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v2.MarkupBehavior;
import org.gatein.wsrp.test.support.RequestedMarkupBehavior;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.WSRPV2MarkupPortType;
import org.oasis.wsrp.v2.WSRPV2PortletManagementPortType;
import org.oasis.wsrp.v2.WSRPV2RegistrationPortType;
import org.oasis.wsrp.v2.WSRPV2ServiceDescriptionPortType;

public class BehaviorBackedServiceFactory
implements ServiceFactory {
    private BehaviorRegistry registry;
    private static final String MARKUP = "markup";
    private boolean initialized = false;
    private String wsdl = "http://example.com/producer?wsdl";
    public static final String DEFAULT_WSDL_URL = "http://example.com/producer?wsdl";
    private int timeout = 10000;
    private boolean failed = false;

    public BehaviorBackedServiceFactory() {
        this(new BehaviorRegistry());
    }

    public BehaviorBackedServiceFactory(BehaviorRegistry registry) {
        this.registry = registry;
        registry.registerMarkupBehavior(new SimpleMarkupBehavior());
    }

    public <T> T getService(Class<T> serviceClass) throws Exception {
        if (!this.isAvailable() && !this.isFailed()) {
            this.start();
        }
        if (WSRPV2ServiceDescriptionPortType.class.isAssignableFrom(serviceClass)) {
            return (T)this.registry.getServiceDescriptionBehavior();
        }
        if (WSRPV2MarkupPortType.class.isAssignableFrom(serviceClass)) {
            String requestedMarkupBehavior = RequestedMarkupBehavior.getRequestedMarkupBehavior();
            if (requestedMarkupBehavior == null) {
                requestedMarkupBehavior = MARKUP;
            }
            return (T)this.registry.getMarkupBehaviorFor(requestedMarkupBehavior);
        }
        if (WSRPV2PortletManagementPortType.class.isAssignableFrom(serviceClass)) {
            return (T)this.registry.getPortletManagementBehavior();
        }
        if (WSRPV2RegistrationPortType.class.isAssignableFrom(serviceClass)) {
            return (T)this.registry.getRegistrationBehavior();
        }
        return null;
    }

    public ServiceDescriptionService getServiceDescriptionService() throws Exception {
        return new V2ServiceDescriptionService(this.getService(WSRPV2ServiceDescriptionPortType.class));
    }

    public MarkupService getMarkupService() throws Exception {
        return new V2MarkupService(this.getService(WSRPV2MarkupPortType.class));
    }

    public PortletManagementService getPortletManagementService() throws Exception {
        return new V2PortletManagementService(this.getService(WSRPV2PortletManagementPortType.class));
    }

    public RegistrationService getRegistrationService() throws Exception {
        return new V2RegistrationService(this.getService(WSRPV2RegistrationPortType.class));
    }

    public Version getWSRPVersion() {
        return ServiceFactory.WSRP2;
    }

    public boolean refresh(boolean force) throws Exception {
        if (force || !this.isAvailable() && !this.isFailed()) {
            this.start();
            return true;
        }
        return false;
    }

    public BehaviorRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(BehaviorRegistry registry) {
        this.registry = registry;
    }

    public boolean isAvailable() {
        return this.initialized;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setWSOperationTimeOut(int msBeforeTimeOut) {
        if (msBeforeTimeOut < 0) {
            msBeforeTimeOut = 10000;
        }
        this.timeout = msBeforeTimeOut;
    }

    public int getWSOperationTimeOut() {
        return this.timeout;
    }

    public void create() throws Exception {
        throw new NotYetImplemented();
    }

    public void start() throws Exception {
        if (this.failed) {
            throw new RuntimeException("ServiceFactory has failed!");
        }
        this.initialized = true;
    }

    public void stop() {
        throw new NotYetImplemented();
    }

    public void setWsdlDefinitionURL(String wsdlDefinitionURL) {
        this.wsdl = wsdlDefinitionURL;
    }

    public String getWsdlDefinitionURL() {
        return this.wsdl;
    }

    public void destroy() {
        throw new NotYetImplemented();
    }

    public void enableWSS(boolean enable) {
    }

    public boolean isWSSEnabled() {
        return false;
    }

    public boolean isWSSAvailable() {
        return false;
    }

    private class SimpleMarkupBehavior
    extends MarkupBehavior {
        public SimpleMarkupBehavior() {
            super(BehaviorBackedServiceFactory.this.registry);
            this.registerHandle(BehaviorBackedServiceFactory.MARKUP);
        }

        @Override
        protected String getMarkupString(Mode mode, WindowState windowState, String navigationalState, GetMarkup getMarkup) throws UnsupportedWindowState, InvalidCookie, InvalidSession, AccessDenied, InconsistentParameters, InvalidHandle, UnsupportedLocale, UnsupportedMode, OperationFailed, MissingParameters, InvalidUserCategory, InvalidRegistration, UnsupportedMimeType {
            return BehaviorBackedServiceFactory.MARKUP;
        }
    }
}

