/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.test.protocol.v2.TestProducerBehavior;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.ExportDescription;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.ExtensionDescription;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.ItemDescription;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModelTypes;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.PropertyDescription;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceList;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.ServiceDescription;
import org.oasis.wsrp.v2.UserContext;
import org.oasis.wsrp.v2.WSRPV2ServiceDescriptionPortType;

public class ServiceDescriptionBehavior
extends TestProducerBehavior
implements WSRPV2ServiceDescriptionPortType {
    protected ServiceDescription serviceDescription;
    private static final ServiceDescription DEFAULT_SERVICE_DESCRIPTION = WSRPTypeFactory.createServiceDescription((boolean)false);
    public static final ServiceDescriptionBehavior DEFAULT = new ServiceDescriptionBehavior();
    protected List<PortletDescription> offeredPortlets = new LinkedList<PortletDescription>();
    private boolean requiresRegistration;
    private CookieProtocol cookieProtocol;
    private ModelDescription registrationProperties;

    public void setRequiresRegistration(boolean requiresRegistration) {
        this.requiresRegistration = requiresRegistration;
    }

    public void setRequiresInitCookie(CookieProtocol requiresInitCookie) {
        this.cookieProtocol = requiresInitCookie;
    }

    public void setServiceDescription(boolean requiresRegistration, int numberOfProps) {
        ServiceDescription sd = ServiceDescriptionBehavior.createServiceDescription(requiresRegistration, numberOfProps);
        this.offeredPortlets = sd.getOfferedPortlets();
        this.requiresRegistration = sd.isRequiresRegistration();
        this.registrationProperties = sd.getRegistrationPropertyDescription();
    }

    public static ServiceDescription getDefaultServiceDescription() {
        return DEFAULT_SERVICE_DESCRIPTION;
    }

    public void addPortletDescription(PortletDescription portletDescription) {
        this.offeredPortlets.add(portletDescription);
    }

    public Set<String> getPortletHandles() {
        HashSet<String> handles = new HashSet<String>(this.offeredPortlets.size());
        for (PortletDescription description : this.offeredPortlets) {
            handles.add(description.getPortletHandle());
        }
        return handles;
    }

    public int getPortletNumber() {
        return this.offeredPortlets.size();
    }

    public static ServiceDescription createServiceDescription(boolean requiresRegistration, int numberOfProperties) {
        ServiceDescription sd = WSRPTypeFactory.createServiceDescription((boolean)requiresRegistration);
        if (requiresRegistration) {
            ArrayList<PropertyDescription> descriptions = new ArrayList<PropertyDescription>(numberOfProperties);
            for (int i = 0; i < numberOfProperties; ++i) {
                descriptions.add(WSRPTypeFactory.createPropertyDescription((String)("prop" + i), (QName)WSRPConstants.XSD_STRING));
            }
            sd.setRegistrationPropertyDescription(WSRPTypeFactory.createModelDescription(descriptions));
        }
        return sd;
    }

    public void getServiceDescription(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RegistrationContext registrationContext, @WebParam(name="desiredLocales", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") List<String> desiredLocales, @WebParam(name="portletHandles", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") List<String> portletHandles, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") UserContext userContext, @WebParam(name="requiresRegistration", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<Boolean> requiresRegistration, @WebParam(name="offeredPortlets", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<PortletDescription>> offeredPortlets, @WebParam(name="userCategoryDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<ItemDescription>> userCategoryDescriptions, @WebParam(name="extensionDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<ExtensionDescription>> extensionDescriptions, @WebParam(name="customWindowStateDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<ItemDescription>> customWindowStateDescriptions, @WebParam(name="customModeDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<ItemDescription>> customModeDescriptions, @WebParam(name="requiresInitCookie", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<CookieProtocol> requiresInitCookie, @WebParam(name="registrationPropertyDescription", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<ModelDescription> registrationPropertyDescription, @WebParam(name="locales", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<String>> locales, @WebParam(name="resourceList", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<ResourceList> resourceList, @WebParam(name="eventDescriptions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<EventDescription>> eventDescriptions, @WebParam(name="schemaType", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<ModelTypes> schemaType, @WebParam(name="supportedOptions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<String>> supportedOptions, @WebParam(name="exportDescription", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<ExportDescription> exportDescription, @WebParam(name="mayReturnRegistrationState", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<Boolean> mayReturnRegistrationState, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<Extension>> extensions) throws InvalidRegistration, ModifyRegistrationRequired, OperationFailed, ResourceSuspended {
        this.incrementCallCount();
        offeredPortlets.value = this.offeredPortlets;
        requiresRegistration.value = this.requiresRegistration;
        requiresInitCookie.value = this.cookieProtocol;
        registrationPropertyDescription.value = this.registrationProperties;
    }
}

