/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v2;

import java.util.ArrayList;
import java.util.List;
import org.gatein.common.net.media.MediaType;
import org.gatein.wsrp.WSRPConstants;
import org.gatein.wsrp.WSRPTypeFactory;
import org.oasis.wsrp.v2.LocalizedString;
import org.oasis.wsrp.v2.MarkupType;
import org.oasis.wsrp.v2.PortletDescription;

public abstract class TestProducerBehavior {
    protected int callCount;
    public static final String SAMPLE_DESCRIPTION = "SampleDescription";
    public static final String SAMPLE_SHORTTITLE = "SampleShortTitle";
    public static final String SAMPLE_TITLE = "SampleTitle";
    public static final String SAMPLE_DISPLAYNAME = "SampleDisplayName";
    public static final String SAMPLE_KEYWORD = "keyword";

    public void incrementCallCount() {
        ++this.callCount;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public PortletDescription createPortletDescription(String portletHandle, String suffix) {
        String mimeType = MediaType.TEXT_HTML.getValue();
        ArrayList<String> modes = new ArrayList<String>();
        modes.add("wsrp:view");
        ArrayList<String> windowStates = new ArrayList<String>();
        windowStates.add("wsrp:normal");
        MarkupType markupType = WSRPTypeFactory.createMarkupType((String)mimeType, modes, windowStates, (List)WSRPConstants.getDefaultLocales());
        ArrayList<MarkupType> markupTypes = new ArrayList<MarkupType>();
        markupTypes.add(markupType);
        PortletDescription portletDesc = WSRPTypeFactory.createPortletDescription((String)portletHandle, markupTypes);
        portletDesc.getMarkupTypes().add(markupType);
        String suffixString = suffix == null ? "" : suffix;
        portletDesc.setDescription(TestProducerBehavior.createLocalizedString(SAMPLE_DESCRIPTION + suffixString));
        portletDesc.setTitle(TestProducerBehavior.createLocalizedString(SAMPLE_TITLE + suffixString));
        portletDesc.setShortTitle(TestProducerBehavior.createLocalizedString(SAMPLE_SHORTTITLE + suffixString));
        portletDesc.setDisplayName(TestProducerBehavior.createLocalizedString(SAMPLE_DISPLAYNAME + suffixString));
        portletDesc.getKeywords().add(TestProducerBehavior.createLocalizedString(SAMPLE_KEYWORD + suffixString));
        return portletDesc;
    }

    public static LocalizedString createLocalizedString(String value) {
        return WSRPTypeFactory.createLocalizedString((String)value);
    }

    public static String extractString(org.gatein.common.i18n.LocalizedString ls) {
        return ls.getPreferredOrBestLocalizedMappingFor(new String[]{"en"}).getString();
    }
}

