/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v2.behaviors;

import java.util.List;
import javax.jws.WebParam;
import javax.xml.ws.Holder;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.api.extensions.UnmarshalledExtension;
import org.gatein.wsrp.payload.PayloadUtils;
import org.gatein.wsrp.test.protocol.v2.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v2.MarkupBehavior;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletStateChangeRequired;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionMarkupBehavior
extends MarkupBehavior {
    public static final String PORTLET_HANDLE = "ExtensionMarkupBehavior";
    public static final String SIMPLE_SUCCESS = "Simple Success";
    public static final String ELEMENT_SUCCESS = "Element Success";
    public static final String FAILURE = "Failure!";
    public static final String EXPECTED_REQUEST_EXTENSION_VALUE = "foo";
    public static final String EXPECTED_RESPONSE_EXTENSION_VALUE = "bar";
    private static Element ELEMENT_RESPONSE;
    private Status status;

    public ExtensionMarkupBehavior(BehaviorRegistry registry) {
        super(registry);
        this.registerHandle(PORTLET_HANDLE);
    }

    @Override
    protected String getMarkupString(Mode mode, WindowState windowState, String navigationalState, GetMarkup getMarkup) throws UnsupportedWindowState, InvalidCookie, InvalidSession, AccessDenied, InconsistentParameters, InvalidHandle, UnsupportedLocale, UnsupportedMode, OperationFailed, MissingParameters, InvalidUserCategory, InvalidRegistration, UnsupportedMimeType {
        this.status = Status.failure;
        this.getStatus(getMarkup.getMarkupParams().getExtensions());
        return this.status.markup;
    }

    @Override
    public void modifyResponseIfNeeded(MarkupResponse markupResponse) {
        List extensions = markupResponse.getExtensions();
        this.addExtensions(extensions);
    }

    private void addExtensions(List<Extension> extensions) {
        if (!Status.failure.equals((Object)this.status)) {
            extensions.add(WSRPTypeFactory.createExtension((Object)PayloadUtils.marshallExtension((Object)this.status.response)));
        }
    }

    @Override
    public void performBlockingInteraction(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") MarkupParams markupParams, @WebParam(name="interactionParams", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") InteractionParams interactionParams, @WebParam(name="updateResponse", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<UpdateResponse> updateResponse, @WebParam(name="redirectURL", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<String> redirectURL, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, PortletStateChangeRequired, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        this.status = Status.failure;
        this.getStatus(interactionParams.getExtensions());
        UpdateResponse ur = WSRPTypeFactory.createUpdateResponse();
        updateResponse.value = ur;
        List responseExtensions = ur.getExtensions();
        this.addExtensions(responseExtensions);
        extensions.value = responseExtensions;
    }

    private void getStatus(List<Extension> requestExtensions) {
        if (!requestExtensions.isEmpty()) {
            Extension extension = requestExtensions.get(0);
            UnmarshalledExtension unmarshalledExtension = PayloadUtils.unmarshallExtension((Object)extension.getAny());
            if (unmarshalledExtension.isElement()) {
                Element element = (Element)unmarshalledExtension.getValue();
                if (EXPECTED_REQUEST_EXTENSION_VALUE.equals(element.getTextContent())) {
                    this.status = Status.element;
                }
            } else {
                String foo = (String)unmarshalledExtension.getValue();
                if (EXPECTED_REQUEST_EXTENSION_VALUE.equals(foo)) {
                    this.status = Status.simple;
                }
            }
        }
    }

    static /* synthetic */ Element access$000() {
        return ELEMENT_RESPONSE;
    }

    static {
        String namespaceURI = "urn:bea:wsrp:ext:v1:types";
        ELEMENT_RESPONSE = PayloadUtils.createElement((String)"urn:bea:wsrp:ext:v1:types", (String)"MarkupResponseState");
        Node state = ELEMENT_RESPONSE.getOwnerDocument().createElementNS("urn:bea:wsrp:ext:v1:types", "state");
        state = ELEMENT_RESPONSE.appendChild(state);
        state.setTextContent(EXPECTED_RESPONSE_EXTENSION_VALUE);
    }

    private static enum Status {
        simple("Simple Success", "bar"),
        element("Element Success", ExtensionMarkupBehavior.access$000()),
        failure("Failure!", null);

        private final String markup;
        private final Object response;

        private Status(String markup, Object response) {
            this.markup = markup;
            this.response = response;
        }
    }
}

