/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.test.protocol.v2.behaviors;

import java.util.List;
import javax.jws.WebParam;
import javax.xml.ws.Holder;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.test.protocol.v2.BehaviorRegistry;
import org.gatein.wsrp.test.protocol.v2.MarkupBehavior;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MarkupParams;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletStateChangeRequired;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.RuntimeContext;
import org.oasis.wsrp.v2.SessionContext;
import org.oasis.wsrp.v2.SessionParams;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;
import org.oasis.wsrp.v2.UpdateResponse;
import org.oasis.wsrp.v2.UserContext;

public class SessionMarkupBehavior
extends MarkupBehavior {
    public static final String PORTLET_HANDLE = "SecondPortletHandle";
    public static final String SESSION_ID = "sessionID";
    public static final String NS = "ns2";
    private int count = 0;
    private String sessionId;

    public SessionMarkupBehavior(BehaviorRegistry registry) {
        super(registry);
        this.registerHandle(PORTLET_HANDLE);
    }

    @Override
    public String getMarkupString(Mode mode, WindowState windowState, String navigationalState, GetMarkup getMarkup) {
        StringBuffer markupString = new StringBuffer("portlet2:");
        SessionParams sessionParams = getMarkup.getRuntimeContext().getSessionParams();
        this.sessionId = sessionParams != null ? sessionParams.getSessionID() : null;
        if (SESSION_ID.equals(this.sessionId)) {
            ++this.count;
        }
        markupString.append(this.count).append(":");
        markupString.append(mode).append(":").append(windowState);
        if (navigationalState != null) {
            markupString.append(":").append(navigationalState);
        }
        return markupString.toString();
    }

    @Override
    public void performBlockingInteraction(@WebParam(name="registrationContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RegistrationContext registrationContext, @WebParam(name="portletContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") PortletContext portletContext, @WebParam(name="runtimeContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") RuntimeContext runtimeContext, @WebParam(name="userContext", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") UserContext userContext, @WebParam(name="markupParams", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") MarkupParams markupParams, @WebParam(name="interactionParams", targetNamespace="urn:oasis:names:tc:wsrp:v2:types") InteractionParams interactionParams, @WebParam(name="updateResponse", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<UpdateResponse> updateResponse, @WebParam(name="redirectURL", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<String> redirectURL, @WebParam(name="extensions", targetNamespace="urn:oasis:names:tc:wsrp:v2:types", mode=WebParam.Mode.OUT) Holder<List<Extension>> extensions) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, PortletStateChangeRequired, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        UpdateResponse ur = WSRPTypeFactory.createUpdateResponse();
        ur.setNavigationalContext(WSRPTypeFactory.createNavigationalContextOrNull((StateString)new OpaqueStateString(NS), null));
        updateResponse.value = ur;
        extensions.value = ur.getExtensions();
    }

    @Override
    public void modifyResponseIfNeeded(MarkupResponse markupResponse) {
        if (this.count == 0 || SESSION_ID.equals(this.sessionId)) {
            SessionContext sessionContext = WSRPTypeFactory.createSessionContext((String)SESSION_ID, (int)30);
            markupResponse.setSessionContext(sessionContext);
        }
    }

    @Override
    protected String getSuffixFor(String handle) {
        return "2";
    }
}

