/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.bridge.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.faces.BridgeException;
import org.jboss.portletbridge.bridge.factory.BridgeFactory;

public final class BridgeFactoryFinder {
    private static final Logger logger = Logger.getLogger(BridgeFactoryFinder.class.getName(), "org.jboss.portletbridge.LogMessages");
    private static Map<Class<?>, List<String>> factoryDefinitions = new HashMap(6);
    private static Map<Class<?>, BridgeFactory<?>> factoryInstances = new HashMap(6);
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    private BridgeFactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFactoryDefinition(Class<? extends BridgeFactory<?>> type, String factoryImplClassName) {
        lock.writeLock().lock();
        try {
            List<String> defs = factoryDefinitions.get(type);
            if (defs == null) {
                defs = new ArrayList<String>(4);
                factoryDefinitions.put(type, defs);
            }
            if (!defs.contains(factoryImplClassName)) {
                defs.add(factoryImplClassName);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFactoryDefinition(Class<? extends BridgeFactory<?>> type) {
        lock.readLock().lock();
        try {
            List<String> list = factoryDefinitions.get(type);
            return list;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFactoryInstance(Class<? extends BridgeFactory<?>> type, BridgeFactory<?> factoryInstance) {
        lock.writeLock().lock();
        try {
            factoryInstances.put(type, factoryInstance);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridgeFactory<?> getFactoryInstance(Class<? extends BridgeFactory<?>> type) {
        BridgeFactory<?> instance;
        lock.readLock().lock();
        try {
            instance = factoryInstances.get(type);
            if (instance != null) {
                BridgeFactory<?> bridgeFactory = instance;
                return bridgeFactory;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        lock.writeLock().lock();
        try {
            instance = factoryInstances.get(type);
            if (instance != null) {
                BridgeFactory<?> bridgeFactory = instance;
                return bridgeFactory;
            }
            List<String> defs = BridgeFactoryFinder.getFactoryDefinition(type);
            if (defs == null) {
                logger.log(Level.SEVERE, "No Factory Implementation class specified in faces-config for " + type);
                BridgeFactory<?> bridgeFactory = null;
                return bridgeFactory;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            for (String factoryImplClassName : defs) {
                instance = BridgeFactoryFinder.getImplGivenPreviousImpl(cl, factoryImplClassName, type, instance);
            }
            BridgeFactoryFinder.addFactoryInstance(type, instance);
            BridgeFactory<?> bridgeFactory = instance;
            return bridgeFactory;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static BridgeFactory<?> getImplGivenPreviousImpl(ClassLoader classLoader, String implName, Class<? extends BridgeFactory<?>> type, BridgeFactory<?> previousImpl) {
        Class<BridgeFactory<?>> implClass = null;
        try {
            implClass = classLoader.loadClass(implName).asSubclass(type);
            try {
                Constructor<BridgeFactory<?>> constructor = implClass.getConstructor(BridgeFactory.class);
                previousImpl = constructor.newInstance(previousImpl);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("New factory instance " + implName + " has been created with parent implementation");
                }
            }
            catch (NoSuchMethodException e) {
                Constructor<BridgeFactory<?>> constructor = implClass.getConstructor(new Class[0]);
                previousImpl = constructor.newInstance(new Object[0]);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("New factory instance " + implName + " has been created");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new BridgeException("Bridge Factory class " + implName + " not found");
        }
        catch (NoSuchMethodException e) {
            throw new BridgeException("Bridge Factory " + implName + " has neither BridgeFactory() nor BridgeFactory(BridgeFactory) constructor");
        }
        catch (IllegalArgumentException e) {
            throw new BridgeException("Illegal argument for Bridge Factory " + implName + " constructor", e);
        }
        catch (InstantiationException e) {
            throw new BridgeException("Can't instantiate Bridge Factory class " + implName, e);
        }
        catch (IllegalAccessException e) {
            throw new BridgeException("Illegal access to Bridge Factory constructor", e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof NoClassDefFoundError) {
                logger.info("Bridge Factory was not instantiated due to " + targetException.getMessage());
            }
            throw new BridgeException("Can't instantiate Bridge Factory class " + implName, targetException);
        }
        catch (NoClassDefFoundError e) {
            logger.info("Bridge Factory was not instantiated due to " + e.getMessage());
        }
        return previousImpl;
    }
}

