/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.cxf;

import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.gatein.wsrp.cxf.FeatureIntegratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRPEndpointFeature
extends AbstractFeature {
    private static Logger log = LoggerFactory.getLogger(WSRPEndpointFeature.class);
    FeatureIntegratorFactory featureIntergrator;

    public WSRPEndpointFeature() {
        log.debug("Construct WSRPEndpointFeature");
        this.featureIntergrator = FeatureIntegratorFactory.getInstance();
    }

    public void initialize(Bus bus) {
        for (AbstractFeature feature : this.featureIntergrator.getFeatures()) {
            log.debug("Initializing Bus with " + feature.toString());
            feature.initialize(bus);
        }
    }

    public void initialize(Client client, Bus bus) {
        for (AbstractFeature feature : this.featureIntergrator.getFeatures()) {
            log.debug("Initializing Client with " + feature.toString());
            feature.initialize(client, bus);
        }
    }

    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        for (AbstractFeature feature : this.featureIntergrator.getFeatures()) {
            log.debug("Initializing InterceptorProvider with " + feature.toString());
            feature.initialize(interceptorProvider, bus);
        }
    }

    public void initialize(Server server, Bus bus) {
        for (AbstractFeature feature : this.featureIntergrator.getFeatures()) {
            log.debug("Initializing Server with " + feature.toString());
            feature.initialize(server, bus);
        }
    }
}

