/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.ExtendedEntityManagerKey;
import org.jboss.as.jpa.transaction.TransactionUtil;

public class ExtendedEntityManager
extends AbstractEntityManager
implements Serializable {
    private static final long serialVersionUID = 432437L;
    private EntityManager underlyingEntityManager;
    private String puScopedName;
    private transient boolean isInTx;
    private final ExtendedEntityManagerKey ID = ExtendedEntityManagerKey.extendedEntityManagerID();
    private final transient boolean isTraceEnabled = JpaLogger.ROOT_LOGGER.isTraceEnabled();

    public ExtendedEntityManager(String puScopedName, EntityManager underlyingEntityManager) {
        this.underlyingEntityManager = underlyingEntityManager;
        this.puScopedName = puScopedName;
    }

    @Override
    protected EntityManager getEntityManager() {
        this.internalAssociateWithJtaTx();
        return this.underlyingEntityManager;
    }

    public void internalAssociateWithJtaTx() {
        this.isInTx = TransactionUtil.isInTx();
        if (this.isInTx) {
            EntityManager existing = TransactionUtil.getTransactionScopedEntityManager(this.puScopedName);
            if (existing != null && existing != this) {
                throw JpaMessages.MESSAGES.cannotUseExtendedPersistenceTransaction(this.puScopedName, existing, (EntityManager)this);
            }
            if (existing == null) {
                TransactionUtil.registerExtendedUnderlyingWithTransaction(this.puScopedName, this, this.underlyingEntityManager);
            }
        }
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return true;
    }

    @Override
    protected boolean isInTx() {
        return this.isInTx;
    }

    @Override
    public void close() {
        throw JpaMessages.MESSAGES.cannotCloseContainerManagedEntityManager();
    }

    public void containerClose() {
        if (this.underlyingEntityManager.isOpen()) {
            this.underlyingEntityManager.close();
            if (this.isTraceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("closed extended persistence context for pu = %s", (Object)this.puScopedName);
            }
        }
    }

    public String toString() {
        return "ExtendedEntityManager [" + this.puScopedName + "]";
    }

    public String getScopedPuName() {
        return this.puScopedName;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        ExtendedEntityManager that = (ExtendedEntityManager)otherObject;
        return this.ID.equals(that.ID);
    }

    public int hashCode() {
        return this.ID != null ? this.ID.hashCode() : 0;
    }
}

