/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractLoggingInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected int limit = 102400;
    protected PrintWriter writer;
    protected boolean prettyLogging;

    public AbstractLoggingInterceptor(String phase) {
        super(phase);
    }

    public AbstractLoggingInterceptor(String id, String phase) {
        super(id, phase);
    }

    protected abstract Logger getLogger();

    public void setOutputLocation(String s) {
        if (s == null || "<logger>".equals(s)) {
            this.writer = null;
        } else if ("<stdout>".equals(s)) {
            this.writer = new PrintWriter(System.out, true);
        } else if ("<stderr>".equals(s)) {
            this.writer = new PrintWriter(System.err, true);
        } else {
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                this.writer = new PrintWriter((Writer)new FileWriter(file, true), true);
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, "Error configuring log location " + s, ex);
            }
        }
    }

    public void setPrintWriter(PrintWriter w) {
        this.writer = w;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setPrettyLogging(boolean flag) {
        this.prettyLogging = flag;
    }

    public boolean isPrettyLogging() {
        return this.prettyLogging;
    }

    protected void writePayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (this.isPrettyLogging() && contentType != null && contentType.indexOf("xml") >= 0 && cos.size() > 0) {
            Transformer serializer = XMLUtils.newTransformer((int)2);
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter swriter = new StringWriter();
            serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
            String result = swriter.toString();
            if (result.length() < this.limit || this.limit == -1) {
                builder.append(swriter.toString());
            } else {
                builder.append(swriter.toString().substring(0, this.limit));
            }
        } else if (StringUtils.isEmpty((String)encoding)) {
            cos.writeCacheTo(builder, this.limit);
        } else {
            cos.writeCacheTo(builder, encoding, this.limit);
        }
    }

    protected String transform(String originalLogString) {
        return originalLogString;
    }

    protected void log(String message) {
        message = this.transform(message);
        if (this.writer != null) {
            this.writer.println(message);
            this.writer.flush();
        } else if (this.getLogger().isLoggable(Level.INFO)) {
            this.getLogger().info(message);
        }
    }
}

