/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.interceptor.security.AbstractAuthorizingInInterceptor;

public class SimpleAuthorizingInterceptor
extends AbstractAuthorizingInInterceptor {
    private Map<String, List<String>> methodRolesMap = Collections.emptyMap();
    private List<String> globalRoles = Collections.emptyList();

    protected String createMethodSig(Method method) {
        StringBuilder b = new StringBuilder(method.getReturnType().getName());
        b.append(' ').append(method.getName()).append('(');
        boolean first = true;
        for (Class<?> cls : method.getParameterTypes()) {
            if (!first) {
                b.append(", ");
                first = false;
            }
            b.append(cls.getName());
        }
        b.append(')');
        return b.toString();
    }

    @Override
    protected List<String> getExpectedRoles(Method method) {
        List<String> roles = this.methodRolesMap.get(this.createMethodSig(method));
        if (roles == null) {
            roles = this.methodRolesMap.get(method.getName());
        }
        if (roles != null) {
            return roles;
        }
        return this.globalRoles;
    }

    public void setMethodRolesMap(Map<String, String> rolesMap) {
        this.methodRolesMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : rolesMap.entrySet()) {
            this.methodRolesMap.put(entry.getKey(), Arrays.asList(entry.getValue().split(" ")));
        }
    }

    public void setGlobalRoles(String roles) {
        this.globalRoles = Arrays.asList(roles.split(" "));
    }
}

