/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;

public class RMInInterceptor
extends AbstractRMInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(RMInInterceptor.class);

    public RMInInterceptor() {
        this.addBefore(MAPAggregator.class.getName());
    }

    public void handleFault(Message message) {
        message.put((Object)MAPAggregator.class.getName(), (Object)true);
        if (MessageUtils.isTrue((Object)message.get((Object)"org.apache.cxf.oneway.robust.delivering"))) {
            Destination destination = this.getManager().getDestination(message);
            destination.releaseDeliveringStatus(message);
        }
    }

    @Override
    protected void handle(Message message) throws SequenceFault, RMException {
        Object originalRequestor;
        LOG.entering(((Object)((Object)this)).getClass().getName(), "handleMessage");
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, false);
        if (null == maps) {
            return;
        }
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        if (null != (originalRequestor = message.get((Object)"org.apache.cxf.client.original"))) {
            LOG.fine("Restoring original requestor role to: " + originalRequestor);
            message.put((Object)"org.apache.cxf.client", originalRequestor);
        }
        boolean isServer = RMContextUtils.isServerSide(message);
        LOG.fine("isServerSide: " + isServer);
        boolean isApplicationMessage = !RMContextUtils.isRMProtocolMessage(action);
        LOG.fine("isApplicationMessage: " + isApplicationMessage);
        RMEndpoint rme = this.getManager().getReliableEndpoint(message);
        Destination destination = this.getManager().getDestination(message);
        if (isApplicationMessage) {
            if (null != rmps) {
                this.processAcknowledgments(rme.getSource(), rmps);
                this.processAcknowledgmentRequests(destination, message);
                this.processSequence(destination, message);
                this.processDeliveryAssurance(rmps);
            }
            if (ContextUtils.retrieveDeferredUncorrelatedMessageAbort((Message)message)) {
                LOG.info("deferred uncorrelated message abort");
                message.getInterceptorChain().abort();
            } else {
                rme.receivedApplicationMessage();
            }
        } else {
            rme.receivedControlMessage();
            if (RMConstants.getSequenceAckAction().equals(action)) {
                this.processAcknowledgments(rme.getSource(), rmps);
            } else if (RMConstants.getLastMessageAction().equals(action)) {
                this.processSequence(destination, message);
            } else if (RMConstants.getCreateSequenceAction().equals(action) && !isServer) {
                LOG.fine("Processing inbound CreateSequence on client side.");
                Servant servant = rme.getServant();
                CreateSequenceResponseType csr = servant.createSequence(message);
                Proxy proxy = rme.getProxy();
                proxy.createSequenceResponse(csr);
                return;
            }
        }
        this.assertReliability(message);
    }

    void processAcknowledgments(Source source, RMProperties rmps) throws SequenceFault, RMException {
        Collection<SequenceAcknowledgement> acks = rmps.getAcks();
        if (null != acks) {
            for (SequenceAcknowledgement ack : acks) {
                Identifier id = ack.getIdentifier();
                SourceSequence ss = source.getSequence(id);
                if (null != ss) {
                    ss.setAcknowledged(ack);
                    continue;
                }
                throw new SequenceFaultFactory().createUnknownSequenceFault(id);
            }
        }
    }

    void processAcknowledgmentRequests(Destination destination, Message message) throws SequenceFault, RMException {
        destination.ackRequested(message);
    }

    void processSequence(Destination destination, Message message) throws SequenceFault, RMException {
        boolean robust = MessageUtils.isTrue((Object)message.getContextualProperty("org.apache.cxf.oneway.robust"));
        if (robust) {
            message.put((Object)"org.apache.cxf.oneway.robust.delivering", (Object)Boolean.TRUE);
        }
        destination.acknowledge(message);
    }

    void processDeliveryAssurance(RMProperties rmps) {
    }
}

