/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.pc.api.ActionURL;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.ResourceURL;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.embed.Page;
import org.gatein.pc.embed.Query;
import org.gatein.pc.embed.Segment;
import org.gatein.pc.embed.Window;
import org.gatein.pc.portlet.impl.spi.AbstractPortletInvocationContext;

class EmbedInvocationContext
extends AbstractPortletInvocationContext {
    private final Page page;
    private final HttpServletRequest clientRequest;
    private final HttpServletResponse clientResponse;
    private final Window target;
    final String baseURL;
    final String servletPath;

    EmbedInvocationContext(Page page, Window target, HttpServletRequest clientRequest, HttpServletResponse clientResponse) {
        StringBuilder baseURL = new StringBuilder();
        baseURL.append(clientRequest.getScheme()).append("://").append(clientRequest.getServerName());
        int port = clientRequest.getServerPort();
        if (port != 80) {
            baseURL.append(':').append(port);
        }
        baseURL.append(clientRequest.getContextPath());
        this.page = page;
        this.clientRequest = clientRequest;
        this.clientResponse = clientResponse;
        this.baseURL = baseURL.toString();
        this.target = target;
        this.servletPath = clientRequest.getServletPath();
    }

    public HttpServletRequest getClientRequest() throws IllegalStateException {
        return this.clientRequest;
    }

    public HttpServletResponse getClientResponse() throws IllegalStateException {
        return this.clientResponse;
    }

    public String renderURL(ContainerURL containerURL, URLFormat format) {
        Segment head;
        Map changes;
        LinkedHashMap<String, String[]> pageParameters;
        LinkedHashMap<String, Object> linkedHashMap = pageParameters = this.page.parameters != null ? new LinkedHashMap<String, String[]>(this.page.parameters) : new LinkedHashMap();
        if (containerURL instanceof RenderURL && (changes = ((RenderURL)containerURL).getPublicNavigationalStateChanges()) != null) {
            for (Map.Entry change : changes.entrySet()) {
                if (change.getValue() == null || ((String[])change.getValue()).length == 0) {
                    pageParameters.remove(change.getKey());
                    continue;
                }
                pageParameters.put((String)change.getKey(), (String[])change.getValue());
            }
        }
        HashMap<Window, Map> parameterMap = new HashMap<Window, Map>();
        HashMap<Window, Mode> modeMap = new HashMap<Window, Mode>();
        HashMap<Window, WindowState> windowStateMap = new HashMap<Window, WindowState>();
        for (Window window : this.page.windows.values()) {
            if (window.parameters != null) {
                parameterMap.put(window, window.parameters);
            }
            if (window.mode != null) {
                modeMap.put(window, window.mode);
            }
            if (window.state == null) continue;
            windowStateMap.put(window, window.state);
        }
        if (containerURL instanceof RenderURL) {
            if (containerURL.getNavigationalState() != null) {
                parameterMap.put(this.target, ((ParametersStateString)containerURL.getNavigationalState()).getParameters());
            }
            if (containerURL.getMode() != null) {
                modeMap.put(this.target, containerURL.getMode());
            }
            if (containerURL.getWindowState() != null) {
                windowStateMap.put(this.target, containerURL.getWindowState());
            }
        }
        Segment tail = head = new Segment(this.servletPath.substring(1), pageParameters);
        for (Window window : this.page.windows.values()) {
            WindowState windowState;
            Mode mode;
            HashMap<String, String[]> parameters = (HashMap<String, String[]>)parameterMap.get(window);
            if (parameters != null) {
                parameters = new HashMap<String, String[]>(parameters);
            }
            if ((mode = (Mode)modeMap.get(window)) != null && !Mode.VIEW.equals((Object)mode)) {
                parameters.put("javax.portlet.portlet_mode", new String[]{mode.toString()});
            }
            if ((windowState = (WindowState)windowStateMap.get(window)) != null && !WindowState.NORMAL.equals((Object)windowState)) {
                parameters.put("javax.portlet.window_state", new String[]{windowState.toString()});
            }
            tail.next = new Segment(window.name, parameters);
            tail = (Segment)tail.next;
        }
        if (containerURL instanceof ActionURL) {
            ActionURL actionURL = (ActionURL)containerURL;
            Mode mode = containerURL.getMode();
            WindowState windowState = containerURL.getWindowState();
            Map<String, String[]> parameters = actionURL.getInteractionState() != null ? ((ParametersStateString)actionURL.getInteractionState()).getParameters() : new HashMap();
            parameters.put("javax.portlet.phase", new String[]{"action"});
            parameters.put("javax.portlet.id", new String[]{this.target.id});
            if (mode != null && !Mode.VIEW.equals((Object)mode)) {
                parameters.put("javax.portlet.portlet_mode", new String[]{mode.toString()});
            }
            if (windowState != null && !WindowState.NORMAL.equals((Object)windowState)) {
                parameters.put("javax.portlet.window_state", new String[]{windowState.toString()});
            }
            tail.next = new Query(parameters);
        } else if (containerURL instanceof ResourceURL) {
            ResourceURL resourceURL = (ResourceURL)containerURL;
            Map<String, String[]> parameters = resourceURL.getResourceState() != null ? ((ParametersStateString)resourceURL.getResourceState()).getParameters() : new HashMap();
            parameters.put("javax.portlet.phase", new String[]{"resource"});
            parameters.put("javax.portlet.id", new String[]{this.target.id});
            String resource = resourceURL.getResourceId();
            if (resource != null) {
                parameters.put("javax.portlet.resource", new String[]{resource});
            }
            tail.next = new Query(parameters);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseURL);
        head.writeTo(sb, Boolean.TRUE == format.getWantEscapeXML() ? "&amp;" : "&");
        return sb.toString();
    }
}

