/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.util.SimpleMultiValuedPropertyMap;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.RenderURL;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.ClientContext;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.embed.EmbedInvocationContext;
import org.gatein.pc.embed.Page;
import org.gatein.pc.embed.Window;
import org.gatein.pc.portlet.impl.spi.AbstractClientContext;
import org.gatein.pc.portlet.impl.spi.AbstractInstanceContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortalContext;
import org.gatein.pc.portlet.impl.spi.AbstractRequestContext;
import org.gatein.pc.portlet.impl.spi.AbstractSecurityContext;
import org.gatein.pc.portlet.impl.spi.AbstractServerContext;
import org.gatein.pc.portlet.impl.spi.AbstractUserContext;
import org.gatein.pc.portlet.impl.spi.AbstractWindowContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

enum EmbedPhase {
    RENDER{

        @Override
        void service(Page page, PortletInvoker invoker, HashMap<String, String[]> parameters, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
            StringBuilder body = new StringBuilder();
            body.append("<body>\n");
            body.append("<ul>\n");
            StringBuilder head = new StringBuilder();
            head.append("<head>\n");
            SimpleMultiValuedPropertyMap httpHeaders = new SimpleMultiValuedPropertyMap();
            ArrayList cookies = new ArrayList();
            for (Window window : page.windows.values()) {
                List elements;
                MultiValuedPropertyMap markupHeaders;
                PortletInvocationResponse response;
                RenderInvocation render = new RenderInvocation((PortletInvocationContext)new EmbedInvocationContext(page, window, req, resp));
                render.setTarget(window.portlet.getContext());
                render.setRequest(req);
                render.setResponse(resp);
                render.setUserContext((UserContext)new AbstractUserContext(req));
                render.setWindowContext((WindowContext)new AbstractWindowContext("" + window.id));
                render.setServerContext((ServerContext)new AbstractServerContext(req, resp));
                render.setSecurityContext((SecurityContext)new AbstractSecurityContext(req));
                render.setClientContext((ClientContext)new AbstractClientContext(req));
                render.setPortalContext((PortalContext)new AbstractPortalContext());
                render.setInstanceContext((InstanceContext)new AbstractInstanceContext("" + window.id));
                render.setWindowState(window.state != null ? window.state : WindowState.NORMAL);
                render.setMode(window.mode != null ? window.mode : Mode.VIEW);
                render.setNavigationalState(window.parameters != null ? ParametersStateString.create(window.parameters) : null);
                render.setPublicNavigationalState(page.parameters);
                try {
                    response = invoker.invoke((PortletInvocation)render);
                }
                catch (PortletInvokerException e) {
                    throw new ServletException((Throwable)e);
                }
                if (response instanceof ErrorResponse) {
                    throw EmbedPhase.createException(window, (ErrorResponse)response);
                }
                if (!(response instanceof FragmentResponse)) continue;
                FragmentResponse fragment = (FragmentResponse)response;
                body.append("<li>");
                body.append(fragment.getContent(UTF_8));
                body.append("</li>\n");
                ResponseProperties props = fragment.getProperties();
                if (props == null) continue;
                if (props.getCookies() != null) {
                    cookies.addAll(props.getCookies());
                }
                if (props.getTransportHeaders() != null) {
                    httpHeaders.append(props.getTransportHeaders());
                }
                if ((markupHeaders = props.getMarkupHeaders()) == null || (elements = markupHeaders.getValues("javax.portlet.markup.head.element")) == null) continue;
                for (Element element : elements) {
                    String name = element.getTagName().toLowerCase();
                    if ("title".equals(name)) {
                        head.append("<title>");
                        EmbedPhase.appendText(element, head);
                        head.append("</title>");
                        continue;
                    }
                    if ("link".equals(name)) {
                        head.append("<link");
                        EmbedPhase.appendAttribute(element, "charset", head);
                        EmbedPhase.appendAttribute(element, "href", head);
                        EmbedPhase.appendAttribute(element, "media", head);
                        EmbedPhase.appendAttribute(element, "rel", head);
                        EmbedPhase.appendAttribute(element, "type", head);
                        head.append("/>");
                        continue;
                    }
                    if ("meta".equals(name)) {
                        head.append("<meta");
                        EmbedPhase.appendAttribute(element, "http-equiv", head);
                        EmbedPhase.appendAttribute(element, "name", head);
                        EmbedPhase.appendAttribute(element, "content", head);
                        head.append("/>");
                        continue;
                    }
                    if ("script".equals(name)) {
                        head.append("<script");
                        EmbedPhase.appendAttribute(element, "type", head);
                        EmbedPhase.appendAttribute(element, "src", head);
                        head.append("></script>");
                        continue;
                    }
                    if (!"style".equals(name)) continue;
                    head.append("<style");
                    EmbedPhase.appendAttribute(element, "type", head);
                    EmbedPhase.appendAttribute(element, "media", head);
                    head.append(">");
                    EmbedPhase.appendText(element, head);
                    head.append("</style>");
                }
            }
            body.append("</ul>\n");
            body.append("</body>\n");
            head.append("</head>");
            resp.setStatus(200);
            resp.setContentType("text/html;charset=utf-8");
            EmbedPhase.sendHttpHeaders((MultiValuedPropertyMap<String>)((MultiValuedPropertyMap)httpHeaders), resp);
            EmbedPhase.sendCookies(cookies, resp);
            PrintWriter writer = resp.getWriter();
            writer.append("<!DOCTYPE html>\n");
            writer.append("<html>\n");
            writer.append(head);
            writer.append(body);
            writer.append("</html>\n");
            writer.close();
        }
    }
    ,
    ACTION{

        @Override
        void service(Page page, PortletInvoker invoker, HashMap<String, String[]> parameters, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            PortletInvocationResponse response;
            Mode mode;
            String id = parameters.remove("javax.portlet.id")[0];
            Window window = page.windows.get(id);
            EmbedInvocationContext context = new EmbedInvocationContext(page, window, req, resp);
            ActionInvocation action = new ActionInvocation((PortletInvocationContext)context);
            String[] modeParameter = parameters.remove("javax.portlet.portlet_mode");
            String[] windowStateParameter = parameters.remove("javax.portlet.window_state");
            Mode mode2 = modeParameter != null ? Mode.create((String)modeParameter[0]) : (mode = window.mode != null ? window.mode : Mode.VIEW);
            WindowState windowState = windowStateParameter != null ? WindowState.create((String)windowStateParameter[0]) : (window.state != null ? window.state : WindowState.NORMAL);
            action.setTarget(window.portlet.getContext());
            action.setRequest(req);
            action.setResponse(resp);
            action.setRequestContext((RequestContext)new AbstractRequestContext(req));
            action.setUserContext((UserContext)new AbstractUserContext(req));
            action.setWindowContext((WindowContext)new AbstractWindowContext("" + window.id));
            action.setServerContext((ServerContext)new AbstractServerContext(req, resp));
            action.setSecurityContext((SecurityContext)new AbstractSecurityContext(req));
            action.setClientContext((ClientContext)new AbstractClientContext(req));
            action.setPortalContext((PortalContext)new AbstractPortalContext());
            action.setInstanceContext((InstanceContext)new AbstractInstanceContext("" + window.id));
            action.setWindowState(windowState);
            action.setMode(mode);
            action.setNavigationalState(window.parameters != null ? ParametersStateString.create(window.parameters) : null);
            action.setInteractionState((StateString)ParametersStateString.create(parameters));
            action.setPublicNavigationalState(page.parameters);
            try {
                response = invoker.invoke((PortletInvocation)action);
            }
            catch (PortletInvokerException e) {
                throw new ServletException("Unexpected exception", (Throwable)e);
            }
            if (response instanceof ErrorResponse) {
                throw EmbedPhase.createException(window, (ErrorResponse)response);
            }
            if (response instanceof UpdateNavigationalStateResponse) {
                final UpdateNavigationalStateResponse update = (UpdateNavigationalStateResponse)response;
                RenderURL url = new RenderURL(){

                    public Map<String, String[]> getPublicNavigationalStateChanges() {
                        return update.getPublicNavigationalStateUpdates();
                    }

                    public Mode getMode() {
                        return update.getMode();
                    }

                    public WindowState getWindowState() {
                        return update.getWindowState();
                    }

                    public StateString getNavigationalState() {
                        return update.getNavigationalState();
                    }

                    public Map<String, String> getProperties() {
                        return Collections.emptyMap();
                    }
                };
                String uri = context.renderURL((ContainerURL)url, URL_FORMAT);
                ResponseProperties properties = update.getProperties();
                EmbedPhase.sendHttpHeaders(properties, resp);
                EmbedPhase.sendCookies(properties, resp);
                resp.sendRedirect(uri);
            } else if (response instanceof HTTPRedirectionResponse) {
                HTTPRedirectionResponse redirect = (HTTPRedirectionResponse)response;
                resp.sendRedirect(redirect.getLocation());
            } else {
                throw new ServletException("Not yet implemented " + response.getClass().getSimpleName());
            }
        }
    }
    ,
    RESOURCE{

        @Override
        void service(Page page, PortletInvoker invoker, HashMap<String, String[]> parameters, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
            PortletInvocationResponse response;
            String id = parameters.remove("javax.portlet.id")[0];
            Window window = page.windows.get(id);
            EmbedInvocationContext context = new EmbedInvocationContext(page, window, req, resp);
            ResourceInvocation resource = new ResourceInvocation((PortletInvocationContext)context);
            String[] resourceId = parameters.remove("javax.portlet.resource");
            resource.setTarget(window.portlet.getContext());
            resource.setRequest(req);
            resource.setResponse(resp);
            resource.setRequestContext((RequestContext)new AbstractRequestContext(req));
            resource.setUserContext((UserContext)new AbstractUserContext(req));
            resource.setWindowContext((WindowContext)new AbstractWindowContext("" + window.id));
            resource.setServerContext((ServerContext)new AbstractServerContext(req, resp));
            resource.setSecurityContext((SecurityContext)new AbstractSecurityContext(req));
            resource.setClientContext((ClientContext)new AbstractClientContext(req));
            resource.setPortalContext((PortalContext)new AbstractPortalContext());
            resource.setInstanceContext((InstanceContext)new AbstractInstanceContext("" + window.id));
            resource.setWindowState(window.state != null ? window.state : WindowState.NORMAL);
            resource.setMode(window.mode != null ? window.mode : Mode.VIEW);
            resource.setNavigationalState(window.parameters != null ? ParametersStateString.create(window.parameters) : null);
            resource.setResourceState((StateString)ParametersStateString.create(parameters));
            resource.setPublicNavigationalState(page.parameters);
            resource.setResourceId(resourceId != null ? resourceId[0] : null);
            try {
                response = invoker.invoke((PortletInvocation)resource);
            }
            catch (PortletInvokerException e) {
                throw new ServletException("Unexpected exception", (Throwable)e);
            }
            if (response instanceof ErrorResponse) {
                throw EmbedPhase.createException(window, (ErrorResponse)response);
            }
            if (response instanceof ContentResponse) {
                String encoding;
                String value;
                MultiValuedPropertyMap headers;
                ContentResponse contentResponse = (ContentResponse)response;
                ResponseProperties properties = contentResponse.getProperties();
                int status = 200;
                MultiValuedPropertyMap multiValuedPropertyMap = headers = properties != null ? properties.getTransportHeaders() : null;
                if (headers != null && (value = (String)headers.getValue("portlet.http-status-code")) != null) {
                    try {
                        status = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        throw new ServletException("Bad portlet.http-status-code=" + value + " resource value", (Throwable)e);
                    }
                }
                resp.setStatus(status);
                if (contentResponse.getContentType() != null) {
                    resp.setContentType(contentResponse.getContentType());
                }
                if ((encoding = contentResponse.getEncoding()) != null) {
                    resp.setCharacterEncoding(encoding);
                }
                EmbedPhase.sendHttpHeaders(properties, resp);
                EmbedPhase.sendCookies(properties, resp);
                if (contentResponse.getChars() != null) {
                    PrintWriter writer = resp.getWriter();
                    writer.write(contentResponse.getChars());
                } else if (contentResponse.getBytes() != null) {
                    ServletOutputStream out = resp.getOutputStream();
                    out.write(contentResponse.getBytes());
                }
            } else {
                throw new ServletException("Not yet implemented " + response.getClass().getSimpleName());
            }
        }
    };

    private static final URLFormat URL_FORMAT;
    private static final Charset UTF_8;

    abstract void service(Page var1, PortletInvoker var2, HashMap<String, String[]> var3, HttpServletRequest var4, HttpServletResponse var5) throws IOException, ServletException;

    private static ServletException createException(Window window, ErrorResponse response) {
        ErrorResponse error = response;
        return new ServletException("Portlet " + window.name + " threw an error: " + error.getMessage(), error.getCause());
    }

    private static void sendCookies(ResponseProperties properties, HttpServletResponse resp) {
        if (properties != null) {
            EmbedPhase.sendCookies(properties.getCookies(), resp);
        }
    }

    private static void sendCookies(List<Cookie> cookies, HttpServletResponse resp) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                resp.addCookie(cookie);
            }
        }
    }

    private static void sendHttpHeaders(ResponseProperties properties, HttpServletResponse resp) {
        if (properties != null) {
            EmbedPhase.sendHttpHeaders((MultiValuedPropertyMap<String>)properties.getTransportHeaders(), resp);
        }
    }

    private static void sendHttpHeaders(MultiValuedPropertyMap<String> httpHeaders, HttpServletResponse resp) {
        if (httpHeaders != null) {
            for (String headerName : httpHeaders.keySet()) {
                if (headerName.equals("portlet.http-status-code")) continue;
                resp.setHeader(headerName, (String)httpHeaders.getValue(headerName));
            }
        }
    }

    private static void appendAttribute(Element element, String name, StringBuilder to) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getName().toLowerCase().equals(name)) continue;
            String value = attribute.getValue();
            if (value.length() <= 0) break;
            to.append(" ").append(name).append(" =\"").append(value).append("\"");
            break;
        }
    }

    private static void appendText(Node node, StringBuilder to) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                to.append(((Text)node).getData());
                break;
            }
            case 1: {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    EmbedPhase.appendText(child, to);
                }
                break;
            }
        }
    }

    static {
        URL_FORMAT = new URLFormat(null, null, null, Boolean.valueOf(false));
        UTF_8 = Charset.forName("UTF-8");
    }
}

