/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import java.util.Collection;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.gatein.mop.core.api.workspace.SiteImpl;
import org.gatein.mop.core.api.workspace.WorkspaceImpl;

@NamingPrefix(value="mop")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@PrimaryType(name="foo")
public abstract class SiteContainer<T extends SiteImpl> {
    @OneToMany
    public abstract Map<String, T> getSites();

    public abstract WorkspaceImpl getWorkspace();

    public T addSite(String siteName) {
        T site = this.createSite();
        this.getSites().put(siteName, site);
        return site;
    }

    @Create
    public abstract T createSite();

    public T getSite(String name) {
        Map<String, T> sites = this.getSites();
        return (T)((SiteImpl)sites.get(name));
    }

    public Collection<T> getAllSites() {
        Map<String, T> sites = this.getSites();
        return sites.values();
    }
}

