/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.SetTypes;
import org.h2.constant.DbSettings;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DatabaseCloser;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Engine;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DataHandler;
import org.h2.store.FileLock;
import org.h2.store.FileStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.LobStorage;
import org.h2.store.PageStore;
import org.h2.store.WriterThread;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.BitField;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Utils;
import org.h2.value.CaseInsensitiveMap;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class Database
implements DataHandler {
    private static int initialPowerOffCount;
    private static final String SYSTEM_USER_NAME = "DBA";
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final HashMap<String, Role> roles = New.hashMap();
    private final HashMap<String, User> users = New.hashMap();
    private final HashMap<String, Setting> settings = New.hashMap();
    private final HashMap<String, Schema> schemas = New.hashMap();
    private final HashMap<String, Right> rights = New.hashMap();
    private final HashMap<String, UserDataType> userDataTypes = New.hashMap();
    private final HashMap<String, UserAggregate> aggregates = New.hashMap();
    private final HashMap<String, Comment> comments = New.hashMap();
    private final Set<Session> userSessions = Collections.synchronizedSet(new HashSet());
    private Session exclusiveSession;
    private final BitField objectIds = new BitField();
    private final Object lobSyncObject = new Object();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private int nextTempTableId;
    private User systemUser;
    private Session systemSession;
    private Table meta;
    private Index metaIdIndex;
    private FileLock lock;
    private WriterThread writer;
    private boolean starting;
    private TraceSystem traceSystem;
    private Trace trace;
    private int fileLockMethod;
    private Role publicRole;
    private long modificationDataId;
    private long modificationMetaId;
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private boolean noDiskSpace;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = 10000;
    private int maxMemoryUndo = 50000;
    private int lockMode = 3;
    private int maxLengthInplaceLob;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private int closeDelay;
    private DatabaseCloser delayedCloser;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    private boolean optimizeReuseResults = true;
    private String cacheType;
    private String accessModeData;
    private boolean referentialIntegrity = true;
    private boolean multiVersion;
    private DatabaseCloser closeOnExit;
    private Mode mode = Mode.getInstance("REGULAR");
    private boolean multiThreaded;
    private int maxOperationMemory = 100000;
    private SmallLRUCache<String, String[]> lobFileListCache;
    private boolean autoServerMode;
    private int autoServerPort;
    private Server server;
    private HashMap<TableLinkConnection, TableLinkConnection> linkConnections;
    private TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private PageStore pageStore;
    private Properties reconnectLastLock;
    private volatile long reconnectCheckNext;
    private volatile boolean reconnectChangePending;
    private volatile int checkpointAllowed;
    private volatile boolean checkpointRunning;
    private final Object reconnectSync = new Object();
    private int cacheSize;
    private int compactMode;
    private SourceCompiler compiler;
    private volatile boolean metaTablesInitialized;
    private boolean flushOnEachCommit;
    private LobStorage lobStorage;
    private int pageSize = 2048;
    private int defaultTableType = 0;
    private final DbSettings dbSettings;
    private final int reconnectCheckDelay;
    private int logMode;

    public Database(ConnectionInfo connectionInfo, String string) {
        String string2;
        String string3 = connectionInfo.getName();
        this.dbSettings = connectionInfo.getDbSettings();
        this.reconnectCheckDelay = this.dbSettings.reconnectCheckDelay;
        this.compareMode = CompareMode.getInstance(null, 0);
        this.persistent = connectionInfo.isPersistent();
        this.filePasswordHash = connectionInfo.getFilePasswordHash();
        this.databaseName = string3;
        this.databaseShortName = this.parseDatabaseShortName();
        this.maxLengthInplaceLob = SysProperties.LOB_IN_DATABASE ? 128 : 4096;
        this.cipher = string;
        String string4 = connectionInfo.getProperty("FILE_LOCK", null);
        this.accessModeData = StringUtils.toLowerEnglish(connectionInfo.getProperty("ACCESS_MODE_DATA", "rw"));
        this.autoServerMode = connectionInfo.getProperty("AUTO_SERVER", false);
        this.autoServerPort = connectionInfo.getProperty("AUTO_SERVER_PORT", 0);
        this.cacheSize = connectionInfo.getProperty("CACHE_SIZE", 16384);
        this.pageSize = connectionInfo.getProperty("PAGE_SIZE", 2048);
        if ("r".equals(this.accessModeData)) {
            this.readOnly = true;
        }
        this.fileLockMethod = FileLock.getFileLockMethod(string4);
        this.databaseURL = connectionInfo.getURL();
        String string5 = connectionInfo.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (string5 != null) {
            string5 = StringUtils.trim(string5, true, true, "'");
            this.setEventListenerClass(string5);
        }
        if ((string2 = connectionInfo.removeProperty("MODE", null)) != null) {
            this.mode = Mode.getInstance(string2);
        }
        this.multiVersion = connectionInfo.getProperty("MVCC", false);
        this.logMode = connectionInfo.getProperty("LOG", 2);
        boolean bl = this.dbSettings.dbCloseOnExit;
        int n = connectionInfo.getIntProperty(10, 1);
        int n2 = connectionInfo.getIntProperty(9, 0);
        this.cacheType = StringUtils.toUpperEnglish(connectionInfo.removeProperty("CACHE_TYPE", "LRU"));
        this.openDatabase(n, n2, bl);
    }

    private void openDatabase(int n, int n2, boolean bl) {
        try {
            this.open(n, n2);
            if (bl) {
                try {
                    this.closeOnExit = new DatabaseCloser(this, 0, true);
                    Runtime.getRuntime().addShutdownHook(this.closeOnExit);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                throwable.fillInStackTrace();
            }
            if (this.traceSystem != null) {
                SQLException sQLException;
                if (throwable instanceof SQLException && (sQLException = (SQLException)throwable).getErrorCode() != 90020) {
                    this.trace.error(throwable, "opening {0}", this.databaseName);
                }
                this.traceSystem.close();
            }
            this.closeOpenFilesAndUnlock(false);
            throw DbException.convert(throwable);
        }
    }

    public static void setInitialPowerOffCount(int n) {
        initialPowerOffCount = n;
    }

    public void setPowerOffCount(int n) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = n;
    }

    public boolean areEqual(Value value, Value value2) {
        return value.compareTo(value2, this.compareMode) == 0;
    }

    public int compare(Value value, Value value2) {
        return value.compareTo(value2, this.compareMode);
    }

    public int compareTypeSave(Value value, Value value2) {
        return value.compareTypeSave(value2, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId;
    }

    private synchronized boolean reconnectModified(boolean bl) {
        if (this.readOnly || this.lock == null || this.fileLockMethod != 3) {
            return true;
        }
        try {
            Object object;
            if (bl == this.reconnectChangePending) {
                long l = System.currentTimeMillis();
                if (l > this.reconnectCheckNext) {
                    if (bl) {
                        String string = this.pageStore == null ? null : "" + this.pageStore.getWriteCountTotal();
                        this.lock.setProperty("logPos", string);
                        this.lock.save();
                    }
                    this.reconnectCheckNext = l + (long)this.reconnectCheckDelay;
                }
                return true;
            }
            Properties properties = this.lock.load();
            if (bl) {
                if (properties.getProperty("changePending") != null) {
                    return false;
                }
                this.trace.debug("wait before writing");
                Thread.sleep((int)((double)this.reconnectCheckDelay * 1.1));
                object = this.lock.load();
                if (!((Properties)object).equals(properties)) {
                    return false;
                }
            }
            object = this.pageStore == null ? null : "" + this.pageStore.getWriteCountTotal();
            this.lock.setProperty("logPos", (String)object);
            if (bl) {
                this.lock.setProperty("changePending", "true-" + Math.random());
            } else {
                this.lock.setProperty("changePending", null);
            }
            this.reconnectCheckNext = System.currentTimeMillis() + (long)(2 * this.reconnectCheckDelay);
            properties = this.lock.save();
            if (bl) {
                this.trace.debug("wait before writing again");
                Thread.sleep((int)((double)this.reconnectCheckDelay * 1.1));
                Properties properties2 = this.lock.load();
                if (!properties2.equals(properties)) {
                    return false;
                }
            } else {
                Thread.sleep(1L);
            }
            this.reconnectLastLock = properties;
            this.reconnectChangePending = bl;
            this.reconnectCheckNext = System.currentTimeMillis() + (long)this.reconnectCheckDelay;
            return true;
        }
        catch (Exception exception) {
            this.trace.error(exception, "pending {0}", bl);
            return false;
        }
    }

    public long getNextModificationDataId() {
        return ++this.modificationDataId;
    }

    public long getModificationMetaId() {
        return this.modificationMetaId;
    }

    public long getNextModificationMetaId() {
        ++this.modificationDataId;
        return this.modificationMetaId++;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    @Override
    public void checkPowerOff() {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                this.stopWriter();
                if (this.pageStore != null) {
                    try {
                        this.pageStore.close();
                    }
                    catch (DbException dbException) {
                        // empty catch block
                    }
                    this.pageStore = null;
                }
                if (this.lock != null) {
                    this.stopServer();
                    if (this.fileLockMethod != 3) {
                        this.lock.unlock();
                    }
                    this.lock = null;
                }
                if (this.traceSystem != null) {
                    this.traceSystem.close();
                }
            }
            catch (DbException dbException) {
                TraceSystem.traceThrowable(dbException);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw DbException.get(90098);
    }

    static boolean exists(String string) {
        return FileUtils.exists(string + ".h2.db");
    }

    public Trace getTrace(String string) {
        return this.traceSystem.getTrace(string);
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) {
        if (bl && !FileUtils.exists(string)) {
            throw DbException.get(90124, string);
        }
        FileStore fileStore = FileStore.open(this, string, string2, this.cipher, this.filePasswordHash);
        try {
            fileStore.init();
        }
        catch (DbException dbException) {
            fileStore.closeSilently();
            throw dbException;
        }
        return fileStore;
    }

    boolean validateFilePasswordHash(String string, byte[] byArray) {
        if (!StringUtils.equals(string, this.cipher)) {
            return false;
        }
        return Utils.compareSecure(byArray, this.filePasswordHash);
    }

    private String parseDatabaseShortName() {
        String string = this.databaseName;
        if (string.endsWith(":")) {
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\:,;");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        if (string == null || string.length() == 0) {
            string = "unnamed";
        }
        return this.dbSettings.databaseToUpper ? StringUtils.toUpperEnglish(string) : string;
    }

    private synchronized void open(int n, int n2) {
        Object object;
        IndexColumn[] indexColumnArray;
        boolean bl;
        Object object2;
        Object object3;
        if (this.persistent) {
            object3 = this.databaseName + ".data.db";
            boolean bl2 = FileUtils.exists((String)object3);
            object2 = this.databaseName + ".h2.db";
            bl = FileUtils.exists((String)object2);
            if (bl2 && !bl) {
                throw DbException.get(90048, "Old database: " + (String)object3 + " - please convert the database to a SQL script and re-create it.");
            }
            if (bl && !FileUtils.canWrite((String)object2)) {
                this.readOnly = true;
            }
            this.traceSystem = this.readOnly ? new TraceSystem(null) : new TraceSystem(this.databaseName + ".trace.db");
            this.traceSystem.setLevelFile(n);
            this.traceSystem.setLevelSystemOut(n2);
            this.trace = this.traceSystem.getTrace("database");
            this.trace.info("opening {0} (build {1})", this.databaseName, 168);
            if (this.autoServerMode && (this.readOnly || this.fileLockMethod == 0 || this.fileLockMethod == 3 || this.fileLockMethod == 4 || !this.persistent)) {
                throw DbException.getUnsupportedException("autoServerMode && (readOnly || fileLockMethod == NO || fileLockMethod == SERIALIZED || inMemory)");
            }
            indexColumnArray = this.databaseName + ".lock.db";
            if (this.readOnly && FileUtils.exists((String)indexColumnArray)) {
                throw DbException.get(90020, "Lock file exists: " + (String)indexColumnArray);
            }
            if (!this.readOnly && this.fileLockMethod != 0 && this.fileLockMethod != 4) {
                this.lock = new FileLock(this.traceSystem, (String)indexColumnArray, 1000);
                this.lock.lock(this.fileLockMethod);
                if (this.autoServerMode) {
                    this.startServer(this.lock.getUniqueId());
                }
            }
            if (SysProperties.MODIFY_ON_WRITE) {
                while (this.isReconnectNeeded()) {
                }
            } else {
                while (this.isReconnectNeeded() && !this.beforeWriting()) {
                }
            }
            this.deleteOldTempFiles();
            this.starting = true;
            if (SysProperties.MODIFY_ON_WRITE) {
                try {
                    this.getPageStore();
                }
                catch (DbException dbException) {
                    if (dbException.getErrorCode() != 90097) {
                        throw dbException;
                    }
                    this.pageStore = null;
                    while (!this.beforeWriting()) {
                    }
                    this.getPageStore();
                }
            } else {
                this.getPageStore();
            }
            this.starting = false;
            this.writer = WriterThread.create(this, this.writeDelay);
        } else {
            if (this.autoServerMode) {
                throw DbException.getUnsupportedException("autoServerMode && inMemory");
            }
            this.traceSystem = new TraceSystem(null);
            this.trace = this.traceSystem.getTrace("database");
        }
        this.systemUser = new User(this, 0, SYSTEM_USER_NAME, true);
        this.mainSchema = new Schema(this, 0, "PUBLIC", this.systemUser, true);
        this.infoSchema = new Schema(this, -1, "INFORMATION_SCHEMA", this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, "PUBLIC", true);
        this.roles.put("PUBLIC", this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, ++this.nextSessionId);
        object3 = new CreateTableData();
        ArrayList<Column> arrayList = ((CreateTableData)object3).columns;
        object2 = new Column("ID", 4);
        ((Column)object2).setNullable(false);
        arrayList.add((Column)object2);
        arrayList.add(new Column("HEAD", 4));
        arrayList.add(new Column("TYPE", 4));
        arrayList.add(new Column("SQL", 13));
        bl = true;
        if (this.pageStore != null) {
            bl = this.pageStore.isNew();
        }
        ((CreateTableData)object3).tableName = "SYS";
        ((CreateTableData)object3).id = 0;
        ((CreateTableData)object3).temporary = false;
        ((CreateTableData)object3).persistData = this.persistent;
        ((CreateTableData)object3).persistIndexes = this.persistent;
        ((CreateTableData)object3).create = bl;
        ((CreateTableData)object3).isHidden = true;
        ((CreateTableData)object3).session = this.systemSession;
        this.meta = this.mainSchema.createTable((CreateTableData)object3);
        indexColumnArray = IndexColumn.wrap(new Column[]{object2});
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, indexColumnArray, IndexType.createPrimaryKey(false, false), true, null);
        this.objectIds.set(0);
        this.starting = true;
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        ArrayList<Object> arrayList2 = New.arrayList();
        while (cursor.next()) {
            object = new MetaRecord(cursor.get());
            this.objectIds.set(((MetaRecord)object).getId());
            arrayList2.add(object);
        }
        Collections.sort(arrayList2);
        for (Object object4 : arrayList2) {
            ((MetaRecord)object4).execute(this, this.systemSession, this.eventListener);
        }
        this.recompileInvalidViews(this.systemSession);
        this.starting = false;
        if (!this.readOnly) {
            Object object4;
            object = SetTypes.getTypeName(34);
            if (this.settings.get(object) == null) {
                object4 = new Setting(this, this.allocateObjectId(), (String)object);
                ((Setting)object4).setIntValue(168);
                this.lockMeta(this.systemSession);
                this.addDatabaseObject(this.systemSession, (DbObject)object4);
            }
            if (this.pageStore != null) {
                object4 = this.pageStore.getObjectIds();
                int n3 = ((BitField)object4).length();
                for (int i = 0; i < n3; ++i) {
                    if (!((BitField)object4).get(i) || this.objectIds.get(i)) continue;
                    this.trace.info("unused object id: " + i);
                    this.objectIds.set(i);
                }
            }
        }
        this.getLobStorage().init();
        this.systemSession.commit(true);
        this.trace.info("opened {0}", this.databaseName);
        if (this.checkpointAllowed > 0) {
            this.afterWriting();
        }
    }

    private void startServer(String string) {
        try {
            this.server = Server.createTcpServer("-tcpPort", Integer.toString(this.autoServerPort), "-tcpAllowOthers", "-tcpDaemon", "-key", string, this.databaseName);
            this.server.start();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        String string2 = NetUtils.getLocalAddress() + ":" + this.server.getPort();
        this.lock.setProperty("server", string2);
        this.lock.save();
    }

    private void stopServer() {
        if (this.server != null) {
            Server server = this.server;
            this.server = null;
            server.stop();
        }
    }

    private void recompileInvalidViews(Session session) {
        TableView tableView;
        boolean bl;
        do {
            bl = false;
            for (Table table : this.getAllTablesAndViews(false)) {
                if (!(table instanceof TableView) || !(tableView = (TableView)table).isInvalid()) continue;
                tableView.recompile(session, true);
                if (tableView.isInvalid()) continue;
                bl = true;
            }
        } while (bl);
        for (Table table : this.getAllTablesAndViews(false)) {
            if (!(table instanceof TableView) || (tableView = (TableView)table).isInvalid()) continue;
            tableView.recompile(this.systemSession, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaTables() {
        if (this.metaTablesInitialized) {
            return;
        }
        Schema schema = this.infoSchema;
        synchronized (schema) {
            if (!this.metaTablesInitialized) {
                int n = MetaTable.getMetaTableTypeCount();
                for (int i = 0; i < n; ++i) {
                    MetaTable metaTable = new MetaTable(this.infoSchema, -1 - i, i);
                    this.infoSchema.add(metaTable);
                }
                this.metaTablesInitialized = true;
            }
        }
    }

    private synchronized void addMeta(Session session, DbObject dbObject) {
        int n = dbObject.getId();
        if (n > 0 && !this.starting && !dbObject.isTemporary()) {
            Row row = this.meta.getTemplateRow();
            MetaRecord metaRecord = new MetaRecord(dbObject);
            metaRecord.setRecord(row);
            this.objectIds.set(n);
            if (SysProperties.CHECK) {
                this.verifyMetaLocked(session);
            }
            this.meta.addRow(session, row);
            if (this.isMultiVersion()) {
                session.log(this.meta, (short)0, row);
            }
        }
    }

    public void verifyMetaLocked(Session session) {
        if (!this.lockMeta(session) && this.lockMode != 0) {
            throw DbException.throwInternalError();
        }
    }

    public synchronized boolean lockMeta(Session session) {
        if (this.meta == null) {
            return true;
        }
        boolean bl = this.meta.isLockedExclusivelyBy(session);
        this.meta.lock(session, true, true);
        return bl;
    }

    public synchronized void removeMeta(Session session, int n) {
        if (n > 0 && !this.starting) {
            SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
            searchRow.setValue(0, ValueInt.get(n));
            boolean bl = this.lockMeta(session);
            Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
            if (cursor.next()) {
                if (SysProperties.CHECK && this.lockMode != 0 && !bl) {
                    throw DbException.throwInternalError();
                }
                Row row = cursor.get();
                this.meta.removeRow(session, row);
                if (this.isMultiVersion()) {
                    session.log(this.meta, (short)1, row);
                }
                this.objectIds.clear(n);
                if (SysProperties.CHECK) {
                    this.checkMetaFree(session, n);
                }
            } else if (!bl) {
                this.meta.unlock(session);
                session.unlock(this.meta);
            }
        }
    }

    private HashMap<String, DbObject> getMap(int n) {
        HashMap<String, DbObject> hashMap;
        switch (n) {
            case 2: {
                hashMap = this.users;
                break;
            }
            case 6: {
                hashMap = this.settings;
                break;
            }
            case 7: {
                hashMap = this.roles;
                break;
            }
            case 8: {
                hashMap = this.rights;
                break;
            }
            case 10: {
                hashMap = this.schemas;
                break;
            }
            case 12: {
                hashMap = this.userDataTypes;
                break;
            }
            case 13: {
                hashMap = this.comments;
                break;
            }
            case 14: {
                hashMap = this.aggregates;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return hashMap;
    }

    public synchronized void addSchemaObject(Session session, SchemaObject schemaObject) {
        int n = schemaObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        this.lockMeta(session);
        schemaObject.getSchema().add(schemaObject);
        this.addMeta(session, schemaObject);
    }

    public synchronized void addDatabaseObject(Session session, DbObject dbObject) {
        Object object;
        int n = dbObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        HashMap<String, DbObject> hashMap = this.getMap(dbObject.getType());
        if (dbObject.getType() == 2 && ((User)(object = (User)dbObject)).isAdmin() && this.systemUser.getName().equals(SYSTEM_USER_NAME)) {
            this.systemUser.rename(((DbObjectBase)object).getName());
        }
        object = dbObject.getName();
        if (SysProperties.CHECK && hashMap.get(object) != null) {
            DbException.throwInternalError("object already exists");
        }
        this.lockMeta(session);
        this.addMeta(session, dbObject);
        hashMap.put((String)object, dbObject);
    }

    public UserAggregate findAggregate(String string) {
        return this.aggregates.get(string);
    }

    public Comment findComment(DbObject dbObject) {
        if (dbObject.getType() == 13) {
            return null;
        }
        String string = Comment.getKey(dbObject);
        return this.comments.get(string);
    }

    public Role findRole(String string) {
        return this.roles.get(string);
    }

    public Schema findSchema(String string) {
        Schema schema = this.schemas.get(string);
        if (schema == this.infoSchema) {
            this.initMetaTables();
        }
        return schema;
    }

    public Setting findSetting(String string) {
        return this.settings.get(string);
    }

    public User findUser(String string) {
        return this.users.get(string);
    }

    public UserDataType findUserDataType(String string) {
        return this.userDataTypes.get(string);
    }

    public User getUser(String string) {
        User user = this.findUser(string);
        if (user == null) {
            throw DbException.get(90032, string);
        }
        return user;
    }

    synchronized Session createSession(User user) {
        if (this.exclusiveSession != null) {
            throw DbException.get(90135);
        }
        Session session = new Session(this, user, ++this.nextSessionId);
        this.userSessions.add(session);
        this.trace.info("connecting session #{0} to {1}", session.getId(), this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            if (this.exclusiveSession == session) {
                this.exclusiveSession = null;
            }
            this.userSessions.remove(session);
            if (session != this.systemSession) {
                this.trace.info("disconnecting session #{0}", session.getId());
            }
        }
        if (this.userSessions.size() == 0 && session != this.systemSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DatabaseCloser(this, this.closeDelay * 1000, false);
                this.delayedCloser.setName("H2 Close Delay " + this.getShortName());
                this.delayedCloser.setDaemon(true);
                this.delayedCloser.start();
            }
        }
        if (session != this.systemSession && session != null) {
            this.trace.info("disconnected session #{0}", session.getId());
        }
    }

    private synchronized void closeAllSessionsException(Session session) {
        Session[] sessionArray = new Session[this.userSessions.size()];
        this.userSessions.toArray(sessionArray);
        for (Session session2 : sessionArray) {
            if (session2 == session) continue;
            try {
                session2.rollback();
                session2.close();
            }
            catch (DbException dbException) {
                this.trace.error(dbException, "disconnecting session #{0}", session2.getId());
            }
        }
    }

    synchronized void close(boolean bl) {
        if (this.closing) {
            return;
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            try {
                this.closeOpenFilesAndUnlock(false);
            }
            catch (DbException dbException) {
                // empty catch block
            }
            this.traceSystem.close();
            Engine.getInstance().close(this.databaseName);
            return;
        }
        this.closing = true;
        this.stopServer();
        if (this.userSessions.size() > 0) {
            if (!bl) {
                return;
            }
            this.trace.info("closing {0} from shutdown hook", this.databaseName);
            this.closeAllSessionsException(null);
        }
        this.trace.info("closing {0}", this.databaseName);
        if (this.eventListener != null) {
            this.closing = false;
            DatabaseEventListener databaseEventListener = this.eventListener;
            this.eventListener = null;
            databaseEventListener.closingDatabase();
            if (this.userSessions.size() > 0) {
                return;
            }
            this.closing = true;
        }
        if (this.persistent) {
            boolean bl2;
            boolean bl3 = bl2 = this.infoSchema.findTableOrView(this.systemSession, "LOB_DATA") != null;
            if (bl2) {
                try {
                    this.getLobStorage();
                    this.lobStorage.removeAllForTable(-1);
                }
                catch (DbException dbException) {
                    this.trace.error(dbException, "close");
                }
            }
        }
        try {
            if (this.systemSession != null) {
                SchemaObjectBase schemaObjectBase;
                if (this.powerOffCount != -1) {
                    for (Table table : this.getAllTablesAndViews(false)) {
                        if (table.isGlobalTemporary()) {
                            table.removeChildrenAndResources(this.systemSession);
                            continue;
                        }
                        table.close(this.systemSession);
                    }
                    for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
                        schemaObjectBase = (Sequence)schemaObject;
                        ((Sequence)schemaObjectBase).close();
                    }
                }
                for (SchemaObject schemaObject : this.getAllSchemaObjects(4)) {
                    schemaObjectBase = (TriggerObject)schemaObject;
                    try {
                        ((TriggerObject)schemaObjectBase).close();
                    }
                    catch (SQLException sQLException) {
                        this.trace.error(sQLException, "close");
                    }
                }
                if (this.powerOffCount != -1) {
                    this.meta.close(this.systemSession);
                    this.systemSession.commit(true);
                }
            }
        }
        catch (DbException dbException) {
            this.trace.error(dbException, "close");
        }
        this.tempFileDeleter.deleteAll();
        try {
            this.closeOpenFilesAndUnlock(true);
        }
        catch (DbException dbException) {
            this.trace.error(dbException, "close");
        }
        this.trace.info("closed");
        this.traceSystem.close();
        if (this.closeOnExit != null) {
            this.closeOnExit.reset();
            try {
                Runtime.getRuntime().removeShutdownHook(this.closeOnExit);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.closeOnExit = null;
        }
        Engine.getInstance().close(this.databaseName);
        if (this.deleteFilesOnDisconnect && this.persistent) {
            this.deleteFilesOnDisconnect = false;
            try {
                String string = FileUtils.getParent(this.databaseName);
                String string2 = FileUtils.getName(this.databaseName);
                DeleteDbFiles.execute(string, string2, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            this.writer.stopThread();
            this.writer = null;
        }
    }

    private synchronized void closeOpenFilesAndUnlock(boolean bl) {
        this.stopWriter();
        if (this.pageStore != null && bl) {
            try {
                this.pageStore.checkpoint();
                if (!this.readOnly) {
                    this.lockMeta(this.pageStore.getSystemSession());
                    this.pageStore.compact(this.compactMode);
                }
            }
            catch (DbException dbException) {
                int n;
                if (SysProperties.CHECK2 && (n = dbException.getErrorCode()) != 90098 && n != 50200 && n != 90031) {
                    dbException.printStackTrace();
                }
                this.trace.error(dbException, "close");
            }
            catch (Throwable throwable) {
                if (SysProperties.CHECK2) {
                    throwable.printStackTrace();
                }
                this.trace.error(throwable, "close");
            }
        }
        this.reconnectModified(false);
        this.closeFiles();
        if (this.persistent && this.lock == null && this.fileLockMethod != 0 && this.fileLockMethod != 4) {
            return;
        }
        if (this.persistent) {
            this.deleteOldTempFiles();
        }
        if (this.systemSession != null) {
            this.systemSession.close();
            this.systemSession = null;
        }
        if (this.lock != null) {
            if (this.fileLockMethod == 3 && this.lock.load().containsKey("changePending")) {
                try {
                    Thread.sleep((int)((double)this.reconnectCheckDelay * 1.1));
                }
                catch (InterruptedException interruptedException) {
                    this.trace.error(interruptedException, "close");
                }
            }
            this.lock.unlock();
            this.lock = null;
        }
    }

    private synchronized void closeFiles() {
        try {
            if (this.pageStore != null) {
                this.pageStore.close();
                this.pageStore = null;
            }
        }
        catch (DbException dbException) {
            this.trace.error(dbException, "close");
        }
    }

    private void checkMetaFree(Session session, int n) {
        SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
        searchRow.setValue(0, ValueInt.get(n));
        Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
        if (cursor.next()) {
            DbException.throwInternalError();
        }
    }

    public synchronized int allocateObjectId() {
        int n = this.objectIds.nextClearBit(0);
        this.objectIds.set(n);
        return n;
    }

    public ArrayList<UserAggregate> getAllAggregates() {
        return New.arrayList(this.aggregates.values());
    }

    public ArrayList<Comment> getAllComments() {
        return New.arrayList(this.comments.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ArrayList<Right> getAllRights() {
        return New.arrayList(this.rights.values());
    }

    public ArrayList<Role> getAllRoles() {
        return New.arrayList(this.roles.values());
    }

    public ArrayList<SchemaObject> getAllSchemaObjects() {
        this.initMetaTables();
        ArrayList<SchemaObject> arrayList = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAll());
        }
        return arrayList;
    }

    public ArrayList<SchemaObject> getAllSchemaObjects(int n) {
        if (n == 0) {
            this.initMetaTables();
        }
        ArrayList<SchemaObject> arrayList = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAll(n));
        }
        return arrayList;
    }

    public ArrayList<Table> getAllTablesAndViews(boolean bl) {
        if (bl) {
            this.initMetaTables();
        }
        ArrayList<Table> arrayList = New.arrayList();
        for (Schema schema : this.schemas.values()) {
            arrayList.addAll(schema.getAllTablesAndViews());
        }
        return arrayList;
    }

    public ArrayList<Schema> getAllSchemas() {
        this.initMetaTables();
        return New.arrayList(this.schemas.values());
    }

    public ArrayList<Setting> getAllSettings() {
        return New.arrayList(this.settings.values());
    }

    public ArrayList<UserDataType> getAllUserDataTypes() {
        return New.arrayList(this.userDataTypes.values());
    }

    public ArrayList<User> getAllUsers() {
        return New.arrayList(this.users.values());
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public String getDatabasePath() {
        if (this.persistent) {
            return FileUtils.toRealPath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(boolean bl) {
        ArrayList<Session> arrayList;
        Object object = this.userSessions;
        synchronized (object) {
            arrayList = New.arrayList(this.userSessions);
        }
        object = this.systemSession;
        if (bl && object != null) {
            arrayList.add((Session)object);
        }
        Session[] sessionArray = new Session[arrayList.size()];
        arrayList.toArray(sessionArray);
        return sessionArray;
    }

    public synchronized void update(Session session, DbObject dbObject) {
        this.lockMeta(session);
        int n = dbObject.getId();
        this.removeMeta(session, n);
        this.addMeta(session, dbObject);
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject schemaObject, String string) {
        this.checkWritingAllowed();
        schemaObject.getSchema().rename(schemaObject, string);
        this.updateWithChildren(session, schemaObject);
    }

    private synchronized void updateWithChildren(Session session, DbObject dbObject) {
        ArrayList<DbObject> arrayList = dbObject.getChildren();
        Comment comment = this.findComment(dbObject);
        if (comment != null) {
            DbException.throwInternalError();
        }
        this.update(session, dbObject);
        if (arrayList != null) {
            for (DbObject dbObject2 : arrayList) {
                if (dbObject2.getCreateSQL() == null) continue;
                this.update(session, dbObject2);
            }
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject dbObject, String string) {
        this.checkWritingAllowed();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(dbObject.getName())) {
                DbException.throwInternalError("not found: " + dbObject.getName());
            }
            if (dbObject.getName().equals(string) || hashMap.containsKey(string)) {
                DbException.throwInternalError("object already exists: " + string);
            }
        }
        dbObject.checkRename();
        int n2 = dbObject.getId();
        this.lockMeta(session);
        this.removeMeta(session, n2);
        hashMap.remove(dbObject.getName());
        dbObject.rename(string);
        hashMap.put(string, dbObject);
        this.updateWithChildren(session, dbObject);
    }

    public String createTempFile() {
        try {
            boolean bl = this.readOnly;
            String string = this.databaseName;
            if (!this.persistent) {
                string = "memFS:" + string;
            }
            return FileUtils.createTempFile(string, ".temp.db", true, bl);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.databaseName);
        }
    }

    private void deleteOldTempFiles() {
        String string = FileUtils.getParent(this.databaseName);
        for (String string2 : FileUtils.newDirectoryStream(string)) {
            if (!string2.endsWith(".temp.db") || !string2.startsWith(this.databaseName)) continue;
            FileUtils.tryDelete(string2);
        }
    }

    public Schema getSchema(String string) {
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw DbException.get(90079, string);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject dbObject) {
        this.checkWritingAllowed();
        String string = dbObject.getName();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            DbException.throwInternalError("not found: " + string);
        }
        Comment comment = this.findComment(dbObject);
        this.lockMeta(session);
        if (comment != null) {
            this.removeDatabaseObject(session, comment);
        }
        int n2 = dbObject.getId();
        dbObject.removeChildrenAndResources(session);
        hashMap.remove(string);
        this.removeMeta(session, n2);
    }

    public Table getDependentTable(SchemaObject schemaObject, Table table) {
        switch (schemaObject.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet<DbObject> hashSet = New.hashSet();
        for (Table table2 : this.getAllTablesAndViews(false)) {
            if (table == table2) continue;
            hashSet.clear();
            table2.addDependencies(hashSet);
            if (!hashSet.contains(schemaObject)) continue;
            return table2;
        }
        return null;
    }

    public synchronized void removeSchemaObject(Session session, SchemaObject schemaObject) {
        Table table;
        DbObject dbObject;
        int n = schemaObject.getType();
        if (n == 0) {
            dbObject = (Table)schemaObject;
            if (dbObject.isTemporary() && !dbObject.isGlobalTemporary()) {
                session.removeLocalTempTable((Table)dbObject);
                return;
            }
        } else if (n == 1) {
            dbObject = (Index)schemaObject;
            table = dbObject.getTable();
            if (table.isTemporary() && !table.isGlobalTemporary()) {
                session.removeLocalTempTableIndex((Index)dbObject);
                return;
            }
        } else if (n == 5 && (table = ((Constraint)(dbObject = (Constraint)schemaObject)).getTable()).isTemporary() && !table.isGlobalTemporary()) {
            session.removeLocalTempTableConstraint((Constraint)dbObject);
            return;
        }
        this.checkWritingAllowed();
        this.lockMeta(session);
        dbObject = this.findComment(schemaObject);
        if (dbObject != null) {
            this.removeDatabaseObject(session, dbObject);
        }
        schemaObject.getSchema().remove(schemaObject);
        int n2 = schemaObject.getId();
        if (!this.starting) {
            Table table2 = this.getDependentTable(schemaObject, null);
            if (table2 != null) {
                schemaObject.getSchema().add(schemaObject);
                throw DbException.get(90107, schemaObject.getSQL(), table2.getSQL());
            }
            schemaObject.removeChildrenAndResources(session);
        }
        this.removeMeta(session, n2);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public synchronized void setCacheSize(int n) {
        if (this.starting) {
            int n2 = MathUtils.convertLongToInt(Utils.getMemoryMax()) / 2;
            n = Math.min(n, n2);
        }
        this.cacheSize = n;
        if (this.pageStore != null) {
            this.pageStore.getCache().setMaxMemory(n);
        }
    }

    public synchronized void setMasterUser(User user) {
        this.lockMeta(this.systemSession);
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public synchronized String getTempTableName(String string, Session session) {
        String string2;
        while (this.mainSchema.findTableOrView(session, string2 = string + "_COPY_" + session.getId() + "_" + this.nextTempTableId++) != null) {
        }
        return string2;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    @Override
    public void checkWritingAllowed() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
        if (this.noDiskSpace) {
            throw DbException.get(90100);
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            throw DbException.get(90097);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.writer != null) {
            this.writer.setWriteDelay(n);
            this.flushOnEachCommit = this.writeDelay < 5;
        }
    }

    public boolean getFlushOnEachCommit() {
        return this.flushOnEachCommit;
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        return this.pageStore == null ? null : this.pageStore.getInDoubtTransactions();
    }

    synchronized void prepareCommit(Session session, String string) {
        if (this.readOnly) {
            return;
        }
        this.pageStore.prepareCommit(session, string);
    }

    synchronized void commit(Session session) {
        if (this.readOnly) {
            return;
        }
        if (this.pageStore != null) {
            this.pageStore.commit(session);
        }
        session.setAllCommitted();
    }

    public synchronized void flush() {
        if (this.readOnly || this.pageStore == null) {
            return;
        }
        this.pageStore.flushLog();
    }

    public void setEventListener(DatabaseEventListener databaseEventListener) {
        this.eventListener = databaseEventListener;
    }

    public void setEventListenerClass(String string) {
        if (string == null || string.length() == 0) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)Utils.loadUserClass(string).newInstance();
                String string2 = this.databaseURL;
                if (this.cipher != null) {
                    string2 = string2 + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init(string2);
            }
            catch (Throwable throwable) {
                throw DbException.get(90099, throwable, string, throwable.toString());
            }
        }
    }

    public void setProgress(int n, String string, int n2, int n3) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(n, string, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(sQLException, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void sync() {
        if (this.readOnly || this.pageStore == null) {
            return;
        }
        this.pageStore.sync();
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int n) {
        this.maxMemoryRows = n;
    }

    public void setMaxMemoryUndo(int n) {
        this.maxMemoryUndo = n;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public void setLockMode(int n) {
        switch (n) {
            case 0: {
                if (!this.multiThreaded) break;
                throw DbException.get(90133, "LOCK_MODE=0 & MULTI_THREADED");
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("lock mode", n);
            }
        }
        this.lockMode = n;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public synchronized void setCloseDelay(int n) {
        this.closeDelay = n;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int n) {
        this.maxLengthInplaceLob = n;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.persistent ? this.maxLengthInplaceLob : Integer.MAX_VALUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean bl) {
        this.deleteFilesOnDisconnect = bl;
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String string) {
        this.lobCompressionAlgorithm = string;
    }

    public synchronized void setMaxLogSize(long l) {
        if (this.pageStore != null) {
            this.pageStore.setMaxLogSize(l);
        }
    }

    public void setAllowLiterals(int n) {
        this.allowLiterals = n;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean bl) {
        this.optimizeReuseResults = bl;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean bl) {
        this.referentialIntegrity = bl;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isMultiVersion() {
        return this.multiVersion;
    }

    void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
        if (this.writer != null) {
            this.writer.startThread();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean bl) {
        if (bl && this.multiThreaded != bl) {
            if (this.multiVersion) {
                throw DbException.get(90133, "MVCC & MULTI_THREADED");
            }
            if (this.lockMode == 0) {
                throw DbException.get(90133, "LOCK_MODE=0 & MULTI_THREADED");
            }
        }
        this.multiThreaded = bl;
    }

    public void setMaxOperationMemory(int n) {
        this.maxOperationMemory = n;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public Session getExclusiveSession() {
        return this.exclusiveSession;
    }

    public void setExclusiveSession(Session session, boolean bl) {
        this.exclusiveSession = session;
        if (bl) {
            this.closeAllSessionsException(session);
        }
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        if (this.lobFileListCache == null) {
            this.lobFileListCache = SmallLRUCache.newInstance(128);
        }
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta == null || this.meta.isLockedExclusively();
    }

    public TableLinkConnection getLinkConnection(String string, String string2, String string3, String string4) {
        if (this.linkConnections == null) {
            this.linkConnections = New.hashMap();
        }
        return TableLinkConnection.open(this.linkConnections, string, string2, string3, string4, this.dbSettings.shareLinkedConnections);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (DbException dbException) {
            // empty catch block
        }
        this.closeFiles();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    public PageStore getPageStore() {
        if (this.pageStore == null) {
            this.pageStore = new PageStore(this, this.databaseName + ".h2.db", this.accessModeData, this.cacheSize);
            if (this.pageSize != 2048) {
                this.pageStore.setPageSize(this.pageSize);
            }
            if (!this.readOnly && this.fileLockMethod == 4) {
                this.pageStore.setLockFile(true);
            }
            this.pageStore.setLogMode(this.logMode);
            this.pageStore.open();
        }
        return this.pageStore;
    }

    public Table getFirstUserTable() {
        for (Table table : this.getAllTablesAndViews(false)) {
            if (table.getCreateSQL() == null || table.isHidden()) continue;
            return table;
        }
        return null;
    }

    public boolean isReconnectNeeded() {
        if (this.fileLockMethod != 3) {
            return false;
        }
        if (this.reconnectChangePending) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (l < this.reconnectCheckNext) {
            return false;
        }
        this.reconnectCheckNext = l + (long)this.reconnectCheckDelay;
        if (this.lock == null) {
            this.lock = new FileLock(this.traceSystem, this.databaseName + ".lock.db", 1000);
        }
        try {
            Properties properties;
            Properties properties2 = properties = this.lock.load();
            while (true) {
                if (properties.equals(this.reconnectLastLock)) {
                    return false;
                }
                if (properties.getProperty("changePending", null) == null) break;
                if (System.currentTimeMillis() > l + (long)(this.reconnectCheckDelay * 10) && properties2.equals(properties)) {
                    this.lock.setProperty("changePending", null);
                    this.lock.save();
                    break;
                }
                this.trace.debug("delay (change pending)");
                Thread.sleep(this.reconnectCheckDelay);
                properties = this.lock.load();
            }
            this.reconnectLastLock = properties;
        }
        catch (Exception exception) {
            this.trace.error(exception, "readOnly {0}", this.readOnly);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfRequired() {
        if (this.fileLockMethod != 3 || this.readOnly || !this.reconnectChangePending || this.closing) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l > this.reconnectCheckNext + (long)this.reconnectCheckDelay) {
            if (SysProperties.CHECK && this.checkpointAllowed < 0) {
                DbException.throwInternalError();
            }
            Object object = this.reconnectSync;
            synchronized (object) {
                if (this.checkpointAllowed > 0) {
                    return;
                }
                this.checkpointRunning = true;
            }
            object = this;
            synchronized (object) {
                this.trace.debug("checkpoint start");
                this.flushSequences();
                this.checkpoint();
                this.reconnectModified(false);
                this.trace.debug("checkpoint end");
            }
            object = this.reconnectSync;
            synchronized (object) {
                this.checkpointRunning = false;
            }
        }
    }

    public boolean isFileLockSerialized() {
        return this.fileLockMethod == 3;
    }

    private void flushSequences() {
        for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
            Sequence sequence = (Sequence)schemaObject;
            sequence.flushWithoutMargin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() {
        if (this.persistent) {
            Database database = this;
            synchronized (database) {
                if (this.pageStore != null) {
                    this.pageStore.checkpoint();
                }
            }
        }
        this.getTempFileDeleter().deleteUnused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeWriting() {
        if (this.fileLockMethod != 3) {
            return true;
        }
        while (this.checkpointRunning) {
            try {
                Thread.sleep(10 + (int)(Math.random() * 10.0));
            }
            catch (Exception exception) {}
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            if (this.reconnectModified(true)) {
                ++this.checkpointAllowed;
                if (SysProperties.CHECK && this.checkpointAllowed > 20) {
                    throw DbException.throwInternalError();
                }
                return true;
            }
        }
        this.reconnectCheckNext = System.currentTimeMillis() - 1L;
        this.reconnectLastLock = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWriting() {
        if (this.fileLockMethod != 3) {
            return;
        }
        Object object = this.reconnectSync;
        synchronized (object) {
            --this.checkpointAllowed;
        }
        if (SysProperties.CHECK && this.checkpointAllowed < 0) {
            throw DbException.throwInternalError();
        }
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setCompactMode(int n) {
        this.compactMode = n;
    }

    public SourceCompiler getCompiler() {
        if (this.compiler == null) {
            this.compiler = new SourceCompiler();
        }
        return this.compiler;
    }

    @Override
    public LobStorage getLobStorage() {
        if (this.lobStorage == null) {
            this.lobStorage = new LobStorage(this);
        }
        return this.lobStorage;
    }

    @Override
    public Connection getLobConnection() {
        String string = "jdbc:default:connection";
        JdbcConnection jdbcConnection = new JdbcConnection(this.systemSession, this.systemUser.getName(), string);
        jdbcConnection.setTraceLevel(0);
        return jdbcConnection;
    }

    public void setLogMode(int n) {
        if (n < 0 || n > 2) {
            throw DbException.getInvalidValueException("LOG", n);
        }
        if (this.pageStore != null) {
            if (n != 2 || this.pageStore.getLogMode() != 2) {
                this.trace.error(null, "log {0}", n);
            }
            this.logMode = n;
            this.pageStore.setLogMode(n);
        }
    }

    public int getLogMode() {
        if (this.pageStore != null) {
            return this.pageStore.getLogMode();
        }
        return 0;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void setDefaultTableType(int n) {
        this.defaultTableType = n;
    }

    public void setMultiVersion(boolean bl) {
        this.multiVersion = bl;
    }

    public DbSettings getSettings() {
        return this.dbSettings;
    }

    public <V> HashMap<String, V> newStringMap() {
        return this.dbSettings.databaseToUpper ? new HashMap() : new CaseInsensitiveMap();
    }

    public boolean equalsIdentifiers(String string, String string2) {
        if (string == string2 || string.equals(string2)) {
            return true;
        }
        return !this.dbSettings.databaseToUpper && string.equalsIgnoreCase(string2);
    }

    @Override
    public int readLob(long l, byte[] byArray, long l2, byte[] byArray2, int n, int n2) {
        throw DbException.throwInternalError();
    }
}

