/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.InitiatorEncryptionToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InitiatorEncryptionTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public InitiatorEncryptionTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.INITIATOR_ENCRYPTION_TOKEN, SP12Constants.INITIATOR_ENCRYPTION_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        InitiatorEncryptionToken initiatorToken = new InitiatorEncryptionToken(consts, this.builder);
        initiatorToken.setOptional(PolicyConstants.isOptional((Element)element));
        initiatorToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        Policy policy = this.builder.getPolicy((Object)DOMUtils.getFirstElement((Node)element));
        policy = policy.normalize(this.builder.getPolicyRegistry(), false);
        Iterator iterator = policy.getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), initiatorToken);
        }
        return initiatorToken;
    }

    private void processAlternative(List assertions, InitiatorEncryptionToken parent) {
        for (Object token : assertions) {
            if (!(token instanceof Token)) continue;
            parent.setInitiatorEncryptionToken((Token)token);
        }
    }
}

