/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.RecipientEncryptionToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RecipientEncryptionTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public RecipientEncryptionTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.RECIPIENT_ENCRYPTION_TOKEN, SP12Constants.RECIPIENT_ENCRYPTION_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        RecipientEncryptionToken recipientEncryptionToken = new RecipientEncryptionToken(consts, this.builder);
        recipientEncryptionToken.setOptional(PolicyConstants.isOptional((Element)element));
        recipientEncryptionToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        Policy policy = this.builder.getPolicy((Object)DOMUtils.getFirstElement((Node)element));
        policy = policy.normalize(this.builder.getPolicyRegistry(), false);
        Iterator iterator = policy.getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), recipientEncryptionToken);
        }
        return recipientEncryptionToken;
    }

    private void processAlternative(List assertions, RecipientEncryptionToken parent) {
        for (Assertion assertion : assertions) {
            if (!(assertion instanceof Token)) continue;
            parent.setRecipientEncryptionToken((Token)assertion);
        }
    }
}

