/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.policy.interceptors.SpnegoTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.spnego.SpnegoClientAction;
import org.apache.ws.security.spnego.SpnegoTokenContext;
import org.apache.ws.security.util.Base64;

class SpnegoContextTokenOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public SpnegoContextTokenOutInterceptor() {
        super("prepare-send");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null) {
            Collection ais = (Collection)aim.get((Object)SP12Constants.SPNEGO_CONTEXT_TOKEN);
            if (ais == null || ais.isEmpty()) {
                return;
            }
            if (this.isRequestor((Message)message)) {
                String tokId;
                SecurityToken tok = (SecurityToken)message.getContextualProperty("ws-security.token");
                if (tok == null && (tokId = (String)message.getContextualProperty("ws-security.token.id")) != null) {
                    tok = NegotiationUtils.getTokenStore((Message)message).getToken(tokId);
                }
                if (tok == null) {
                    tok = this.issueToken(message, aim);
                }
                if (tok != null) {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                    ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token.id", (Object)tok.getId());
                    message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getId());
                    NegotiationUtils.getTokenStore((Message)message).add(tok);
                }
            } else {
                for (AssertionInfo ai : ais) {
                    ai.setAsserted(true);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityToken issueToken(SoapMessage message, AssertionInfoMap aim) {
        String jaasContext = (String)message.getContextualProperty("ws-security.kerberos.jaas.context");
        String kerberosSpn = (String)message.getContextualProperty("ws-security.kerberos.spn");
        CallbackHandler callbackHandler = NegotiationUtils.getCallbackHandler(message.getContextualProperty("ws-security.callback-handler"), ((Object)((Object)this)).getClass());
        SpnegoTokenContext spnegoToken = new SpnegoTokenContext();
        Object spnegoClientAction = message.getContextualProperty("ws-security.spnego.client.action");
        if (spnegoClientAction instanceof SpnegoClientAction) {
            spnegoToken.setSpnegoClientAction((SpnegoClientAction)spnegoClientAction);
        }
        try {
            spnegoToken.retrieveServiceTicket(jaasContext, callbackHandler, kerberosSpn);
        }
        catch (WSSecurityException e) {
            throw new Fault((Throwable)e);
        }
        STSClient client = STSUtils.getClient((Message)message, "spnego");
        AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
        if (maps == null) {
            maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context");
        }
        STSClient sTSClient = client;
        synchronized (sTSClient) {
            try {
                String s = SpnegoTokenInterceptorProvider.setupClient(client, message, aim);
                if (maps != null) {
                    client.setAddressingNamespace(maps.getNamespaceURI());
                }
                SecurityToken tok = client.requestSecurityToken(s, Base64.encode((byte[])spnegoToken.getToken()));
                byte[] wrappedTok = spnegoToken.unwrapKey(tok.getSecret());
                tok.setSecret(wrappedTok);
                spnegoToken.clear();
                SecurityToken securityToken = tok;
                return securityToken;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            finally {
                client.setTrust((Trust10)null);
                client.setTrust((Trust13)null);
                client.setTemplate(null);
                client.setLocation(null);
                client.setAddressingNamespace(null);
            }
        }
    }
}

