/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.test.support.hibernate;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.picketlink.idm.common.io.IOTools;
import org.picketlink.idm.test.support.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSourceConfig {
    private String name;
    private String connectionURL;
    private String driverClass;
    private String userName;
    private String password;

    public DataSourceConfig(String name, String connectionURL, String driverClass, String userName, String password) {
        this.name = name;
        this.connectionURL = connectionURL;
        this.driverClass = driverClass;
        this.userName = userName;
        this.password = password;
    }

    public DataSourceConfig() {
    }

    public String getName() {
        return this.name;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "Datasource[" + this.name + "]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSourceConfig[] fromXML(URL url) throws Exception {
        ArrayList<DataSourceConfig> configs = new ArrayList<DataSourceConfig>();
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
            Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(in);
            Iterator i = XMLTools.getChildrenIterator((Element)doc.getDocumentElement(), (String)"datasource");
            while (i.hasNext()) {
                Element childElt = (Element)i.next();
                Element nameElt = XMLTools.getUniqueChild((Element)childElt, (String)"datasource-name", (boolean)false);
                if (nameElt == null) {
                    System.out.println("XML element datasource-name is not present, trying deprecated display-name element instead, you should fix your datasources.xml");
                    nameElt = XMLTools.getUniqueChild((Element)childElt, (String)"display-name", (boolean)true);
                }
                Element connectionURLElt = XMLTools.getUniqueChild((Element)childElt, (String)"connection-url", (boolean)true);
                Element driverClassElt = XMLTools.getUniqueChild((Element)childElt, (String)"driver-class", (boolean)true);
                Element userNameElt = XMLTools.getUniqueChild((Element)childElt, (String)"user-name", (boolean)true);
                Element passwordElt = XMLTools.getUniqueChild((Element)childElt, (String)"password", (boolean)true);
                String name = XMLTools.asString((Element)nameElt);
                String connectionURL = XMLTools.asString((Element)connectionURLElt);
                String driverClass = XMLTools.asString((Element)driverClassElt);
                String userName = XMLTools.asString((Element)userNameElt);
                String password = XMLTools.asString((Element)passwordElt);
                DataSourceConfig dsCfg = new DataSourceConfig(name, connectionURL, driverClass, userName, password);
                configs.add(dsCfg);
            }
            DataSourceConfig[] dataSourceConfigArray = configs.toArray(new DataSourceConfig[configs.size()]);
            return dataSourceConfigArray;
        }
        finally {
            IOTools.safeClose((InputStream)in);
        }
    }

    public static DataSourceConfig obtainConfig(String datasources, String dataSourceName) throws Exception {
        DataSourceConfig[] configs;
        URL url = Thread.currentThread().getContextClassLoader().getResource(datasources);
        for (DataSourceConfig config : configs = DataSourceConfig.fromXML(url)) {
            if (!config.getName().equals(dataSourceName)) continue;
            return config;
        }
        throw new IllegalStateException("Could not obtain Config for {datasourceName:datasources} - {" + dataSourceName + ":" + datasources + "}");
    }
}

