/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.info;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.portlet.impl.info.ContainerParameterInfo;

public class ContainerNavigationInfo
implements NavigationInfo {
    private final Map<String, ContainerParameterInfo> publicParametersById = new HashMap<String, ContainerParameterInfo>();
    private final Map<QName, ContainerParameterInfo> publicParametersByName = new HashMap<QName, ContainerParameterInfo>();
    private final Collection<ContainerParameterInfo> publicParameters = Collections.unmodifiableCollection(this.publicParametersById.values());

    public void addPublicParameter(ContainerParameterInfo publicParameter) {
        if (publicParameter == null) {
            throw new IllegalArgumentException("no null public parameter accepted");
        }
        if (this.publicParametersById.containsKey(publicParameter.getId())) {
            throw new IllegalArgumentException("duplicate public parameter id " + publicParameter.getId());
        }
        if (this.publicParametersByName.containsKey(publicParameter.getName())) {
            throw new IllegalArgumentException("duplicate public parameter name " + publicParameter.getName());
        }
        this.publicParametersById.put(publicParameter.getId(), publicParameter);
        this.publicParametersByName.put(publicParameter.getName(), publicParameter);
    }

    public ParameterInfo getPublicParameter(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        return this.publicParametersByName.get(name);
    }

    public ContainerParameterInfo getPublicParameter(String id) {
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        return this.publicParametersById.get(id);
    }

    public Collection<ContainerParameterInfo> getPublicParameters() {
        return this.publicParameters;
    }
}

