/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.RuntimeOptionInfo;
import org.gatein.pc.portlet.impl.info.ContainerCacheInfo;
import org.gatein.pc.portlet.impl.info.ContainerCapabilitiesInfo;
import org.gatein.pc.portlet.impl.info.ContainerEventingInfo;
import org.gatein.pc.portlet.impl.info.ContainerMetaInfo;
import org.gatein.pc.portlet.impl.info.ContainerNavigationInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferencesInfo;
import org.gatein.pc.portlet.impl.info.ContainerSecurityInfo;
import org.gatein.pc.portlet.impl.info.ResourceBundleManager;

public class ContainerPortletInfo
implements PortletInfo {
    private final Map<Class, Object> attachments = new HashMap<Class, Object>();
    private final ContainerCapabilitiesInfo capabilities;
    private final ContainerPreferencesInfo preferences;
    private final ContainerMetaInfo meta;
    private final ContainerSecurityInfo security;
    private final ContainerCacheInfo cache;
    private final ContainerEventingInfo events;
    private final String name;
    private final String applicationName;
    private final String className;
    private final Map<String, String> initParameters;
    private final ResourceBundleManager bundleManager;
    private final ContainerNavigationInfo navigation;
    private final List<String> filterRefs;
    private final Map<String, RuntimeOptionInfo> options;

    public ContainerPortletInfo(ContainerCapabilitiesInfo capabilities, ContainerPreferencesInfo preferences, ContainerMetaInfo meta, ContainerSecurityInfo security, ContainerCacheInfo cache, String name, String className, String applicationName, Map<String, String> initParameters, ResourceBundleManager bundleManager) {
        this.capabilities = capabilities;
        this.preferences = preferences;
        this.meta = meta;
        this.security = security;
        this.cache = cache;
        this.events = new ContainerEventingInfo();
        this.navigation = new ContainerNavigationInfo();
        this.filterRefs = Collections.emptyList();
        this.name = name;
        this.applicationName = applicationName;
        this.className = className;
        this.initParameters = initParameters;
        this.bundleManager = bundleManager;
        this.options = Collections.emptyMap();
    }

    protected ContainerPortletInfo(ContainerCapabilitiesInfo capabilities, ContainerPreferencesInfo preferences, ContainerMetaInfo meta, ContainerSecurityInfo security, ContainerCacheInfo cache, ContainerEventingInfo events, ContainerNavigationInfo navigation, List<String> filterRefs, String name, String applicationName, String className, Map<String, String> initParameters, Boolean remotable, ResourceBundleManager bundleManager, Map<String, RuntimeOptionInfo> options) {
        this.capabilities = capabilities;
        this.preferences = preferences;
        this.meta = meta;
        this.security = security;
        this.cache = cache;
        this.events = events;
        this.navigation = navigation;
        this.filterRefs = filterRefs;
        this.name = name;
        this.applicationName = applicationName;
        this.className = className;
        this.initParameters = initParameters;
        this.bundleManager = bundleManager;
        this.options = options;
    }

    public <T> T getAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        return type.cast(this.attachments.get(type));
    }

    public <T> void setAttachment(Class<T> type, T object) {
        if (type == null) {
            throw new IllegalArgumentException("No null type accepted");
        }
        if (object == null) {
            this.attachments.remove(type);
        } else {
            this.attachments.put(type, object);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Map<String, RuntimeOptionInfo> getRuntimeOptionsInfo() {
        return Collections.unmodifiableMap(this.options);
    }

    public ResourceBundleManager getBundleManager() {
        return this.bundleManager;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getInitParameterNames() {
        return this.initParameters.keySet();
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Map<String, String> getInitParameters() {
        return Collections.unmodifiableMap(this.initParameters);
    }

    public List<String> getFilterRefs() {
        return this.filterRefs;
    }

    public ContainerCapabilitiesInfo getCapabilities() {
        return this.capabilities;
    }

    public ContainerPreferencesInfo getPreferences() {
        return this.preferences;
    }

    public ContainerMetaInfo getMeta() {
        return this.meta;
    }

    public ContainerSecurityInfo getSecurity() {
        return this.security;
    }

    public ContainerCacheInfo getCache() {
        return this.cache;
    }

    public ContainerEventingInfo getEventing() {
        return this.events;
    }

    public ContainerNavigationInfo getNavigation() {
        return this.navigation;
    }
}

