/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gatein.pc.portlet.impl.jsr168.Buffer;

public class ByteBuffer
extends Buffer {
    private ClosableOutputStream bytes;

    public byte[] getBytes() {
        if (this.bytes == null) {
            return null;
        }
        return ((ByteArrayOutputStream)this.bytes.out).toByteArray();
    }

    public OutputStream getOutputStream() throws IllegalStateException {
        if (this.bytes == null) {
            this.bytes = new ClosableOutputStream(new ByteArrayOutputStream());
        }
        return this.bytes;
    }

    @Override
    protected void doReset() {
        ((ByteArrayOutputStream)this.bytes.out).reset();
    }

    private class ClosableOutputStream
    extends OutputStream {
        boolean closed = false;
        final OutputStream out;

        public ClosableOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed stream");
            }
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed stream");
            }
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed stream");
            }
            this.out.write(b);
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush a closed stream");
            }
            ByteBuffer.this.commited = true;
        }

        @Override
        public void close() throws IOException {
            super.close();
            ByteBuffer.this.commited = true;
            this.closed = true;
        }
    }
}

