/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.struct;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.struct.Struct;
import java.lang.reflect.Array;

public final class StructUtil {
    private StructUtil() {
    }

    public static final MemoryIO getMemoryIO(Struct struct2) {
        return struct2.__info.getMemoryIO(0);
    }

    public static final MemoryIO getMemoryIO(Struct struct2, int flags) {
        return struct2.__info.getMemoryIO(flags);
    }

    public static final int getSize(Struct struct2) {
        return struct2.__info.size();
    }

    public static final int getMinimumAlignment(Struct struct2) {
        return struct2.__info.getMinimumAlignment();
    }

    public static final boolean isDirect(Struct struct2) {
        return struct2.__info.isDirect();
    }

    public static final <T extends Struct> T[] newArray(Class<T> type, int length) {
        try {
            Struct[] array = (Struct[])Array.newInstance(type, length);
            for (int i = 0; i < length; ++i) {
                array[i] = (Struct)type.newInstance();
            }
            if (array.length > 0) {
                int align = StructUtil.getMinimumAlignment(array[0]);
                int mask = align - 1;
                int structSize = StructUtil.getSize(array[0]);
                if ((structSize & mask) != 0) {
                    structSize = (structSize & ~mask) + align;
                }
                MemoryIO memory = MemoryIO.allocateDirect(structSize * length);
                for (int i = 0; i < array.length; ++i) {
                    array[i].useMemory(memory.slice(structSize * i, structSize));
                }
            }
            return array;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

