/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.Platform;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static final void putString(ByteBuffer buf, Charset charset, String value) {
        BufferUtil.putCharSequence(buf, charset, (CharSequence)value);
    }

    public static final String getString(ByteBuffer buf, Charset charset) {
        return ((Object)BufferUtil.getCharSequence(buf, charset)).toString();
    }

    public static final void putCharSequence(ByteBuffer buf, Charset charset, CharSequence value) {
        BufferUtil.putCharSequence(buf, charset.newEncoder(), value);
    }

    public static final void putCharSequence(ByteBuffer buf, CharsetEncoder encoder, CharSequence value) {
        encoder.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(CharBuffer.wrap(value), buf, true);
        encoder.flush(buf);
        int nulSize = Math.round(encoder.maxBytesPerChar());
        if (nulSize == 4) {
            buf.putInt(0);
        } else if (nulSize == 2) {
            buf.putShort((short)0);
        } else if (nulSize == 1) {
            buf.put((byte)0);
        }
    }

    public static final CharSequence getCharSequence(ByteBuffer buf, Charset charset) {
        return BufferUtil.getCharSequence(buf, charset.newDecoder());
    }

    public static final CharSequence getCharSequence(ByteBuffer buf, CharsetDecoder decoder) {
        ByteBuffer buffer = buf.slice();
        int end = BufferUtil.indexOf(buffer, (byte)0);
        if (end < 0) {
            end = buffer.limit();
        }
        buffer.position(0).limit(end);
        try {
            return decoder.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(buffer);
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
    }

    public static final int positionOf(ByteBuffer buf, byte value) {
        if (buf.hasArray()) {
            byte[] array = buf.array();
            int offset = buf.arrayOffset();
            int limit = buf.limit();
            for (int pos = buf.position(); pos < limit; ++pos) {
                if (array[offset + pos] != value) continue;
                return pos;
            }
        } else {
            int limit = buf.limit();
            for (int pos = buf.position(); pos < limit; ++pos) {
                if (buf.get(pos) != value) continue;
                return pos;
            }
        }
        return -1;
    }

    public static final int indexOf(ByteBuffer buf, byte value) {
        if (buf.hasArray()) {
            byte[] array = buf.array();
            int begin = buf.arrayOffset() + buf.position();
            int end = begin + buf.limit();
            for (int offset = 0; offset < end && offset > -1; ++offset) {
                if (array[begin + offset] != value) continue;
                return offset;
            }
        } else {
            int begin = buf.position();
            for (int offset = 0; offset < buf.limit(); ++offset) {
                if (buf.get(begin + offset) != value) continue;
                return offset;
            }
        }
        return -1;
    }

    public static final long getAddress(ByteBuffer buf, int position) {
        return AddressIO.INSTANCE.getAddress(buf, position);
    }

    public static final void putAddress(ByteBuffer buf, int position, long address) {
        AddressIO.INSTANCE.putAddress(buf, position, address);
    }

    public static ByteBuffer slice(ByteBuffer buffer, int position) {
        ByteBuffer tmp = buffer.duplicate();
        tmp.position(position);
        return tmp.slice();
    }

    public static ByteBuffer slice(ByteBuffer buffer, int position, int size) {
        ByteBuffer tmp = buffer.duplicate();
        tmp.position(position).limit(position + size);
        return tmp.slice();
    }

    private static interface AddressIO {
        public static final AddressIO INSTANCE = Platform.getPlatform().addressSize() == 32 ? AddressIO32.IMPL : AddressIO64.IMPL;

        public long getAddress(ByteBuffer var1, int var2);

        public void putAddress(ByteBuffer var1, int var2, long var3);

        public static class AddressIO64
        implements AddressIO {
            public static final AddressIO IMPL = new AddressIO64();

            @Override
            public long getAddress(ByteBuffer io, int offset) {
                return io.getLong(offset);
            }

            @Override
            public void putAddress(ByteBuffer io, int offset, long address) {
                io.putLong(offset, address);
            }
        }

        public static class AddressIO32
        implements AddressIO {
            public static final AddressIO IMPL = new AddressIO32();

            @Override
            public long getAddress(ByteBuffer io, int offset) {
                return io.getInt(offset);
            }

            @Override
            public void putAddress(ByteBuffer io, int offset, long address) {
                io.putInt(offset, (int)address);
            }
        }
    }
}

