/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.util.BufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class SimpleBufferPool
implements BufferPool {
    private final int bufferSize;
    private final int poolSize;
    private final BufferPool parent;
    private final ArrayList<ByteBuffer> list;

    public SimpleBufferPool(int bufferSize, int poolSize) {
        this(new DefaultPool(), bufferSize, poolSize);
    }

    public SimpleBufferPool(BufferPool parent, int bufferSize, int poolSize) {
        this.parent = parent;
        this.bufferSize = bufferSize;
        this.poolSize = poolSize;
        this.list = new ArrayList(poolSize);
    }

    @Override
    public ByteBuffer get(int size) {
        if (size <= this.bufferSize && !this.list.isEmpty()) {
            ByteBuffer buf = this.list.remove(this.list.size() - 1);
            buf.rewind().limit(size);
            return buf;
        }
        ByteBuffer buf = this.parent.get(Math.max(size, this.bufferSize));
        buf.rewind().limit(size);
        return buf;
    }

    @Override
    public void put(ByteBuffer buf) {
        if (this.list.size() < this.poolSize && buf.capacity() == this.bufferSize) {
            this.list.add(buf);
        } else {
            this.parent.put(buf);
        }
    }

    @Override
    public void putAll(List<ByteBuffer> list) {
        for (ByteBuffer buf : list) {
            this.put(buf);
        }
    }

    static class DefaultPool
    implements BufferPool {
        DefaultPool() {
        }

        @Override
        public ByteBuffer get(int size) {
            return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        }

        @Override
        public void put(ByteBuffer buffer) {
        }

        @Override
        public void putAll(List<ByteBuffer> list) {
        }
    }
}

