/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;

public abstract class Platform {
    private final OS os;
    private final int javaVersionMajor;

    private static final OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0].toLowerCase();
        if (osName.startsWith("mac") || osName.startsWith("darwin")) {
            return OS.DARWIN;
        }
        if (osName.startsWith("linux")) {
            return OS.LINUX;
        }
        if (osName.startsWith("sunos") || osName.startsWith("solaris")) {
            return OS.SOLARIS;
        }
        if (osName.startsWith("aix")) {
            return OS.AIX;
        }
        if (osName.startsWith("openbsd")) {
            return OS.OPENBSD;
        }
        if (osName.startsWith("freebsd")) {
            return OS.FREEBSD;
        }
        if (osName.startsWith("windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    private static final Platform determinePlatform(OS os2) {
        switch (os2) {
            case DARWIN: {
                return Platform.newDarwinPlatform();
            }
            case WINDOWS: {
                return Platform.newWindowsPlatform();
            }
        }
        return Platform.newDefaultPlatform(os2);
    }

    private static Platform newDarwinPlatform() {
        return new Darwin();
    }

    private static Platform newWindowsPlatform() {
        return new Windows();
    }

    private static Platform newDefaultPlatform(OS os2) {
        return new Default(os2);
    }

    private Platform(OS os2) {
        this.os = os2;
        int version = 5;
        try {
            String versionString = System.getProperty("java.version");
            if (versionString != null) {
                String[] v = versionString.split("\\.");
                version = Integer.valueOf(v[1]);
            }
        }
        catch (Exception ex) {
            version = 5;
        }
        this.javaVersionMajor = version;
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public final CPU getCPU() {
        return ArchHolder.CPU;
    }

    public final int getJavaMajorVersion() {
        return this.javaVersionMajor;
    }

    public abstract int longSize();

    public final int addressSize() {
        return this.getCPU().dataModel;
    }

    public final long addressMask() {
        return this.getCPU().addressMask;
    }

    public String getName() {
        String osName = System.getProperty("os.name").split(" ")[0];
        return this.getCPU().name().toLowerCase() + "-" + osName;
    }

    public String mapLibraryName(String libName) {
        if (libName.matches(this.getLibraryNamePattern())) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    public String getLibraryNamePattern() {
        return "lib.*\\.so.*$";
    }

    public boolean isSupported() {
        int version = Foreign.getInstance().getVersion();
        if ((version & 0xFFFF00) == (Foreign.VERSION_MAJOR << 16 | Foreign.VERSION_MINOR << 8)) {
            return true;
        }
        throw new UnsatisfiedLinkError("Incorrect native library version");
    }

    static /* synthetic */ OS access$000() {
        return Platform.determineOS();
    }

    static /* synthetic */ Platform access$100(OS x0) {
        return Platform.determinePlatform(x0);
    }

    private static final class Windows
    extends Platform {
        public Windows() {
            super(OS.WINDOWS);
        }

        @Override
        public String getLibraryNamePattern() {
            return ".*\\.dll$";
        }

        @Override
        public final int longSize() {
            return 32;
        }
    }

    private static final class Darwin
    extends Platform {
        public Darwin() {
            super(OS.DARWIN);
        }

        @Override
        public String mapLibraryName(String libName) {
            if (libName.matches(this.getLibraryNamePattern())) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }

        @Override
        public String getLibraryNamePattern() {
            return "lib.*\\.(dylib|jnilib)$";
        }

        @Override
        public String getName() {
            return "Darwin";
        }

        @Override
        public final int longSize() {
            return this.getCPU().dataModel;
        }
    }

    private static final class Default
    extends Platform {
        public Default(OS os2) {
            super(os2);
        }

        @Override
        public final int longSize() {
            return this.getCPU().dataModel;
        }
    }

    private static final class ArchHolder {
        public static final CPU CPU = ArchHolder.determineCPU();

        private ArchHolder() {
        }

        private static CPU determineCPU() {
            String archString = null;
            try {
                archString = Foreign.getInstance().getArch().toLowerCase();
            }
            catch (UnsatisfiedLinkError ex) {
                // empty catch block
            }
            if (archString == null || "unknown".equals(archString)) {
                archString = System.getProperty("os.arch", "unknown").toLowerCase();
            }
            if ("x86".equals(archString) || "i386".equals(archString) || "i86pc".equals(archString)) {
                return com.kenai.jffi.Platform$CPU.I386;
            }
            if ("x86_64".equals(archString) || "amd64".equals(archString)) {
                return com.kenai.jffi.Platform$CPU.X86_64;
            }
            if ("ppc".equals(archString) || "powerpc".equals(archString)) {
                return com.kenai.jffi.Platform$CPU.PPC;
            }
            if ("ppc64".equals(archString) || "powerpc64".equals(archString)) {
                return com.kenai.jffi.Platform$CPU.PPC64;
            }
            if ("s390".equals(archString) || "s390x".equals(archString)) {
                return com.kenai.jffi.Platform$CPU.S390X;
            }
            try {
                return com.kenai.jffi.Platform$CPU.valueOf(archString.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return com.kenai.jffi.Platform$CPU.UNKNOWN;
            }
        }
    }

    private static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$100(Platform.access$000());

        private SingletonHolder() {
        }
    }

    public static enum CPU {
        I386(32),
        X86_64(64),
        PPC(32),
        PPC64(64),
        SPARC(32),
        SPARCV9(64),
        S390X(64),
        UNKNOWN(64);

        public final int dataModel;
        public final long addressMask;

        private CPU(int dataModel) {
            this.dataModel = dataModel;
            this.addressMask = dataModel == 32 ? 0xFFFFFFFFL : -1L;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

