/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xs;

import java.util.Vector;
import org.python.apache.xerces.impl.xs.SchemaGrammar;
import org.python.apache.xerces.impl.xs.SchemaSymbols;
import org.python.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.python.apache.xerces.impl.xs.XSAnnotationImpl;
import org.python.apache.xerces.impl.xs.XSElementDecl;
import org.python.apache.xerces.impl.xs.util.NSItemListImpl;
import org.python.apache.xerces.impl.xs.util.StringListImpl;
import org.python.apache.xerces.impl.xs.util.XSNamedMap4Types;
import org.python.apache.xerces.impl.xs.util.XSNamedMapImpl;
import org.python.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.python.apache.xerces.util.SymbolHash;
import org.python.apache.xerces.util.XMLSymbols;
import org.python.apache.xerces.xs.StringList;
import org.python.apache.xerces.xs.XSAttributeDeclaration;
import org.python.apache.xerces.xs.XSAttributeGroupDefinition;
import org.python.apache.xerces.xs.XSElementDeclaration;
import org.python.apache.xerces.xs.XSModel;
import org.python.apache.xerces.xs.XSModelGroupDefinition;
import org.python.apache.xerces.xs.XSNamedMap;
import org.python.apache.xerces.xs.XSNamespaceItemList;
import org.python.apache.xerces.xs.XSNotationDeclaration;
import org.python.apache.xerces.xs.XSObject;
import org.python.apache.xerces.xs.XSObjectList;
import org.python.apache.xerces.xs.XSTypeDefinition;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 16;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, false, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private SymbolHash fSubGroupMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private XSObjectListImpl fAnnotations = null;
    private boolean fHasIDC = false;

    public XSModelImpl(SchemaGrammar[] schemaGrammarArray) {
        int n;
        int n2 = schemaGrammarArray.length;
        this.fNamespaces = new String[Math.max(n2 + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(n2 + 1, 5)];
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            this.fNamespaces[i] = schemaGrammarArray[i].getTargetNamespace();
            this.fGrammarList[i] = schemaGrammarArray[i];
            if (this.fNamespaces[i] != SchemaSymbols.URI_SCHEMAFORSCHEMA) continue;
            bl = true;
        }
        if (!bl) {
            this.fNamespaces[n2] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[n2++] = SchemaGrammar.SG_SchemaNS;
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            SchemaGrammar schemaGrammar = this.fGrammarList[n];
            Vector vector = schemaGrammar.getImportedGrammars();
            int n4 = n3 = vector == null ? -1 : vector.size() - 1;
            while (n3 >= 0) {
                int n5;
                SchemaGrammar schemaGrammar2 = (SchemaGrammar)vector.elementAt(n3);
                for (n5 = 0; n5 < n2 && schemaGrammar2 != this.fGrammarList[n5]; ++n5) {
                }
                if (n5 == n2) {
                    if (n2 == this.fGrammarList.length) {
                        String[] stringArray = new String[n2 * 2];
                        System.arraycopy(this.fNamespaces, 0, stringArray, 0, n2);
                        this.fNamespaces = stringArray;
                        SchemaGrammar[] schemaGrammarArray2 = new SchemaGrammar[n2 * 2];
                        System.arraycopy(this.fGrammarList, 0, schemaGrammarArray2, 0, n2);
                        this.fGrammarList = schemaGrammarArray2;
                    }
                    this.fNamespaces[n2] = schemaGrammar2.getTargetNamespace();
                    this.fGrammarList[n2] = schemaGrammar2;
                    ++n2;
                }
                --n3;
            }
        }
        this.fGrammarMap = new SymbolHash(n2 * 2);
        for (n = 0; n < n2; ++n) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[n]), this.fGrammarList[n]);
            if (!this.fGrammarList[n].hasIDConstraints()) continue;
            this.fHasIDC = true;
        }
        this.fGrammarCount = n2;
        this.fGlobalComponents = new XSNamedMap[17];
        this.fNSComponents = new XSNamedMap[n2][17];
        this.buildSubGroups();
    }

    private void buildSubGroups() {
        SubstitutionGroupHandler substitutionGroupHandler = new SubstitutionGroupHandler(null);
        for (int i = 0; i < this.fGrammarCount; ++i) {
            substitutionGroupHandler.addSubstitutionGroup(this.fGrammarList[i].getSubstitutionGroups());
        }
        XSNamedMap xSNamedMap = this.getComponents((short)2);
        int n = xSNamedMap.getLength();
        this.fSubGroupMap = new SymbolHash(n * 2);
        for (int i = 0; i < n; ++i) {
            XSElementDecl xSElementDecl;
            XSObject[] xSObjectArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl = (XSElementDecl)xSNamedMap.item(i));
            this.fSubGroupMap.put(xSElementDecl, xSObjectArray.length > 0 ? new XSObjectListImpl(xSObjectArray, xSObjectArray.length) : XSObjectListImpl.EMPTY_LIST);
        }
    }

    @Override
    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    @Override
    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    @Override
    public synchronized XSNamedMap getComponents(short s) {
        if (s <= 0 || s > 16 || !GLOBAL_COMP[s]) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        SymbolHash[] symbolHashArray = new SymbolHash[this.fGrammarCount];
        if (this.fGlobalComponents[s] == null) {
            block8: for (int i = 0; i < this.fGrammarCount; ++i) {
                switch (s) {
                    case 3: 
                    case 15: 
                    case 16: {
                        symbolHashArray[i] = this.fGrammarList[i].fGlobalTypeDecls;
                        continue block8;
                    }
                    case 1: {
                        symbolHashArray[i] = this.fGrammarList[i].fGlobalAttrDecls;
                        continue block8;
                    }
                    case 2: {
                        symbolHashArray[i] = this.fGrammarList[i].fGlobalElemDecls;
                        continue block8;
                    }
                    case 5: {
                        symbolHashArray[i] = this.fGrammarList[i].fGlobalAttrGrpDecls;
                        continue block8;
                    }
                    case 6: {
                        symbolHashArray[i] = this.fGrammarList[i].fGlobalGroupDecls;
                        continue block8;
                    }
                    case 11: {
                        symbolHashArray[i] = this.fGrammarList[i].fGlobalNotationDecls;
                    }
                }
            }
            this.fGlobalComponents[s] = s == 15 || s == 16 ? new XSNamedMap4Types(this.fNamespaces, symbolHashArray, this.fGrammarCount, s) : new XSNamedMapImpl(this.fNamespaces, symbolHashArray, this.fGrammarCount);
        }
        return this.fGlobalComponents[s];
    }

    @Override
    public synchronized XSNamedMap getComponentsByNamespace(short s, String string) {
        int n;
        if (s <= 0 || s > 16 || !GLOBAL_COMP[s]) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        if (string != null) {
            for (n = 0; n < this.fGrammarCount && !string.equals(this.fNamespaces[n]); ++n) {
            }
        } else {
            while (n < this.fGrammarCount && this.fNamespaces[n] != null) {
                ++n;
            }
        }
        if (n == this.fGrammarCount) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        if (this.fNSComponents[n][s] == null) {
            SymbolHash symbolHash = null;
            switch (s) {
                case 3: 
                case 15: 
                case 16: {
                    symbolHash = this.fGrammarList[n].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    symbolHash = this.fGrammarList[n].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    symbolHash = this.fGrammarList[n].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    symbolHash = this.fGrammarList[n].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[n][s] = s == 15 || s == 16 ? new XSNamedMap4Types(string, symbolHash, s) : new XSNamedMapImpl(string, symbolHash);
        }
        return this.fNSComponents[n][s];
    }

    @Override
    public XSTypeDefinition getTypeDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSTypeDefinition)schemaGrammar.fGlobalTypeDecls.get(string);
    }

    @Override
    public XSAttributeDeclaration getAttributeDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeDeclaration)schemaGrammar.fGlobalAttrDecls.get(string);
    }

    @Override
    public XSElementDeclaration getElementDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSElementDeclaration)schemaGrammar.fGlobalElemDecls.get(string);
    }

    @Override
    public XSAttributeGroupDefinition getAttributeGroup(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)schemaGrammar.fGlobalAttrGrpDecls.get(string);
    }

    @Override
    public XSModelGroupDefinition getModelGroupDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSModelGroupDefinition)schemaGrammar.fGlobalGroupDecls.get(string);
    }

    @Override
    public XSNotationDeclaration getNotationDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSNotationDeclaration)schemaGrammar.fGlobalNotationDecls.get(string);
    }

    @Override
    public synchronized XSObjectList getAnnotations() {
        if (this.fAnnotations != null) {
            return this.fAnnotations;
        }
        int n = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            n += this.fGrammarList[i].fNumAnnotations;
        }
        XSObject[] xSObjectArray = new XSAnnotationImpl[n];
        int n2 = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            SchemaGrammar schemaGrammar = this.fGrammarList[i];
            if (schemaGrammar.fNumAnnotations <= 0) continue;
            System.arraycopy(schemaGrammar.fAnnotations, 0, xSObjectArray, n2, schemaGrammar.fNumAnnotations);
            n2 += schemaGrammar.fNumAnnotations;
        }
        this.fAnnotations = new XSObjectListImpl(xSObjectArray, xSObjectArray.length);
        return this.fAnnotations;
    }

    private static final String null2EmptyString(String string) {
        return string == null ? XMLSymbols.EMPTY_STRING : string;
    }

    public boolean hasIDConstraints() {
        return this.fHasIDC;
    }

    @Override
    public XSObjectList getSubstitutionGroup(XSElementDeclaration xSElementDeclaration) {
        return (XSObjectList)this.fSubGroupMap.get(xSElementDeclaration);
    }
}

