/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString$PyExposer;
import org.python.core.PyStringDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StringFormatter;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.ucnhashAPI;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="str", doc="str(object) -> string\n\nReturn a nice string representation of the object.\nIf the argument is a string, the return value is the same object.")
public class PyString
extends PyBaseString {
    public static final PyType TYPE;
    protected String string;
    protected transient boolean interned = false;
    private static char[] hexdigit;
    private static ucnhashAPI pucnHash;

    public String getString() {
        return this.string;
    }

    public PyString() {
        this(TYPE, "");
    }

    public PyString(PyType subType, String string) {
        super(subType);
        if (string == null) {
            throw new IllegalArgumentException("Cannot create PyString from null!");
        }
        this.string = string;
    }

    public PyString(String string) {
        this(TYPE, string);
    }

    public PyString(char c) {
        this(TYPE, String.valueOf(c));
    }

    PyString(StringBuilder buffer) {
        this(TYPE, new String(buffer));
    }

    public static PyString fromInterned(String interned) {
        PyString str = new PyString(TYPE, interned);
        str.interned = true;
        return str;
    }

    @ExposedNew
    static PyObject str_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("str", args, keywords, new String[]{"object"}, 0);
        PyObject S = ap.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyString("");
            }
            return new PyString(S.__str__().toString());
        }
        if (S == null) {
            return new PyStringDerived(subtype, "");
        }
        return new PyStringDerived(subtype, S.__str__().toString());
    }

    public int[] toCodePoints() {
        int n = this.getString().length();
        int[] codePoints = new int[n];
        for (int i = 0; i < n; ++i) {
            codePoints[i] = this.getString().charAt(i);
        }
        return codePoints;
    }

    public String substring(int start, int end) {
        return this.getString().substring(start, end);
    }

    @Override
    public PyString __str__() {
        return this.str___str__();
    }

    final PyString str___str__() {
        if (this.getClass() == PyString.class) {
            return this;
        }
        return new PyString(this.getString());
    }

    @Override
    public PyUnicode __unicode__() {
        return new PyUnicode(this);
    }

    @Override
    public int __len__() {
        return this.str___len__();
    }

    final int str___len__() {
        return this.getString().length();
    }

    @Override
    public String toString() {
        return this.getString();
    }

    public String internedString() {
        if (this.interned) {
            return this.getString();
        }
        this.string = this.getString().intern();
        this.interned = true;
        return this.getString();
    }

    @Override
    public PyString __repr__() {
        return this.str___repr__();
    }

    final PyString str___repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.getString(), true));
    }

    public static String encode_UnicodeEscape(String str, boolean use_quotes) {
        int size = str.length();
        StringBuilder v = new StringBuilder(str.length());
        char quote = '\u0000';
        if (use_quotes) {
            quote = str.indexOf(39) >= 0 && str.indexOf(34) == -1 ? (char)'\"' : '\'';
            v.append(quote);
        }
        int i = 0;
        while (size-- > 0) {
            char ch = str.charAt(i++);
            if (use_quotes && ch == quote || ch == '\\') {
                v.append('\\');
                v.append(ch);
                continue;
            }
            if (ch >= '\ud800' && ch < '\udc00') {
                char ch2 = str.charAt(i++);
                --size;
                if (ch2 >= '\udc00' && ch2 <= '\udfff') {
                    int ucs = ((ch & 0x3FF) << 10 | ch2 & 0x3FF) + 65536;
                    v.append('\\');
                    v.append('U');
                    v.append(hexdigit[ucs >> 28 & 0xF]);
                    v.append(hexdigit[ucs >> 24 & 0xF]);
                    v.append(hexdigit[ucs >> 20 & 0xF]);
                    v.append(hexdigit[ucs >> 16 & 0xF]);
                    v.append(hexdigit[ucs >> 12 & 0xF]);
                    v.append(hexdigit[ucs >> 8 & 0xF]);
                    v.append(hexdigit[ucs >> 4 & 0xF]);
                    v.append(hexdigit[ucs & 0xF]);
                    continue;
                }
                --i;
                ++size;
            }
            if (ch >= '\u0100') {
                v.append('\\');
                v.append('u');
                v.append(hexdigit[ch >> 12 & 0xF]);
                v.append(hexdigit[ch >> 8 & 0xF]);
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            if (ch == '\t') {
                v.append("\\t");
                continue;
            }
            if (ch == '\n') {
                v.append("\\n");
                continue;
            }
            if (ch == '\r') {
                v.append("\\r");
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                v.append('\\');
                v.append('x');
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            v.append(ch);
        }
        if (use_quotes) {
            v.append(quote);
        }
        return v.toString();
    }

    public static String decode_UnicodeEscape(String str, int start, int end, String errors, boolean unicode) {
        StringBuilder v = new StringBuilder(end - start);
        int s = start;
        while (s < end) {
            char ch = str.charAt(s);
            if (ch != '\\') {
                v.append(ch);
                ++s;
                continue;
            }
            int loopStart = s++;
            if (s == end) {
                s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, s + 1, "\\ at end of string");
                continue;
            }
            ch = str.charAt(s++);
            switch (ch) {
                case '\n': {
                    break;
                }
                case '\\': {
                    v.append('\\');
                    break;
                }
                case '\'': {
                    v.append('\'');
                    break;
                }
                case '\"': {
                    v.append('\"');
                    break;
                }
                case 'b': {
                    v.append('\b');
                    break;
                }
                case 'f': {
                    v.append('\f');
                    break;
                }
                case 't': {
                    v.append('\t');
                    break;
                }
                case 'n': {
                    v.append('\n');
                    break;
                }
                case 'r': {
                    v.append('\r');
                    break;
                }
                case 'v': {
                    v.append('\u000b');
                    break;
                }
                case 'a': {
                    v.append('\u0007');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int x = Character.digit(ch, 8);
                    for (int j = 0; j < 2 && s < end && (ch = str.charAt(s)) >= '0' && ch <= '7'; ++j, ++s) {
                        x = (x << 3) + Character.digit(ch, 8);
                    }
                    v.append((char)x);
                    break;
                }
                case 'x': {
                    s = PyString.hexescape(v, errors, 2, s, str, end, "truncated \\xXX");
                    break;
                }
                case 'u': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('u');
                        break;
                    }
                    s = PyString.hexescape(v, errors, 4, s, str, end, "truncated \\uXXXX");
                    break;
                }
                case 'U': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('U');
                        break;
                    }
                    s = PyString.hexescape(v, errors, 8, s, str, end, "truncated \\UXXXXXXXX");
                    break;
                }
                case 'N': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('N');
                        break;
                    }
                    if (pucnHash == null) {
                        PyObject mod2 = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(mod2 = mod2.__call__()).__tojava__(Object.class);
                        if (pucnHash.getCchMax() < 0) {
                            throw Py.UnicodeError("Unicode names not loaded");
                        }
                    }
                    if (str.charAt(s) == '{') {
                        int startName;
                        int endBrace;
                        int maxLen = pucnHash.getCchMax();
                        for (endBrace = startName = s + 1; endBrace < end && str.charAt(endBrace) != '}' && endBrace - startName <= maxLen; ++endBrace) {
                        }
                        if (endBrace != end && str.charAt(endBrace) == '}') {
                            int value = pucnHash.getValue(str, startName, endBrace);
                            if (PyString.storeUnicodeCharacter(value, v)) {
                                s = endBrace + 1;
                                break;
                            }
                            s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, endBrace + 1, "illegal Unicode character");
                            break;
                        }
                        s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, endBrace, "malformed \\N character escape");
                        break;
                    }
                    s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, s + 1, "malformed \\N character escape");
                    break;
                }
                default: {
                    v.append('\\');
                    v.append(str.charAt(s - 1));
                }
            }
        }
        return v.toString();
    }

    private static int hexescape(StringBuilder partialDecode, String errors, int digits, int hexDigitStart, String str, int size, String errorMessage) {
        int i;
        if (hexDigitStart + digits > size) {
            return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, size, errorMessage);
        }
        int x = 0;
        for (i = 0; i < digits; ++i) {
            char c = str.charAt(hexDigitStart + i);
            int d = Character.digit(c, 16);
            if (d == -1) {
                return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i + 1, errorMessage);
            }
            x = x << 4 & 0xFFFFFFF0;
            if (c >= '0' && c <= '9') {
                x += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                x += 10 + c - 97;
                continue;
            }
            x += 10 + c - 65;
        }
        if (PyString.storeUnicodeCharacter(x, partialDecode)) {
            return hexDigitStart + i;
        }
        return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i + 1, "illegal Unicode character");
    }

    private static boolean storeUnicodeCharacter(int value, StringBuilder partialDecode) {
        if (value < 0 || value >= 55296 && value <= 57343) {
            return false;
        }
        if (value <= 0x10FFFF) {
            partialDecode.appendCodePoint(value);
            return true;
        }
        return false;
    }

    final PyObject str___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("string index out of range");
        }
        return ret;
    }

    final PyObject str___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final int str___cmp__(PyObject other) {
        if (!(other instanceof PyString)) {
            return -2;
        }
        int c = this.getString().compareTo(((PyString)other).getString());
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject str___eq__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().equals(s) ? Py.True : Py.False;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final PyObject str___ne__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().equals(s) ? Py.False : Py.True;
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.str___lt__(other);
    }

    final PyObject str___lt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.str___le__(other);
    }

    final PyObject str___le__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) <= 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.str___gt__(other);
    }

    final PyObject str___gt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) > 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.str___ge__(other);
    }

    final PyObject str___ge__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.getString().compareTo(s) >= 0 ? Py.True : Py.False;
    }

    private static String coerce(PyObject o) {
        if (o instanceof PyString) {
            return o.toString();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.str___hash__();
    }

    final int str___hash__() {
        return this.getString().hashCode();
    }

    public byte[] toBytes() {
        return StringUtil.toBytes(this.getString());
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (c.isAssignableFrom(String.class)) {
            return this.getString();
        }
        if ((c == Character.TYPE || c == Character.class) && this.getString().length() == 1) {
            return new Character(this.getString().charAt(0));
        }
        if (c.isArray()) {
            if (c.getComponentType() == Byte.TYPE) {
                return this.toBytes();
            }
            if (c.getComponentType() == Character.TYPE) {
                return this.getString().toCharArray();
            }
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    protected PyObject pyget(int i) {
        return Py.newString(this.getString().charAt(i));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            return this.fromSubstring(start, stop);
        }
        int n = PyString.sliceLength(start, stop, step);
        char[] new_chars = new char[n];
        int j = 0;
        int i = start;
        while (j < n) {
            new_chars[j++] = this.getString().charAt(i);
            i += step;
        }
        return this.createInstance(new String(new_chars), true);
    }

    public PyString createInstance(String str) {
        return new PyString(str);
    }

    protected PyString createInstance(String str, boolean isBasic) {
        return new PyString(str);
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.str___contains__(o);
    }

    final boolean str___contains__(PyObject o) {
        if (!(o instanceof PyString)) {
            throw Py.TypeError("'in <string>' requires string as left operand");
        }
        PyString other = (PyString)o;
        return this.getString().indexOf(other.getString()) >= 0;
    }

    @Override
    protected PyObject repeat(int count) {
        int s;
        if (count < 0) {
            count = 0;
        }
        if ((long)(s = this.getString().length()) * (long)count > Integer.MAX_VALUE) {
            throw Py.OverflowError("max str len is 2147483647");
        }
        char[] new_chars = new char[s * count];
        for (int i = 0; i < count; ++i) {
            this.getString().getChars(0, s, new_chars, i * s);
        }
        return this.createInstance(new String(new_chars));
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.str___mul__(o);
    }

    final PyObject str___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.str___rmul__(o);
    }

    final PyObject str___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.str___add__(other);
    }

    final PyObject str___add__(PyObject other) {
        if (other instanceof PyUnicode) {
            return this.decode().__add__(other);
        }
        if (other instanceof PyString) {
            PyString otherStr = (PyString)other;
            return new PyString(this.getString().concat(otherStr.getString()));
        }
        return null;
    }

    final PyTuple str___getnewargs__() {
        return new PyTuple(new PyString(this.getString()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.str___getnewargs__();
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.str___mod__(other);
    }

    public PyObject str___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.getString(), false);
        return fmt.format(other);
    }

    @Override
    public PyObject __int__() {
        try {
            return Py.newInteger(this.atoi(10));
        }
        catch (PyException e) {
            if (e.match(Py.OverflowError)) {
                return this.atol(10);
            }
            throw e;
        }
    }

    @Override
    public PyObject __long__() {
        return this.atol(10);
    }

    @Override
    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    @Override
    public PyObject __pos__() {
        throw Py.TypeError("bad operand type for unary +");
    }

    @Override
    public PyObject __neg__() {
        throw Py.TypeError("bad operand type for unary -");
    }

    @Override
    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    @Override
    public PyComplex __complex__() {
        int s;
        boolean got_re = false;
        boolean got_im = false;
        boolean done = false;
        boolean sw_error = false;
        int n = this.getString().length();
        for (s = 0; s < n && Character.isSpaceChar(this.getString().charAt(s)); ++s) {
        }
        if (s == n) {
            throw Py.ValueError("empty string for complex()");
        }
        double z = -1.0;
        double x = 0.0;
        double y = 0.0;
        int sign = 1;
        block7: do {
            char c = this.getString().charAt(s);
            switch (c) {
                case '-': {
                    sign = -1;
                }
                case '+': {
                    if (done || s + 1 == n) {
                        sw_error = true;
                        break;
                    }
                    c = this.getString().charAt(++s);
                    if (Character.isDigit(c) || c == 'J' || c == 'j') continue block7;
                    sw_error = true;
                    break;
                }
                case 'J': 
                case 'j': {
                    if (got_im || done) {
                        sw_error = true;
                        break;
                    }
                    y = z < 0.0 ? (double)sign : (double)sign * z;
                    got_im = true;
                    done = got_re;
                    sign = 1;
                    ++s;
                    break;
                }
                case ' ': {
                    while (s < n && Character.isSpaceChar(this.getString().charAt(s))) {
                        ++s;
                    }
                    if (s == n) continue block7;
                    sw_error = true;
                    break;
                }
                default: {
                    boolean digit_or_dot;
                    boolean bl = digit_or_dot = c == '.' || Character.isDigit(c);
                    if (!digit_or_dot) {
                        sw_error = true;
                        break;
                    }
                    int end = this.endDouble(this.getString(), s);
                    z = Double.valueOf(this.getString().substring(s, end));
                    if (z == Double.POSITIVE_INFINITY) {
                        throw Py.ValueError(String.format("float() out of range: %.150s", this.getString()));
                    }
                    s = end;
                    if (s < n && ((c = this.getString().charAt(s)) == 'J' || c == 'j')) continue block7;
                    if (got_re) {
                        sw_error = true;
                        break;
                    }
                    x = (double)sign * z;
                    got_re = true;
                    done = got_im;
                    z = -1.0;
                    sign = 1;
                }
            }
        } while (s < n && !sw_error);
        if (sw_error) {
            throw Py.ValueError("malformed string for complex() " + this.getString().substring(s));
        }
        return new PyComplex(x, y);
    }

    private int endDouble(String string, int s) {
        int n = string.length();
        while (s < n) {
            char c;
            if (Character.isDigit(c = string.charAt(s++)) || c == '.') continue;
            if ((c == 'e' || c == 'E') && s < n) {
                c = string.charAt(s);
                if (c != '+' && c != '-') continue;
                ++s;
                continue;
            }
            return s - 1;
        }
        return s;
    }

    public String lower() {
        return this.str_lower();
    }

    final String str_lower() {
        return this.getString().toLowerCase();
    }

    public String upper() {
        return this.str_upper();
    }

    final String str_upper() {
        return this.getString().toUpperCase();
    }

    public String title() {
        return this.str_title();
    }

    final String str_title() {
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        boolean previous_is_cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = chars[i];
            chars[i] = previous_is_cased ? Character.toLowerCase(ch) : Character.toTitleCase(ch);
            previous_is_cased = Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isTitleCase(ch);
        }
        return new String(chars);
    }

    public String swapcase() {
        return this.str_swapcase();
    }

    final String str_swapcase() {
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            char c = chars[i];
            if (Character.isUpperCase(c)) {
                chars[i] = Character.toLowerCase(c);
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            chars[i] = Character.toUpperCase(c);
        }
        return new String(chars);
    }

    public String strip() {
        return this.str_strip(null);
    }

    public String strip(String sep) {
        return this.str_strip(sep);
    }

    final String str_strip(String sep) {
        int end;
        int start;
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        if (sep == null) {
            for (start = 0; start < n && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        if (sep == null) {
            for (end = n - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        if (end >= start) {
            return end < n - 1 || start > 0 ? this.getString().substring(start, end + 1) : this.getString();
        }
        return "";
    }

    public String lstrip() {
        return this.str_lstrip(null);
    }

    public String lstrip(String sep) {
        return this.str_lstrip(sep);
    }

    final String str_lstrip(String sep) {
        int start;
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        if (sep == null) {
            for (start = 0; start < n && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        return start > 0 ? this.getString().substring(start, n) : this.getString();
    }

    public String rstrip(String sep) {
        return this.str_rstrip(sep);
    }

    final String str_rstrip(String sep) {
        int end;
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        if (sep == null) {
            for (end = n - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        return end < n - 1 ? this.getString().substring(0, end + 1) : this.getString();
    }

    public PyList split() {
        return this.str_split(null, -1);
    }

    public PyList split(String sep) {
        return this.str_split(sep, -1);
    }

    public PyList split(String sep, int maxsplit) {
        return this.str_split(sep, maxsplit);
    }

    final PyList str_split(String sep, int maxsplit) {
        if (sep != null) {
            if (sep.length() == 0) {
                throw Py.ValueError("empty separator");
            }
            return this.splitfields(sep, maxsplit);
        }
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        if (maxsplit < 0) {
            maxsplit = n;
        }
        int index = 0;
        for (int splits = 0; index < n && splits < maxsplit; ++splits) {
            while (index < n && Character.isWhitespace(chars[index])) {
                ++index;
            }
            if (index == n) break;
            int start = index;
            while (index < n && !Character.isWhitespace(chars[index])) {
                ++index;
            }
            list.append(this.fromSubstring(start, index));
        }
        while (index < n && Character.isWhitespace(chars[index])) {
            ++index;
        }
        if (index < n) {
            list.append(this.fromSubstring(index, n));
        }
        return list;
    }

    public PyList rsplit() {
        return this.str_rsplit(null, -1);
    }

    public PyList rsplit(String sep) {
        return this.str_rsplit(sep, -1);
    }

    public PyList rsplit(String sep, int maxsplit) {
        return this.str_rsplit(sep, maxsplit);
    }

    final PyList str_rsplit(String sep, int maxsplit) {
        int i;
        if (sep != null) {
            if (sep.length() == 0) {
                throw Py.ValueError("empty separator");
            }
            PyList list = this.rsplitfields(sep, maxsplit);
            list.reverse();
            return list;
        }
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        if (maxsplit < 0) {
            maxsplit = chars.length;
        }
        int splits = 0;
        for (i = chars.length - 1; i > -1 && Character.isWhitespace(chars[i]); --i) {
        }
        if (i == -1) {
            return list;
        }
        while (splits < maxsplit) {
            int nextWsChar;
            while (i > -1 && Character.isWhitespace(chars[i])) {
                --i;
            }
            if (i == -1) break;
            for (nextWsChar = i; nextWsChar > -1 && !Character.isWhitespace(chars[nextWsChar]); --nextWsChar) {
            }
            if (nextWsChar == -1) break;
            ++splits;
            list.add(this.fromSubstring(nextWsChar + 1, i + 1));
            i = nextWsChar;
        }
        while (i > -1 && Character.isWhitespace(chars[i])) {
            --i;
        }
        if (i > -1) {
            list.add(this.fromSubstring(0, i + 1));
        }
        list.reverse();
        return list;
    }

    public PyTuple partition(PyObject sepObj) {
        return this.str_partition(sepObj);
    }

    final PyTuple str_partition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodePartition(sepObj);
        }
        if (!(sepObj instanceof PyString)) {
            throw Py.TypeError("expected a character buffer object");
        }
        String sep = ((PyString)sepObj).getString();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().indexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(this, Py.EmptyString, Py.EmptyString);
    }

    final PyTuple unicodePartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.indexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(this, emptyUnicode, emptyUnicode);
    }

    public PyTuple rpartition(PyObject sepObj) {
        return this.str_rpartition(sepObj);
    }

    final PyTuple str_rpartition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodePartition(sepObj);
        }
        if (!(sepObj instanceof PyString)) {
            throw Py.TypeError("expected a character buffer object");
        }
        String sep = ((PyString)sepObj).getString();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(Py.EmptyString, Py.EmptyString, this);
    }

    final PyTuple unicodeRpartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(emptyUnicode, emptyUnicode, this);
    }

    private PyList splitfields(String sep, int maxsplit) {
        int index;
        PyList list = new PyList();
        int length = this.getString().length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        int lastbreak = 0;
        int splits = 0;
        int sepLength = sep.length();
        if (sep.length() == 0 && maxsplit != 0) {
            index = this.getString().indexOf(sep, lastbreak);
            list.append(this.fromSubstring(lastbreak, index));
            ++splits;
        }
        while (splits < maxsplit && (index = this.getString().indexOf(sep, lastbreak)) != -1) {
            if (sep.length() == 0) {
                ++index;
            }
            ++splits;
            list.append(this.fromSubstring(lastbreak, index));
            lastbreak = index + sepLength;
        }
        if (lastbreak <= length) {
            list.append(this.fromSubstring(lastbreak, length));
        }
        return list;
    }

    private PyList rsplitfields(String sep, int maxsplit) {
        PyList list = new PyList();
        int length = this.getString().length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        int lastbreak = length;
        int index = length;
        int sepLength = sep.length();
        for (int splits = 0; index > 0 && splits < maxsplit; ++splits) {
            int i = this.getString().lastIndexOf(sep, index - sepLength);
            if (i == index) {
                i -= sepLength;
            }
            if (i < 0) break;
            list.append(this.fromSubstring(i + sepLength, lastbreak));
            lastbreak = i;
            index = i;
        }
        list.append(this.fromSubstring(0, lastbreak));
        return list;
    }

    public PyList splitlines() {
        return this.str_splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        return this.str_splitlines(keepends);
    }

    final PyList str_splitlines(boolean keepends) {
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        int n = chars.length;
        int j = 0;
        int i = 0;
        while (i < n) {
            while (i < n && chars[i] != '\n' && chars[i] != '\r' && Character.getType(chars[i]) != 13) {
                ++i;
            }
            int eol = i;
            if (i < n) {
                i = chars[i] == '\r' && i + 1 < n && chars[i + 1] == '\n' ? (i += 2) : ++i;
                if (keepends) {
                    eol = i;
                }
            }
            list.append(this.fromSubstring(j, eol));
            j = i;
        }
        if (j < n) {
            list.append(this.fromSubstring(j, n));
        }
        return list;
    }

    protected PyString fromSubstring(int begin, int end) {
        return this.createInstance(this.getString().substring(begin, end), true);
    }

    public int index(String sub) {
        return this.str_index(sub, 0, null);
    }

    public int index(String sub, int start) {
        return this.str_index(sub, start, null);
    }

    public int index(String sub, int start, int end) {
        return this.str_index(sub, start, Py.newInteger(end));
    }

    final int str_index(String sub, int start, PyObject end) {
        int index = this.str_find(sub, start, end);
        if (index == -1) {
            throw Py.ValueError("substring not found in string.index");
        }
        return index;
    }

    public int rindex(String sub) {
        return this.str_rindex(sub, 0, null);
    }

    public int rindex(String sub, int start) {
        return this.str_rindex(sub, start, null);
    }

    public int rindex(String sub, int start, int end) {
        return this.str_rindex(sub, start, Py.newInteger(end));
    }

    final int str_rindex(String sub, int start, PyObject end) {
        int index = this.str_rfind(sub, start, end);
        if (index == -1) {
            throw Py.ValueError("substring not found in string.rindex");
        }
        return index;
    }

    public int count(String sub) {
        return this.str_count(sub, 0, null);
    }

    public int count(String sub, int start) {
        return this.str_count(sub, start, null);
    }

    public int count(String sub, int start, int end) {
        return this.str_count(sub, start, Py.newInteger(end));
    }

    final int str_count(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int n = sub.length();
        if (n == 0) {
            if (start > this.getString().length()) {
                return 0;
            }
            return indices[1] - indices[0] + 1;
        }
        int count = 0;
        while (true) {
            int index = this.getString().indexOf(sub, indices[0]);
            indices[0] = index + n;
            if (indices[0] > indices[1] || index == -1) break;
            ++count;
        }
        return count;
    }

    public int find(String sub) {
        return this.str_find(sub, 0, null);
    }

    public int find(String sub, int start) {
        return this.str_find(sub, start, null);
    }

    public int find(String sub, int start, int end) {
        return this.str_find(sub, start, Py.newInteger(end));
    }

    final int str_find(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int index = this.getString().indexOf(sub, indices[0]);
        if (index < start || index > indices[1]) {
            return -1;
        }
        return index;
    }

    public int rfind(String sub) {
        return this.str_rfind(sub, 0, null);
    }

    public int rfind(String sub, int start) {
        return this.str_rfind(sub, start, null);
    }

    public int rfind(String sub, int start, int end) {
        return this.str_rfind(sub, start, Py.newInteger(end));
    }

    final int str_rfind(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int index = this.getString().lastIndexOf(sub, indices[1] - sub.length());
        if (index < start) {
            return -1;
        }
        return index;
    }

    public double atof() {
        StringBuilder s = null;
        int n = this.getString().length();
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (ch == '\u0000') {
                throw Py.ValueError("null byte in argument for float()");
            }
            if (!Character.isDigit(ch)) continue;
            if (s == null) {
                s = new StringBuilder(this.getString());
            }
            int val = Character.digit(ch, 10);
            s.setCharAt(i, Character.forDigit(val, 10));
        }
        String sval = this.getString();
        if (s != null) {
            sval = s.toString();
        }
        try {
            String lowSval = sval.toLowerCase();
            if (lowSval.equals("nan")) {
                return Double.NaN;
            }
            if (lowSval.equals("inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (lowSval.equals("-inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (lowSval.endsWith("d") || lowSval.endsWith("f")) {
                throw new NumberFormatException("format specifiers not allowed");
            }
            return Double.valueOf(sval);
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for __float__: " + this.getString());
        }
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int base) {
        int b;
        if (base != 0 && base < 2 || base > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        int e = this.getString().length();
        for (b = 0; b < e && Character.isWhitespace(this.getString().charAt(b)); ++b) {
        }
        while (e > b && Character.isWhitespace(this.getString().charAt(e - 1))) {
            --e;
        }
        char sign = '\u0000';
        if (b < e) {
            sign = this.getString().charAt(b);
            if (sign == '-' || sign == '+') {
                ++b;
                while (b < e && Character.isWhitespace(this.getString().charAt(b))) {
                    ++b;
                }
            }
            if ((base == 0 || base == 16) && this.getString().charAt(b) == '0') {
                if (b < e - 1 && Character.toUpperCase(this.getString().charAt(b + 1)) == 'X') {
                    base = 16;
                    b += 2;
                } else if (base == 0) {
                    base = 8;
                }
            }
        }
        if (base == 0) {
            base = 10;
        }
        String s = this.getString();
        if (b > 0 || e < this.getString().length()) {
            s = this.getString().substring(b, e);
        }
        try {
            BigInteger bi = sign == '-' ? new BigInteger("-" + s, base) : new BigInteger(s, base);
            if (bi.compareTo(PyInteger.MAX_INT) > 0 || bi.compareTo(PyInteger.MIN_INT) < 0) {
                throw Py.OverflowError("long int too large to convert to int");
            }
            return bi.intValue();
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base + ": " + this.getString());
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base + ": " + this.getString());
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int base) {
        int b;
        String str = this.getString();
        int e = str.length();
        for (b = 0; b < e && Character.isWhitespace(str.charAt(b)); ++b) {
        }
        while (e > b && Character.isWhitespace(str.charAt(e - 1))) {
            --e;
        }
        char sign = '\u0000';
        if (b < e) {
            sign = this.getString().charAt(b);
            if (sign == '-' || sign == '+') {
                ++b;
                while (b < e && Character.isWhitespace(str.charAt(b))) {
                    ++b;
                }
            }
            if ((base == 0 || base == 16) && this.getString().charAt(b) == '0') {
                if (b < e - 1 && Character.toUpperCase(this.getString().charAt(b + 1)) == 'X') {
                    base = 16;
                    b += 2;
                } else if (base == 0) {
                    base = 8;
                }
            }
        }
        if (base == 0) {
            base = 10;
        }
        if (base < 2 || base > 36) {
            throw Py.ValueError("invalid base for long literal:" + base);
        }
        if (base < 22 && e > b && (str.charAt(e - 1) == 'L' || str.charAt(e - 1) == 'l')) {
            --e;
        }
        if (b > 0 || e < str.length()) {
            str = str.substring(b, e);
        }
        try {
            BigInteger bi = null;
            bi = sign == '-' ? new BigInteger("-" + str, base) : new BigInteger(str, base);
            return new PyLong(bi);
        }
        catch (NumberFormatException exc) {
            if (this instanceof PyUnicode) {
                throw Py.UnicodeEncodeError("decimal", "codec can't encode character", 0, 0, "invalid decimal Unicode string");
            }
            throw Py.ValueError("invalid literal for long() with base " + base + ": " + this.getString());
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for long() with base " + base + ": " + this.getString());
        }
    }

    private static String padding(int n, char pad) {
        char[] chars = new char[n];
        for (int i = 0; i < n; ++i) {
            chars[i] = pad;
        }
        return new String(chars);
    }

    private static char parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return ' ';
        }
        if (fillchar.length() != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.charAt(0);
    }

    public String ljust(int width) {
        return this.str_ljust(width, null);
    }

    public String ljust(int width, String padding) {
        return this.str_ljust(width, padding);
    }

    final String str_ljust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("ljust", fillchar);
        int n = width - this.getString().length();
        if (n <= 0) {
            return this.getString();
        }
        return this.getString() + PyString.padding(n, pad);
    }

    public String rjust(int width) {
        return this.str_rjust(width, null);
    }

    final String str_rjust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("rjust", fillchar);
        int n = width - this.getString().length();
        if (n <= 0) {
            return this.getString();
        }
        return PyString.padding(n, pad) + this.getString();
    }

    public String center(int width) {
        return this.str_center(width, null);
    }

    final String str_center(int width, String fillchar) {
        char pad = PyString.parse_fillchar("center", fillchar);
        int n = width - this.getString().length();
        if (n <= 0) {
            return this.getString();
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        return PyString.padding(half, pad) + this.getString() + PyString.padding(n - half, pad);
    }

    public String zfill(int width) {
        return this.str_zfill(width);
    }

    final String str_zfill(int width) {
        char start;
        String s = this.getString();
        int n = s.length();
        if (n >= width) {
            return s;
        }
        char[] chars = new char[width];
        int nzeros = width - n;
        int i = 0;
        int sStart = 0;
        if (n > 0 && ((start = s.charAt(0)) == '+' || start == '-')) {
            chars[0] = start;
            ++i;
            ++nzeros;
            sStart = 1;
        }
        while (i < nzeros) {
            chars[i] = 48;
            ++i;
        }
        s.getChars(sStart, s.length(), chars, i);
        return new String(chars);
    }

    public String expandtabs() {
        return this.str_expandtabs(8);
    }

    public String expandtabs(int tabsize) {
        return this.str_expandtabs(tabsize);
    }

    final String str_expandtabs(int tabsize) {
        String s = this.getString();
        StringBuilder buf = new StringBuilder((int)((double)s.length() * 1.5));
        char[] chars = s.toCharArray();
        int n = chars.length;
        int position = 0;
        for (int i = 0; i < n; ++i) {
            char c = chars[i];
            if (c == '\t') {
                int spaces = tabsize - position % tabsize;
                position += spaces;
                while (spaces-- > 0) {
                    buf.append(' ');
                }
                continue;
            }
            if (c == '\n' || c == '\r') {
                position = -1;
            }
            buf.append(c);
            ++position;
        }
        return buf.toString();
    }

    public String capitalize() {
        return this.str_capitalize();
    }

    final String str_capitalize() {
        if (this.getString().length() == 0) {
            return this.getString();
        }
        String first = this.getString().substring(0, 1).toUpperCase();
        return first.concat(this.getString().substring(1).toLowerCase());
    }

    final PyString str_replace(PyObject oldPiece, PyObject newPiece, PyObject maxsplit) {
        if (!(oldPiece instanceof PyString) || !(newPiece instanceof PyString)) {
            throw Py.TypeError("str or unicode required for replace");
        }
        return this.replace((PyString)oldPiece, (PyString)newPiece, maxsplit == null ? -1 : maxsplit.asInt());
    }

    protected PyString replace(PyString oldPiece, PyString newPiece, int maxsplit) {
        int len = this.getString().length();
        int old_len = oldPiece.getString().length();
        if (len == 0) {
            if (maxsplit == -1 && old_len == 0) {
                return this.createInstance(newPiece.getString(), true);
            }
            return this.createInstance(this.getString(), true);
        }
        if (old_len == 0 && newPiece.getString().length() != 0 && maxsplit != 0) {
            int i;
            StringBuilder buffer = new StringBuilder();
            buffer.append(newPiece.getString());
            for (i = 0; i < len && (i < maxsplit - 1 || maxsplit == -1); ++i) {
                buffer.append(this.getString().charAt(i));
                buffer.append(newPiece.getString());
            }
            buffer.append(this.getString().substring(i));
            return this.createInstance(buffer.toString(), true);
        }
        if (maxsplit == -1) {
            maxsplit = old_len == 0 ? len + 1 : len;
        }
        return newPiece.join(this.splitfields(oldPiece.getString(), maxsplit));
    }

    public PyString join(PyObject seq) {
        return this.str_join(seq);
    }

    final PyString str_join(PyObject obj) {
        int i;
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return Py.EmptyString;
        }
        if (seqLen == 1 && ((item = seq.pyget(0)).getType() == TYPE || item.getType() == PyUnicode.TYPE)) {
            return (PyString)item;
        }
        long size = 0L;
        int sepLen = this.getString().length();
        for (i = 0; i < seqLen; ++i) {
            item = seq.pyget(i);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string, %.80s found", i, item.getType().fastGetName()));
            }
            if (item instanceof PyUnicode) {
                return this.unicodeJoin(seq);
            }
            if (i != 0) {
                size += (long)sepLen;
            }
            if ((size += (long)((PyString)item).getString().length()) <= Integer.MAX_VALUE) continue;
            throw Py.OverflowError("join() result is too long for a Python string");
        }
        StringBuilder buf = new StringBuilder((int)size);
        for (i = 0; i < seqLen; ++i) {
            item = seq.pyget(i);
            if (i != 0) {
                buf.append(this.getString());
            }
            buf.append(((PyString)item).getString());
        }
        return new PyString(buf.toString());
    }

    final PyUnicode unicodeJoin(PyObject obj) {
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return new PyUnicode();
        }
        if (seqLen == 1 && (item = seq.pyget(0)).getType() == PyUnicode.TYPE) {
            return (PyUnicode)item;
        }
        String sep = null;
        if (seqLen > 1) {
            if (this instanceof PyUnicode) {
                sep = this.getString();
            } else {
                sep = ((PyUnicode)this.decode()).getString();
                seqLen = seq.__len__();
            }
        }
        long size = 0L;
        int sepLen = this.getString().length();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < seqLen; ++i) {
            item = seq.pyget(i);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string or Unicode, %.80s found", i, item.getType().fastGetName()));
            }
            if (!(item instanceof PyUnicode)) {
                item = ((PyString)item).decode();
                seqLen = seq.__len__();
            }
            String itemString = ((PyUnicode)item).getString();
            if (i != 0) {
                size += (long)sepLen;
                buf.append(sep);
            }
            if ((size += (long)itemString.length()) > Integer.MAX_VALUE) {
                throw Py.OverflowError("join() result is too long for a Python string");
            }
            buf.append(itemString);
        }
        return new PyUnicode(buf.toString());
    }

    public boolean startswith(PyObject prefix) {
        return this.str_startswith(prefix, 0, null);
    }

    public boolean startswith(PyObject prefix, int offset) {
        return this.str_startswith(prefix, offset, null);
    }

    public boolean startswith(PyObject prefix, int start, int end) {
        return this.str_startswith(prefix, start, Py.newInteger(end));
    }

    final boolean str_startswith(PyObject prefix, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        if (prefix instanceof PyString) {
            String strPrefix = ((PyString)prefix).getString();
            if (indices[1] - indices[0] < strPrefix.length()) {
                return false;
            }
            return this.getString().startsWith(strPrefix, indices[0]);
        }
        if (prefix instanceof PyTuple) {
            PyObject[] prefixes = ((PyTuple)prefix).getArray();
            for (int i = 0; i < prefixes.length; ++i) {
                if (!(prefixes[i] instanceof PyString)) {
                    throw Py.TypeError("expected a character buffer object");
                }
                String strPrefix = ((PyString)prefixes[i]).getString();
                if (indices[1] - indices[0] < strPrefix.length() || !this.getString().startsWith(strPrefix, indices[0])) continue;
                return true;
            }
            return false;
        }
        throw Py.TypeError("expected a character buffer object or tuple");
    }

    public boolean endswith(PyObject suffix) {
        return this.str_endswith(suffix, 0, null);
    }

    public boolean endswith(PyObject suffix, int start) {
        return this.str_endswith(suffix, start, null);
    }

    public boolean endswith(PyObject suffix, int start, int end) {
        return this.str_endswith(suffix, start, Py.newInteger(end));
    }

    final boolean str_endswith(PyObject suffix, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        String substr = this.getString().substring(indices[0], indices[1]);
        if (suffix instanceof PyString) {
            return substr.endsWith(((PyString)suffix).getString());
        }
        if (suffix instanceof PyTuple) {
            PyObject[] suffixes = ((PyTuple)suffix).getArray();
            for (int i = 0; i < suffixes.length; ++i) {
                if (!(suffixes[i] instanceof PyString)) {
                    throw Py.TypeError("expected a character buffer object");
                }
                if (!substr.endsWith(((PyString)suffixes[i]).getString())) continue;
                return true;
            }
            return false;
        }
        throw Py.TypeError("expected a character buffer object or tuple");
    }

    protected int[] translateIndices(int start, PyObject end) {
        int iEnd = end == null ? this.getString().length() : end.asInt();
        int n = this.getString().length();
        if (iEnd < 0) {
            if ((iEnd = n + iEnd) < 0) {
                iEnd = 0;
            }
        } else if (iEnd > n) {
            iEnd = n;
        }
        if (start < 0 && (start = n + start) < 0) {
            start = 0;
        }
        if (start > iEnd) {
            start = iEnd;
        }
        return new int[]{start, iEnd};
    }

    public String translate(String table) {
        return this.str_translate(table, null);
    }

    public String translate(String table, String deletechars) {
        return this.str_translate(table, deletechars);
    }

    final String str_translate(String table, String deletechars) {
        if (table.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuilder buf = new StringBuilder(this.getString().length());
        for (int i = 0; i < this.getString().length(); ++i) {
            char c = this.getString().charAt(i);
            if (deletechars != null && deletechars.indexOf(c) >= 0) continue;
            try {
                buf.append(table.charAt(c));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw Py.TypeError("translate() only works for 8-bit character strings");
            }
        }
        return buf.toString();
    }

    public String translate(PyObject table) {
        StringBuilder v = new StringBuilder(this.getString().length());
        for (int i = 0; i < this.getString().length(); ++i) {
            char ch = this.getString().charAt(i);
            PyInteger w = Py.newInteger(ch);
            PyObject x = table.__finditem__(w);
            if (x == null) {
                v.append(ch);
                continue;
            }
            if (x instanceof PyInteger) {
                int value = ((PyInteger)x).getValue();
                v.append((char)value);
                continue;
            }
            if (x == Py.None) continue;
            if (x instanceof PyString) {
                if (x.__len__() != 1) {
                    throw new PyException(Py.NotImplementedError, "1-n mappings are currently not implemented");
                }
                v.append(x.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return v.toString();
    }

    public boolean islower() {
        return this.str_islower();
    }

    final boolean str_islower() {
        int n = this.getString().length();
        if (n == 1) {
            return Character.isLowerCase(this.getString().charAt(0));
        }
        boolean cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                return false;
            }
            if (cased || !Character.isLowerCase(ch)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isupper() {
        return this.str_isupper();
    }

    final boolean str_isupper() {
        int n = this.getString().length();
        if (n == 1) {
            return Character.isUpperCase(this.getString().charAt(0));
        }
        boolean cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isLowerCase(ch) || Character.isTitleCase(ch)) {
                return false;
            }
            if (cased || !Character.isUpperCase(ch)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isalpha() {
        return this.str_isalpha();
    }

    final boolean str_isalpha() {
        int n = this.getString().length();
        if (n == 1) {
            return Character.isLetter(this.getString().charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isLetter(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isalnum() {
        return this.str_isalnum();
    }

    final boolean str_isalnum() {
        int n = this.getString().length();
        if (n == 1) {
            return this._isalnum(this.getString().charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (this._isalnum(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isalnum(char ch) {
        return Character.isLetterOrDigit(ch) || Character.getType(ch) == 10;
    }

    public boolean isdecimal() {
        return this.str_isdecimal();
    }

    final boolean str_isdecimal() {
        int n = this.getString().length();
        if (n == 1) {
            char ch = this.getString().charAt(0);
            return this._isdecimal(ch);
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (this._isdecimal(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isdecimal(char ch) {
        return Character.getType(ch) == 9;
    }

    public boolean isdigit() {
        return this.str_isdigit();
    }

    final boolean str_isdigit() {
        int n = this.getString().length();
        if (n == 1) {
            return Character.isDigit(this.getString().charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isnumeric() {
        return this.str_isnumeric();
    }

    final boolean str_isnumeric() {
        int n = this.getString().length();
        if (n == 1) {
            return this._isnumeric(this.getString().charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (this._isnumeric(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isnumeric(char ch) {
        int type = Character.getType(ch);
        return type == 9 || type == 10 || type == 11;
    }

    public boolean istitle() {
        return this.str_istitle();
    }

    final boolean str_istitle() {
        int n = this.getString().length();
        if (n == 1) {
            return Character.isTitleCase(this.getString().charAt(0)) || Character.isUpperCase(this.getString().charAt(0));
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(ch)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    public boolean isspace() {
        return this.str_isspace();
    }

    final boolean str_isspace() {
        int n = this.getString().length();
        if (n == 1) {
            return Character.isWhitespace(this.getString().charAt(0));
        }
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isunicode() {
        return this.str_isunicode();
    }

    final boolean str_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        int n = this.getString().length();
        for (int i = 0; i < n; ++i) {
            char ch = this.getString().charAt(i);
            if (ch <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public String encode() {
        return this.str_encode(null, null);
    }

    public String encode(String encoding) {
        return this.str_encode(encoding, null);
    }

    public String encode(String encoding, String errors) {
        return this.str_encode(encoding, errors);
    }

    final String str_encode(String encoding, String errors) {
        return codecs.encode(this, encoding, errors);
    }

    public PyObject decode() {
        return this.str_decode(null, null);
    }

    public PyObject decode(String encoding) {
        return this.str_decode(encoding, null);
    }

    public PyObject decode(String encoding, String errors) {
        return this.str_decode(encoding, errors);
    }

    final PyObject str_decode(String encoding, String errors) {
        return codecs.decode(this, encoding, errors);
    }

    @Override
    public String asString(int index) throws PyObject.ConversionException {
        return this.getString();
    }

    @Override
    public String asString() {
        return this.getString();
    }

    @Override
    public int asInt() {
        this.asNumberCheck("__int__", "an integer");
        return super.asInt();
    }

    @Override
    public long asLong() {
        this.asNumberCheck("__long__", "an integer");
        return super.asLong();
    }

    @Override
    public double asDouble() {
        this.asNumberCheck("__float__", "a float");
        return super.asDouble();
    }

    private void asNumberCheck(String methodName, String description) {
        PyType type = this.getType();
        if (type == TYPE || type == PyUnicode.TYPE || type.lookup(methodName) == null) {
            throw Py.TypeError(description + " is required");
        }
    }

    @Override
    public String asName(int index) throws PyObject.ConversionException {
        return this.internedString();
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "cannot concatenate ''{1}'' and ''{2}'' objects";
        }
        return super.unsupportedopMessage(op, o2);
    }

    static {
        PyType.addBuilder(PyString.class, new PyString$PyExposer());
        TYPE = PyType.fromClass(PyString.class);
        hexdigit = "0123456789abcdef".toCharArray();
        pucnHash = null;
    }
}

