/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;

public class JavaSecuredFile
extends File {
    public JavaSecuredFile(File parent, String child) {
        super(parent, child);
    }

    public JavaSecuredFile(String pathname) {
        super(pathname);
    }

    public JavaSecuredFile(String parent, String child) {
        super(parent, child);
    }

    public JavaSecuredFile(URI uri) {
        super(uri);
    }

    @Override
    public File getParentFile() {
        String parent = this.getParent();
        if (parent != null) {
            return new JavaSecuredFile(parent);
        }
        return null;
    }

    @Override
    public File getAbsoluteFile() {
        String absolute = this.getAbsolutePath();
        if (absolute != null) {
            return new JavaSecuredFile(absolute);
        }
        return null;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        try {
            return super.getCanonicalPath();
        }
        catch (SecurityException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public File getCanonicalFile() throws IOException {
        String canonical = this.getCanonicalPath();
        if (canonical != null) {
            return new JavaSecuredFile(canonical);
        }
        return null;
    }

    @Override
    public boolean canRead() {
        try {
            return super.canRead();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return super.canWrite();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean exists() {
        try {
            return super.exists();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return super.isDirectory();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            return super.isFile();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean isHidden() {
        try {
            return super.isHidden();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        try {
            return super.lastModified();
        }
        catch (SecurityException ex) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return super.length();
        }
        catch (SecurityException ex) {
            return 0L;
        }
    }

    @Override
    public boolean createNewFile() throws IOException {
        try {
            return super.createNewFile();
        }
        catch (SecurityException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public boolean delete() {
        try {
            return super.delete();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public String[] list() {
        try {
            return super.list();
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public String[] list(FilenameFilter filter) {
        try {
            return super.list(filter);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public File[] listFiles() {
        try {
            return super.listFiles();
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        try {
            return super.listFiles(filter);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        try {
            return super.listFiles(filter);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    @Override
    public boolean mkdir() {
        try {
            return super.mkdir();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        try {
            return super.mkdirs();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean renameTo(File dest) {
        try {
            return super.renameTo(dest);
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean setLastModified(long time) {
        try {
            return super.setLastModified(time);
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public boolean setReadOnly() {
        try {
            return super.setReadOnly();
        }
        catch (SecurityException ex) {
            return false;
        }
    }
}

