/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import com.kenai.constantine.platform.Errno;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.mapper.FromNativeContext;
import java.io.FileDescriptor;
import org.python.posix.BaseHeapFileStat;
import org.python.posix.BaseNativePOSIX;
import org.python.posix.FileStat;
import org.python.posix.LibCProvider;
import org.python.posix.POSIXHandler;
import org.python.posix.Solaris64FileStat;
import org.python.posix.SolarisHeapFileStat;
import org.python.posix.SolarisPasswd;
import org.python.posix.util.Platform;

final class SolarisPOSIX
extends BaseNativePOSIX {
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new SolarisPasswd((Pointer)arg) : null;
        }
    };

    SolarisPOSIX(String libraryName, LibCProvider libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    @Override
    public BaseHeapFileStat allocateStat() {
        return Platform.IS_32_BIT ? new SolarisHeapFileStat(this) : new Solaris64FileStat(this);
    }

    @Override
    public FileStat fstat(FileDescriptor fileDescriptor) {
        BaseHeapFileStat stat = this.allocateStat();
        int fd = this.helper.getfd(fileDescriptor);
        if ((Platform.IS_64_BIT ? this.libc().fstat(fd, stat) : this.libc().fstat64(fd, stat)) < 0) {
            this.handler.error(Errno.ENOENT, "" + fd);
        }
        return stat;
    }

    @Override
    public int lchmod(String filename, int mode) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    @Override
    public FileStat lstat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().lstat(path, stat) : this.libc().lstat64(path, stat)) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }

    @Override
    public FileStat stat(String path) {
        BaseHeapFileStat stat = this.allocateStat();
        if ((Platform.IS_64_BIT ? this.libc().stat(path, stat) : this.libc().stat64(path, stat)) < 0) {
            this.handler.error(Errno.ENOENT, path);
        }
        return stat;
    }
}

