/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.python.posix.FileStat;
import org.python.posix.POSIX;
import org.python.posix.util.Platform;

public class Finder {
    private static String PS = Platform.IS_WINDOWS ? ";" : ":";
    private static Map<String, String> EXECUTABLE_EXTENSIONS = new HashMap(){
        {
            this.put(".exe", ".exe");
            this.put(".com", ".com");
            this.put(".cmd", ".cmd");
            this.put(".bat", ".bat");
        }
    };

    public static String findFileInPath(POSIX posix, String name, String path) {
        if (path == null || path.length() == 0) {
            path = System.getenv("PATH");
        }
        if (path == null || path.length() == 0) {
            return name;
        }
        return Finder.findFileCommon(posix, name, path, true);
    }

    public static String findFileCommon(POSIX posix, String name, String path, boolean executableOnly) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int length = name.length();
        boolean isAbsolute = false;
        boolean isPath = false;
        int i = 0;
        if (Platform.IS_WINDOWS) {
            if (length > 1 && Character.isLetter(name.charAt(0)) && name.charAt(1) == ':') {
                i = 2;
                isAbsolute = true;
            }
            int extensionIndex = -1;
            char c = name.charAt(i);
            if (i == 47 || i == 92) {
                c = name.charAt(++i);
                isAbsolute = true;
            }
            while (i < length) {
                switch (c) {
                    case '/': 
                    case '\\': {
                        isPath = true;
                        extensionIndex = -1;
                        break;
                    }
                    case '.': {
                        extensionIndex = i - 1;
                    }
                }
                c = name.charAt(i);
                ++i;
            }
            if (extensionIndex >= 0 && EXECUTABLE_EXTENSIONS.get(name.substring(extensionIndex).toLowerCase()) == null) {
                extensionIndex = -1;
            }
            if (!executableOnly) {
                if (isAbsolute) {
                    return name;
                }
            } else if (isPath) {
                if (extensionIndex >= 0) {
                    return name;
                }
                if (executableOnly) {
                    return Finder.addExtension(name);
                }
                if (new File(name).exists()) {
                    return name;
                }
                return null;
            }
            String[] paths = path.split(PS);
            for (int p = 0; p < paths.length; ++p) {
                String home;
                String currentPath = paths[p];
                int currentPathLength = currentPath.length();
                if (currentPath == null || currentPathLength == 0) continue;
                if (currentPath.charAt(0) == '~' && (currentPathLength == 1 || currentPathLength > 1 && (currentPath.charAt(1) == '/' || currentPath.charAt(1) == '\\')) && (home = System.getenv("HOME")) != null) {
                    currentPath = home + (currentPathLength == 1 ? "" : currentPath.substring(1));
                }
                if (!currentPath.endsWith("/") && !currentPath.endsWith("\\")) {
                    currentPath = currentPath + "\\";
                }
                String filename = currentPath + name;
                if (Platform.IS_WINDOWS) {
                    filename.replace('/', '\\');
                }
                if (Platform.IS_WINDOWS && executableOnly && extensionIndex == -1) {
                    String extendedFilename = Finder.addExtension(filename);
                    if (extendedFilename == null) continue;
                    return extendedFilename;
                }
                FileStat stat = posix.allocateStat();
                int value = posix.libc().stat(filename, stat);
                if (value < 0) continue;
                if (!executableOnly) {
                    return filename;
                }
                if (stat.isDirectory() || !stat.isExecutable()) continue;
                return filename;
            }
        }
        return null;
    }

    public static String addExtension(String path) {
        for (String extension : EXECUTABLE_EXTENSIONS.keySet()) {
            String newPath = path + extension;
            if (!new File(newPath).exists()) continue;
            return newPath;
        }
        return null;
    }
}

