/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerGroup;
import org.gatein.registration.InvalidConsumerDataException;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationDestructionListener;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPersistenceManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.spi.ConsumerSPI;
import org.gatein.registration.spi.RegistrationSPI;
import org.gatein.wsrp.registration.PropertyDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationManagerImpl
implements RegistrationManager {
    private static final Logger log = LoggerFactory.getLogger(RegistrationManager.class);
    private RegistrationPolicy policy;
    private RegistrationPersistenceManager persistenceManager;
    private AtomicReference<CopyOnWriteArrayList<RegistrationDestructionListener>> listeners = new AtomicReference();
    public static final String NON_REGISTERED_CONSUMER = "NONREGISTERED";

    @Override
    public RegistrationPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicy(RegistrationPolicy policy) {
        this.policy = policy;
    }

    @Override
    public RegistrationPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public void setPersistenceManager(RegistrationPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    @Override
    public void addRegistrationDestructionListener(RegistrationDestructionListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationDestructionListener");
        this.listeners.compareAndSet(null, new CopyOnWriteArrayList());
        this.listeners.get().add(listener);
    }

    @Override
    public void removeRegistrationDestructionListener(RegistrationDestructionListener listener) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)listener, (String)"RegistrationDestructionListener");
        if (this.listeners.get() == null) {
            return;
        }
        this.listeners.get().remove(listener);
    }

    @Override
    public Registration addRegistrationTo(String consumerName, Map<QName, Object> registrationProperties, Map<QName, ? extends PropertyDescription> expectations, boolean createConsumerIfNeeded) throws RegistrationException {
        String identity = this.policy.getConsumerIdFrom(consumerName, registrationProperties);
        this.policy.validateRegistrationDataFor(registrationProperties, identity, expectations, this);
        Consumer consumer = this.getOrCreateConsumer(identity, createConsumerIfNeeded, consumerName);
        RegistrationSPI registration = this.persistenceManager.addRegistrationFor((ConsumerSPI)consumer, registrationProperties);
        this.createAndSetRegistrationHandle(registration);
        return registration;
    }

    private void createAndSetRegistrationHandle(RegistrationSPI registration) {
        String handle = this.policy.createRegistrationHandleFor(registration.getPersistentKey());
        registration.setRegistrationHandle(handle);
    }

    @Override
    public Consumer createConsumer(String name) throws RegistrationException, InvalidConsumerDataException {
        this.policy.validateConsumerName(name, this);
        String identity = this.policy.getConsumerIdFrom(name, Collections.<QName, Object>emptyMap());
        Consumer consumer = this.persistenceManager.createConsumer(identity, name);
        String groupName = this.policy.getAutomaticGroupNameFor(name);
        if (groupName != null) {
            this.addConsumerToGroupNamed(name, groupName, true, false);
        }
        return consumer;
    }

    @Override
    public Consumer addConsumerToGroupNamed(String consumerName, String groupName, boolean createGroupIfNeeded, boolean createConsumerIfNeeded) throws RegistrationException {
        String identity;
        block7: {
            if (createGroupIfNeeded) {
                this.policy.validateConsumerGroupName(groupName, this);
            }
            if (createConsumerIfNeeded) {
                this.policy.validateConsumerName(consumerName, this);
            }
            ConsumerGroup group = this.getConsumerGroup(groupName);
            boolean justCreatedGroup = false;
            if (group == null) {
                if (createGroupIfNeeded) {
                    this.createConsumerGroup(groupName);
                    justCreatedGroup = true;
                } else {
                    throw new NoSuchRegistrationException("There is no existing ConsumerGroup named '" + groupName + "'.");
                }
            }
            identity = this.policy.getConsumerIdFrom(consumerName, Collections.EMPTY_MAP);
            try {
                this.getOrCreateConsumer(identity, createConsumerIfNeeded, consumerName);
            }
            catch (NoSuchRegistrationException e) {
                if (!justCreatedGroup) break block7;
                this.removeConsumerGroup(groupName);
            }
        }
        return this.persistenceManager.addConsumerToGroupNamed(identity, groupName);
    }

    @Override
    public ConsumerGroup createConsumerGroup(String groupName) throws RegistrationException {
        this.policy.validateConsumerGroupName(groupName, this);
        return this.persistenceManager.createConsumerGroup(groupName);
    }

    @Override
    public void removeConsumer(String identity) throws RegistrationException, NoSuchRegistrationException {
        Consumer consumer = this.getOrCreateConsumer(identity, false, null);
        ConsumerGroup group = consumer.getGroup();
        if (group != null) {
            group.removeConsumer(consumer);
        }
        ArrayList<Registration> registrations = new ArrayList<Registration>(consumer.getRegistrations());
        for (Registration reg : registrations) {
            this.removeRegistration(reg);
        }
        this.persistenceManager.removeConsumer(identity);
    }

    @Override
    public void removeConsumer(Consumer consumer) throws RegistrationException, NoSuchRegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)consumer, (String)"Consumer");
        this.removeConsumer(consumer.getId());
    }

    @Override
    public Consumer getConsumerByIdentity(String identity) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)identity, (String)"identity", null);
        return this.persistenceManager.getConsumerById(identity);
    }

    @Override
    public boolean isConsumerExisting(String consumerId) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerId, (String)"consumer id", null);
        return this.persistenceManager.isConsumerExisting(consumerId);
    }

    @Override
    public Consumer getConsumerFor(String registrationHandle) throws RegistrationException {
        return (Consumer)this.getConsumerOrRegistration(registrationHandle, true);
    }

    @Override
    public Registration getRegistration(String registrationHandle) throws RegistrationException {
        return (Registration)this.getConsumerOrRegistration(registrationHandle, false);
    }

    @Override
    public Registration getNonRegisteredRegistration() throws RegistrationException {
        Consumer unregConsumer = this.getConsumerByIdentity(NON_REGISTERED_CONSUMER);
        if (unregConsumer == null) {
            Registration registration = this.addRegistrationTo(NON_REGISTERED_CONSUMER, new HashMap<QName, Object>(), null, true);
            registration.setStatus(RegistrationStatus.VALID);
            this.getPersistenceManager().saveChangesTo(registration);
            return registration;
        }
        Registration registration = unregConsumer.getRegistrations().iterator().next();
        if (registration.getRegistrationHandle() == null || RegistrationStatus.PENDING == registration.getStatus()) {
            this.createAndSetRegistrationHandle((RegistrationSPI)registration);
            registration.setStatus(RegistrationStatus.VALID);
            this.getPersistenceManager().saveChangesTo(registration);
        }
        return registration;
    }

    @Override
    public void removeRegistration(String registrationHandle) throws RegistrationException, NoSuchRegistrationException {
        Registration registration = this.getRegistration(registrationHandle);
        if (registration == null) {
            throw new NoSuchRegistrationException("There is no Registration with handle '" + registrationHandle + "'");
        }
        this.removeRegistration(registration);
    }

    @Override
    public void removeRegistration(Registration registration) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        registration.setStatus(RegistrationStatus.INVALID);
        AtomicBoolean canRemove = new AtomicBoolean(true);
        if (this.listeners.get() != null) {
            for (RegistrationDestructionListener listener : this.listeners.get()) {
                RegistrationDestructionListener.Vote vote = listener.destructionScheduledFor(registration);
                if (!canRemove.compareAndSet(false, vote.result)) continue;
                throw new RegistrationException("Could not remove Registration '" + registration.getRegistrationHandle() + "' because listener '" + listener + "' vetoed removal. Cause: " + vote.reason);
            }
        }
        this.persistenceManager.removeRegistration(registration.getPersistentKey());
    }

    @Override
    public ConsumerGroup getConsumerGroup(String groupName) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)groupName, (String)"ConsumerGroup name", null);
        return this.persistenceManager.getConsumerGroup(groupName);
    }

    private Consumer getOrCreateConsumer(String identity, boolean createConsumerIfNeeded, String consumerName) throws RegistrationException {
        Consumer consumer = this.getConsumerByIdentity(identity);
        if (consumer == null) {
            if (createConsumerIfNeeded) {
                consumer = this.createConsumer(consumerName);
            } else {
                throw new NoSuchRegistrationException("There is no Consumer named '" + consumerName + "'.");
            }
        }
        return consumer;
    }

    private Object getConsumerOrRegistration(String registrationHandle, boolean getConsumer) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationHandle, (String)"registration handle", null);
        Registration registration = this.persistenceManager.getRegistration(registrationHandle);
        if (registration == null) {
            return null;
        }
        return getConsumer ? registration.getConsumer() : registration;
    }

    @Override
    public Collection<? extends ConsumerGroup> getConsumerGroups() throws RegistrationException {
        return this.persistenceManager.getConsumerGroups();
    }

    @Override
    public void removeConsumerGroup(ConsumerGroup group) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)group, (String)"ConsumerGroup");
        for (Consumer consumer : group.getConsumers()) {
            this.removeConsumer(consumer);
        }
        this.persistenceManager.removeConsumerGroup(group.getName());
    }

    @Override
    public void removeConsumerGroup(String name) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"ConsumerGroup name");
        this.removeConsumerGroup(this.getConsumerGroup(name));
    }

    @Override
    public Collection<? extends Consumer> getConsumers() throws RegistrationException {
        return this.persistenceManager.getConsumers();
    }

    @Override
    public void clear() throws RegistrationException {
        ArrayList<? extends Consumer> consumers = new ArrayList<Consumer>(this.getConsumers());
        for (Consumer consumer : consumers) {
            this.removeConsumer(consumer);
        }
        ArrayList<? extends ConsumerGroup> groups = new ArrayList<ConsumerGroup>(this.getConsumerGroups());
        for (ConsumerGroup consumerGroup : groups) {
            this.removeConsumerGroup(consumerGroup);
        }
    }

    @Override
    public void propertiesHaveChanged(Map<QName, ? extends PropertyDescription> registrationProperties) {
        block6: {
            if (log.isDebugEnabled()) {
                log.debug("Registration properties have changed, existing registrations will be invalidated...");
            }
            try {
                Collection<? extends Registration> registrations = this.persistenceManager.getRegistrations();
                Iterator<? extends Registration> i$ = registrations.iterator();
                while (i$.hasNext()) {
                    Registration registration;
                    Registration reg = registration = i$.next();
                    reg.setStatus(RegistrationStatus.PENDING);
                    Consumer consumer = reg.getConsumer();
                    try {
                        this.persistenceManager.saveChangesTo(consumer);
                    }
                    catch (RegistrationException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Couldn't persist changes to Consumer '" + consumer.getId() + "'", (Throwable)e);
                    }
                }
            }
            catch (RegistrationException e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("Couldn't retrieve registrations...", (Throwable)e);
            }
        }
    }

    @Override
    public void policyUpdatedTo(RegistrationPolicy policy) {
        this.setPolicy(policy);
    }
}

