/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.gatein.registration.RegistrationPolicyChangeListener;
import org.gatein.registration.RegistrationPropertyChangeListener;
import org.gatein.wsrp.producer.WSRPValidator;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationChangeListener;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;

public abstract class AbstractProducerConfigurationService
implements ProducerConfigurationService {
    protected AtomicReference<ProducerConfiguration> configuration = new AtomicReference();

    @Override
    public ProducerConfiguration getConfiguration() {
        if (this.configuration.get() == null || this.configuration.get().getLastModified() < this.getPersistedLastModifiedForConfiguration()) {
            try {
                this.reloadConfiguration();
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't get Producer configuration", e);
            }
        }
        return this.configuration.get();
    }

    @Override
    public void reloadConfiguration() throws Exception {
        this.reloadConfiguration(false);
    }

    @Override
    public void reloadConfiguration(boolean triggerListeners) throws Exception {
        ProducerRegistrationRequirements registrationRequirements;
        List<ProducerConfigurationChangeListener> listeners = null;
        Set<RegistrationPolicyChangeListener> policyListeners = null;
        Set<RegistrationPropertyChangeListener> propertyListeners = null;
        if (this.configuration.get() != null) {
            listeners = this.configuration.get().getChangeListeners();
            registrationRequirements = this.configuration.get().getRegistrationRequirements();
            if (registrationRequirements != null) {
                policyListeners = registrationRequirements.getPolicyChangeListeners();
                propertyListeners = registrationRequirements.getPropertyChangeListeners();
            }
        }
        this.loadConfiguration();
        WSRPValidator.setStrict(this.configuration.get().isUsingStrictMode());
        if (listeners != null) {
            for (ProducerConfigurationChangeListener producerConfigurationChangeListener : listeners) {
                this.configuration.get().addChangeListener(producerConfigurationChangeListener);
                if (!triggerListeners) continue;
                producerConfigurationChangeListener.usingStrictModeChangedTo(this.configuration.get().isUsingStrictMode());
            }
        }
        if ((registrationRequirements = this.configuration.get().getRegistrationRequirements()) != null) {
            if (propertyListeners != null) {
                for (RegistrationPropertyChangeListener registrationPropertyChangeListener : propertyListeners) {
                    registrationRequirements.addRegistrationPropertyChangeListener(registrationPropertyChangeListener);
                    if (!triggerListeners) continue;
                    registrationPropertyChangeListener.propertiesHaveChanged(registrationRequirements.getRegistrationProperties());
                }
            }
            if (policyListeners != null) {
                for (RegistrationPolicyChangeListener registrationPolicyChangeListener : policyListeners) {
                    registrationRequirements.addRegistrationPolicyChangeListener(registrationPolicyChangeListener);
                    if (!triggerListeners) continue;
                    registrationPolicyChangeListener.policyUpdatedTo(registrationRequirements.getPolicy());
                }
            }
        }
    }

    protected abstract void loadConfiguration() throws Exception;

    public long getPersistedLastModifiedForConfiguration() {
        return this.configuration.get().getLastModified();
    }
}

