/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.impl.xml;

import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import org.gatein.common.net.URLTools;
import org.gatein.wsrp.producer.config.impl.xml.SimpleXMLProducerConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemXMLProducerConfigurationService
extends SimpleXMLProducerConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(FileSystemXMLProducerConfigurationService.class);
    private String configLocation;
    private File config;

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void start() throws Exception {
        File dataDir = new File(System.getProperty("java.io.tmpdir"));
        File portalDir = new File(dataDir, "portal");
        if (!portalDir.exists()) {
            if (!portalDir.mkdir()) {
                throw new RuntimeException("Couldn't create 'portal' directory in " + dataDir.getAbsolutePath());
            }
        } else if (!portalDir.isDirectory()) {
            throw new RuntimeException("Was expecting a directory named 'portal' in " + dataDir.getAbsolutePath() + ", not a simple file! Cannot continue.");
        }
        this.config = new File(portalDir, "wsrp-producer-config.xml");
        this.reloadConfiguration();
    }

    @Override
    public void loadConfiguration() throws Exception {
        block2: {
            URL configURL = this.getConfigLocationURL();
            try {
                this.loadConfigurationAt(configURL);
            }
            catch (Exception e) {
                if (!this.config.exists()) break block2;
                log.debug("Configuration saved at " + this.config.getCanonicalPath() + " is not loading properly. Falling back to default configuration.");
                this.config.delete();
                this.loadConfigurationAt(this.getConfigLocationURL());
            }
        }
    }

    private void loadConfigurationAt(URL configURL) throws Exception {
        log.debug("About to parse producer configuration " + configURL);
        this.inputStream = configURL.openStream();
        super.loadConfiguration();
    }

    private URL getConfigLocationURL() throws Exception {
        if (!this.config.exists()) {
            if (this.configLocation == null) {
                throw new Exception("The config location is null");
            }
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(this.configLocation);
            URL configURL = null;
            while (resources.hasMoreElements()) {
                configURL = resources.nextElement();
            }
            if (configURL == null) {
                throw new Exception("The config " + this.configLocation + " does not exist");
            }
            if (!URLTools.exists((URL)configURL)) {
                throw new Exception("The config " + configURL + " does not exist");
            }
            return configURL;
        }
        return this.config.toURI().toURL();
    }

    @Override
    public void saveConfiguration() throws Exception {
        this.saveConfigurationTo(this.config);
    }
}

