/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.registration.Consumer;
import org.gatein.registration.ConsumerCapabilities;
import org.gatein.registration.NoSuchRegistrationException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.RegistrationUtils;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.RegistrationInterface;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.handlers.ServiceHandler;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.Deregister;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetRegistrationLifetime;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.Lifetime;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistration;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.Property;
import org.oasis.wsrp.v2.Register;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.RegistrationData;
import org.oasis.wsrp.v2.RegistrationState;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.SetRegistrationLifetime;

public class RegistrationHandler
extends ServiceHandler
implements RegistrationInterface {
    public RegistrationHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    @Override
    public RegistrationContext register(Register register) throws MissingParameters, OperationFailed, OperationNotSupported {
        Registration registration;
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)register, (String)"Register");
        RegistrationData registrationData = register.getRegistrationData();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)registrationData, (String)"RegistrationData", (String)"Register");
        ProducerRegistrationRequirements registrationRequirements = this.producer.getProducerRegistrationRequirements();
        String consumerName = registrationData.getConsumerName();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerName, (String)"consumer name", (String)"RegistrationData");
        String consumerAgent = registrationData.getConsumerAgent();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerAgent, (String)"consumer agent", (String)"RegistrationData");
        try {
            log.debug("Attempting to register consumer named '" + consumerName + "', agent '" + consumerAgent + "'.");
            RegistrationUtils.validateConsumerAgent(consumerAgent);
            registration = this.producer.getRegistrationManager().addRegistrationTo(consumerName, this.createRegistrationProperties(registrationData), registrationRequirements.getRegistrationProperties(), true);
            this.updateRegistrationInformation(registration, registrationData);
        }
        catch (Exception e) {
            String msg = "Could not register consumer named '" + consumerName + "'";
            log.debug(msg, (Throwable)e);
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)msg, (Throwable)e);
        }
        RegistrationContext registrationContext = WSRPTypeFactory.createRegistrationContext((String)registration.getRegistrationHandle());
        log.debug("Registration completed without error.");
        return registrationContext;
    }

    private void updateRegistrationInformation(Registration registration, RegistrationData registrationData) throws RegistrationException {
        registration.setStatus(RegistrationStatus.VALID);
        Consumer consumer = registration.getConsumer();
        consumer.setConsumerAgent(registrationData.getConsumerAgent());
        ConsumerCapabilities capabilities = consumer.getCapabilities();
        List modeStrings = registrationData.getConsumerModes();
        modeStrings = WSRPUtils.replaceByEmptyListIfNeeded((List)modeStrings);
        int modesNb = modeStrings.size();
        if (modesNb > 0) {
            ArrayList<Mode> modes = new ArrayList<Mode>(modesNb);
            for (String modeString : modeStrings) {
                modes.add(WSRPUtils.getJSR168PortletModeFromWSRPName((String)modeString));
            }
            capabilities.setSupportedModes(modes);
        }
        List wsStrings = registrationData.getConsumerWindowStates();
        int wsNb = (wsStrings = WSRPUtils.replaceByEmptyListIfNeeded((List)wsStrings)).size();
        if (wsNb > 0) {
            ArrayList<WindowState> windowStates = new ArrayList<WindowState>(wsNb);
            for (String wsString : wsStrings) {
                windowStates.add(WSRPUtils.getJSR168WindowStateFromWSRPName((String)wsString));
            }
            capabilities.setSupportedWindowStates(windowStates);
        }
        capabilities.setSupportedUserScopes(registrationData.getConsumerUserScopes());
        capabilities.setSupportsGetMethod(registrationData.isMethodGetSupported());
        this.producer.getRegistrationManager().getPersistenceManager().saveChangesTo(consumer);
    }

    @Override
    public List<Extension> deregister(Deregister deregister) throws InvalidRegistration, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)deregister, (String)"Deregister");
        if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired()) {
            RegistrationContext registrationContext = deregister.getRegistrationContext();
            WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)registrationContext, (String)"RegistrationContext");
            String registrationHandle = registrationContext.getRegistrationHandle();
            if (ParameterValidation.isNullOrEmpty((String)registrationHandle)) {
                this.throwInvalidRegistrationFault("Null or empty registration handle");
            }
            log.debug("Attempting to deregister registration with handle '" + registrationHandle + "'");
            String msg = "Could not deregister registration with handle '" + registrationHandle + "'";
            try {
                this.producer.getRegistrationManager().removeRegistration(registrationHandle);
            }
            catch (NoSuchRegistrationException e) {
                log.debug(msg, (Throwable)e);
                this.throwInvalidRegistrationFault(e.getLocalizedMessage());
            }
            catch (RegistrationException e) {
                log.debug(msg, (Throwable)e);
                throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)msg, (Throwable)e);
            }
            return Collections.emptyList();
        }
        throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Deregistration shouldn't be attempted if registration is not required", null);
    }

    @Override
    public RegistrationState modifyRegistration(ModifyRegistration modifyRegistration) throws InvalidRegistration, MissingParameters, OperationFailed, OperationNotSupported, ResourceSuspended {
        if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired()) {
            WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)modifyRegistration, (String)"ModifyRegistration");
            RegistrationContext registrationContext = modifyRegistration.getRegistrationContext();
            WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)registrationContext, (String)"RegistrationContext", (String)"ModifyRegistration");
            String registrationHandle = registrationContext.getRegistrationHandle();
            if (ParameterValidation.isNullOrEmpty((String)registrationHandle)) {
                this.throwInvalidRegistrationFault("Null or empty registration handle");
            }
            RegistrationData registrationData = modifyRegistration.getRegistrationData();
            WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)registrationData, (String)"RegistrationData", (String)"ModifyRegistration");
            String consumerName = registrationData.getConsumerName();
            WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerName, (String)"consumer name", (String)"RegistrationData");
            String consumerAgent = registrationData.getConsumerAgent();
            WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)consumerAgent, (String)"consumer agent", (String)"RegistrationData");
            log.debug("Attempting to modify registration with handle '" + registrationHandle + "'");
            String msg = "Could not modify registration with handle '" + registrationHandle + "'";
            try {
                Registration registration = this.producer.getRegistrationManager().getRegistration(registrationHandle);
                Map<QName, Object> properties = this.createRegistrationProperties(registrationData);
                ProducerRegistrationRequirements req = this.producer.getProducerRegistrationRequirements();
                req.getPolicy().validateRegistrationDataFor(properties, consumerName, req.getRegistrationProperties(), this.producer.getRegistrationManager());
                registration.updateProperties(properties);
                this.updateRegistrationInformation(registration, registrationData);
            }
            catch (NoSuchRegistrationException e) {
                log.debug(msg, (Throwable)e);
                this.throwInvalidRegistrationFault(e.getLocalizedMessage());
            }
            catch (RegistrationException e) {
                log.debug(msg, (Throwable)e);
                throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)msg, (Throwable)e);
            }
            log.debug("Modified registration with handle '" + registrationHandle + "'");
            return null;
        }
        throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)"Modifying a registration shouldn't be attempted if registration is not required", null);
    }

    @Override
    public Lifetime getRegistrationLifetime(GetRegistrationLifetime getRegistrationLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        throw (OperationNotSupported)((Object)WSRP2ExceptionFactory.throwWSException(OperationNotSupported.class, (String)"Lifetime operations are not currently supported.", null));
    }

    @Override
    public Lifetime setRegistrationLifetime(SetRegistrationLifetime setRegistrationLifetime) throws AccessDenied, InvalidHandle, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        throw (OperationNotSupported)((Object)WSRP2ExceptionFactory.throwWSException(OperationNotSupported.class, (String)"Lifetime operations are not currently supported.", null));
    }

    public boolean isRegistrationValid(Registration reg, boolean throwExceptionIfInvalid) throws InvalidRegistration, OperationFailed, ModifyRegistrationRequired {
        boolean registrationRequired = this.producer.getProducerRegistrationRequirements().isRegistrationRequired();
        if (reg == null) {
            if (registrationRequired) {
                log.debug("Registration is required yet no RegistrationContext was provided: registration invalid!");
                if (throwExceptionIfInvalid) {
                    this.throwInvalidRegistrationFault("registration is required yet no RegistrationContext was provided!");
                }
                return false;
            }
            log.debug("Registration not required, no registration: registration valid!");
            return true;
        }
        boolean isValid = RegistrationStatus.VALID.equals(reg.getStatus());
        if (registrationRequired) {
            boolean isPending = RegistrationStatus.PENDING.equals(reg.getStatus());
            log.debug("Registration required: registration is " + (isValid ? "valid!" : (isPending ? "pending!" : "invalid!")));
            if (throwExceptionIfInvalid) {
                if (isPending) {
                    WSRP2ExceptionFactory.throwWSException(ModifyRegistrationRequired.class, (String)("Registration with handle '" + reg.getRegistrationHandle() + "' is pending. Consumer needs to call modifyRegistration()."), null);
                } else if (!isValid) {
                    this.throwInvalidRegistrationFault("registration with handle '" + reg.getRegistrationHandle() + "' is not valid!");
                }
            }
            return isValid;
        }
        if (!isValid && throwExceptionIfInvalid) {
            this.throwInvalidRegistrationFault("registration information was provided but registration is not required!");
        }
        return isValid;
    }

    public Registration getRegistrationFrom(RegistrationContext registrationContext) throws InvalidRegistration, OperationFailed {
        if (this.producer.getProducerRegistrationRequirements().isRegistrationRequired() && registrationContext == null) {
            this.throwInvalidRegistrationFault("registration context is missing but registration is required");
        }
        if (registrationContext != null) {
            String regHandle = registrationContext.getRegistrationHandle();
            if (regHandle == null) {
                this.throwInvalidRegistrationFault("registration handle is missing but registration is required");
            }
            try {
                Registration registration = this.producer.getRegistrationManager().getRegistration(regHandle);
                if (registration == null) {
                    this.throwInvalidRegistrationFault("provided registration handle '" + regHandle + "' is not registered with this producer");
                }
                return registration;
            }
            catch (RegistrationException e) {
                this.throwOperationFailedFault("Failed to retrieve registration information associated with handle " + regHandle, e);
                return null;
            }
        }
        try {
            Registration registration = this.producer.getRegistrationManager().getNonRegisteredRegistration();
            if (registration == null) {
                this.throwInvalidRegistrationFault("Could not acquire the nonregistered registration from the RegistrationManager");
            }
            return registration;
        }
        catch (RegistrationException e) {
            this.throwOperationFailedFault("Failed to retrieve registration information associated with the nonregistered consumer", e);
            return null;
        }
    }

    private void throwOperationFailedFault(String message, RegistrationException e) throws OperationFailed {
        throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)message, (Throwable)e);
    }

    boolean throwInvalidRegistrationFault(String message) throws InvalidRegistration {
        throw (InvalidRegistration)WSRP2ExceptionFactory.throwWSException(InvalidRegistration.class, (String)("Invalid registration: " + message), null);
    }

    private Map<QName, Object> createRegistrationProperties(RegistrationData registrationData) {
        Map<QName, Object> properties;
        List regProperties = registrationData.getRegistrationProperties();
        if ((regProperties = WSRPUtils.replaceByEmptyListIfNeeded((List)regProperties)) != null && !regProperties.isEmpty()) {
            properties = new HashMap<QName, Object>(regProperties.size());
            for (Property property : regProperties) {
                QName propName = property.getName();
                String propValue = property.getStringValue();
                if (this.producer.getProducerRegistrationRequirements().acceptValueFor(propName, (Object)propValue)) {
                    properties.put(propName, propValue);
                    continue;
                }
                throw new IllegalArgumentException("Registration properties named '" + propName + "' with value '" + propValue + "' was rejected by the WSRP producer.");
            }
        } else {
            properties = Collections.emptyMap();
        }
        return properties;
    }

    private List getListFromArray(String[] array, boolean useEmptyForNull) {
        if (array == null) {
            return useEmptyForNull ? Collections.EMPTY_LIST : null;
        }
        return Arrays.asList(array);
    }
}

