/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.TransportGuarantee;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.EventInfo;
import org.gatein.pc.api.info.EventingInfo;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.RuntimeOptionInfo;
import org.gatein.pc.api.info.SecurityInfo;
import org.gatein.pc.api.info.WindowStateInfo;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletContainer;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationLocal;
import org.gatein.wsrp.SupportsLastModified;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.ServiceDescriptionInterface;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.handlers.ServiceHandler;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.CookieProtocol;
import org.oasis.wsrp.v2.EventDescription;
import org.oasis.wsrp.v2.GetServiceDescription;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.LocalizedString;
import org.oasis.wsrp.v2.MarkupType;
import org.oasis.wsrp.v2.ModelDescription;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.ParameterDescription;
import org.oasis.wsrp.v2.PortletContext;
import org.oasis.wsrp.v2.PortletDescription;
import org.oasis.wsrp.v2.RegistrationContext;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.ServiceDescription;

public class ServiceDescriptionHandler
extends ServiceHandler
implements ServiceDescriptionInterface,
ManagedObjectRegistryEventListener {
    private static final CookieProtocol BEA_8_CONSUMER_FIX = CookieProtocol.PER_USER;
    private ServiceDescriptionInfo serviceDescription;
    private static final List<String> OPTIONS = new ArrayList<String>(5);

    public ServiceDescriptionHandler(WSRPProducerImpl producer) {
        super(producer);
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceDescription getServiceDescription(GetServiceDescription gs) throws InvalidRegistration, ModifyRegistrationRequired, OperationFailed, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)gs, (String)"GetServiceDescription");
        try {
            RegistrationContext registrationContext = gs.getRegistrationContext();
            Registration registration = null;
            if (registrationContext != null) {
                registration = this.producer.getRegistrationOrFailIfInvalid(registrationContext);
                RegistrationLocal.setRegistration(registration);
            }
            ProducerRegistrationRequirements requirements = this.producer.getProducerRegistrationRequirements();
            this.serviceDescription.updateRegistrationProperties(requirements);
            boolean needsRegistrationProperties = registration == null && requirements.isRegistrationRequired();
            boolean needsPortletDescriptions = registration != null || !requirements.isRegistrationRequired() || !requirements.isRegistrationRequiredForFullDescription();
            List portletHandles = WSRPUtils.replaceByEmptyListIfNeeded((List)gs.getPortletHandles());
            List desiredLocales = WSRPUtils.replaceByEmptyListIfNeeded((List)gs.getDesiredLocales());
            ServiceDescription serviceDescription = this.serviceDescription.getServiceDescription(needsRegistrationProperties, needsPortletDescriptions, portletHandles, desiredLocales);
            return serviceDescription;
        }
        finally {
            RegistrationLocal.setRegistration(null);
        }
    }

    public PortletDescription getPortletDescription(PortletContext portletContext, List<String> desiredLocales, Registration registration) throws InvalidHandle, OperationFailed {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        PortletDescription description = this.serviceDescription.getPortletDescription(portletContext, desiredLocales, registration);
        if (description == null) {
            throw (InvalidHandle)WSRP2ExceptionFactory.throwWSException(InvalidHandle.class, (String)("Couldn't find portlet '" + portletContext.getPortletHandle() + "'. Check that it's properly deployed."), null);
        }
        return description;
    }

    public void onEvent(ManagedObjectRegistryEvent event) {
        ManagedObjectEvent managedObjectEvent;
        ManagedObject managedObject;
        if (event instanceof ManagedObjectEvent && (managedObject = (managedObjectEvent = (ManagedObjectEvent)event).getManagedObject()) instanceof ManagedPortletContainer) {
            ManagedPortletContainer portletContainer = (ManagedPortletContainer)managedObject;
            String applicationId = portletContainer.getManagedPortletApplication().getId();
            String containerId = portletContainer.getId();
            org.gatein.pc.api.PortletContext pc = org.gatein.pc.api.PortletContext.createPortletContext((String)applicationId, (String)containerId);
            if (managedObjectEvent instanceof ManagedObjectLifeCycleEvent) {
                ManagedObjectLifeCycleEvent lifeCycleEvent = (ManagedObjectLifeCycleEvent)managedObjectEvent;
                LifeCycleStatus status = lifeCycleEvent.getStatus();
                if (LifeCycleStatus.STARTED.equals((Object)status)) {
                    PortletInfo info = portletContainer.getInfo();
                    if (this.isRemotable(info.getRuntimeOptionsInfo())) {
                        this.serviceDescription.addPortletDescription(pc, info);
                    }
                } else {
                    this.serviceDescription.removePortletDescription(pc);
                }
            }
        }
    }

    private static List<String> getLocaleNamesFrom(Collection<Locale> locales) {
        if (locales == null || locales.isEmpty()) {
            return null;
        }
        ArrayList<String> localeNames = new ArrayList<String>(locales.size());
        for (Locale locale : locales) {
            localeNames.add(WSRPUtils.toString((Locale)locale));
        }
        return localeNames;
    }

    private static List<String> getWindowStateNamesFrom(Collection<WindowStateInfo> windowStates) {
        ArrayList<String> result = new ArrayList<String>(windowStates.size());
        for (WindowStateInfo windowStateInfo : windowStates) {
            result.add(WSRPUtils.convertJSR168WindowStateNameToWSRPName((String)windowStateInfo.getWindowStateName()));
        }
        return result;
    }

    private static List<String> getModeNamesFrom(Collection<ModeInfo> modes) {
        ArrayList<String> result = new ArrayList<String>(modes.size());
        for (ModeInfo modeInfo : modes) {
            result.add(WSRPUtils.convertJSR168PortletModeNameToWSRPName((String)modeInfo.getModeName()));
        }
        return result;
    }

    public void reset() {
        this.serviceDescription = new ServiceDescriptionInfo();
    }

    public boolean isRemotable(Map<String, RuntimeOptionInfo> runtimeOptions) {
        RuntimeOptionInfo runtimeOptionInfo = runtimeOptions.get("org.gatein.pc.remotable");
        return runtimeOptionInfo != null && "true".equals(runtimeOptionInfo.getValues().get(0));
    }

    static {
        OPTIONS.add("wsrp:events");
        OPTIONS.add("wsrp:import");
        OPTIONS.add("wsrp:export");
        OPTIONS.add("wsrp:copyPortlets");
    }

    private class ServiceDescriptionInfo {
        private long lastGenerated;
        private Map<QName, EventDescription> eventDescriptions;
        private Map<QName, Integer> eventReferenceCount;
        private Map<String, PortletDescriptionInfo> portletDescriptions;
        private ModelDescription registrationProperties;
        private boolean initialized = false;
        private boolean requireRegistrations;

        private ServiceDescriptionInfo() {
            this.reset();
        }

        void reset() {
            this.lastGenerated = 0L;
            this.eventDescriptions = new HashMap<QName, EventDescription>(37);
            this.eventReferenceCount = new HashMap<QName, Integer>(37);
            this.portletDescriptions = new HashMap<String, PortletDescriptionInfo>(37);
            this.registrationProperties = null;
            this.initialized = false;
            this.requireRegistrations = false;
        }

        private void updateRegistrationProperties(ProducerRegistrationRequirements requirements) {
            long lastModified = requirements.getLastModified();
            if (lastModified > this.lastGenerated) {
                Map<QName, RegistrationPropertyDescription> info;
                if (ServiceHandler.log.isDebugEnabled()) {
                    ServiceHandler.log.debug("Re-generating registration properties information for service description.");
                }
                this.registrationProperties = ParameterValidation.existsAndIsNotEmpty(info = requirements.getRegistrationProperties()) ? Utils.convertRegistrationPropertiesToModelDescription(info) : null;
                this.requireRegistrations = requirements.isRegistrationRequired();
                this.lastGenerated = SupportsLastModified.now();
            }
        }

        private void updatePortletDescriptions() {
            try {
                Set<Portlet> portlets = ServiceDescriptionHandler.this.producer.getRemotablePortlets();
                if (ParameterValidation.existsAndIsNotEmpty(portlets)) {
                    for (Portlet portlet : portlets) {
                        this.addPortletDescription(portlet.getContext(), portlet.getInfo());
                    }
                }
                this.initialized = true;
            }
            catch (PortletInvokerException e) {
                ServiceHandler.log.warn("Couldn't get remotable portlets", (Throwable)e);
            }
        }

        private ServiceDescription getServiceDescription(boolean needsRegistrationProperties, boolean needsPortletDescriptions, List<String> portletHandles, List<String> desiredLocales) {
            this.initIfNeeded();
            ModelDescription registrationProperties = needsRegistrationProperties ? this.registrationProperties : null;
            ServiceDescription serviceDescription = WSRPTypeFactory.createServiceDescription((boolean)false);
            serviceDescription.setRequiresInitCookie(BEA_8_CONSUMER_FIX);
            List<String> supportedLocales = ServiceDescriptionHandler.this.producer.getSupportedLocales();
            serviceDescription.getLocales().addAll(supportedLocales);
            serviceDescription.getSupportedOptions().addAll(OPTIONS);
            serviceDescription.setRegistrationPropertyDescription(registrationProperties);
            serviceDescription.setRequiresRegistration(this.requireRegistrations);
            if (needsPortletDescriptions) {
                if (!ParameterValidation.existsAndIsNotEmpty(portletHandles)) {
                    portletHandles = new ArrayList<String>(this.portletDescriptions.keySet());
                }
                ArrayList<PortletDescription> portlets = new ArrayList<PortletDescription>(portletHandles.size());
                for (String handle : portletHandles) {
                    PortletDescription description = this.getPortletDescription(handle, desiredLocales);
                    if (description == null) continue;
                    portlets.add(description);
                }
                serviceDescription.getOfferedPortlets().addAll(portlets);
            }
            Collection<EventDescription> events = this.eventDescriptions.values();
            serviceDescription.getEventDescriptions().addAll(events);
            return serviceDescription;
        }

        private void initIfNeeded() {
            if (!this.initialized) {
                this.updatePortletDescriptions();
            }
        }

        private void addEventInfo(EventInfo info, Locale locale) {
            QName name = info.getName();
            if (!this.eventDescriptions.containsKey(name)) {
                EventDescription desc = WSRPTypeFactory.createEventDescription((QName)name);
                desc.setDescription(Utils.convertToWSRPLocalizedString(info.getDescription(), locale));
                desc.setLabel(Utils.convertToWSRPLocalizedString(info.getDisplayName(), locale));
                Collection aliases = info.getAliases();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)aliases)) {
                    desc.getAliases().addAll(aliases);
                }
                this.eventDescriptions.put(name, desc);
                this.eventReferenceCount.put(name, 1);
            } else {
                Integer current = this.eventReferenceCount.get(name);
                this.eventReferenceCount.put(name, current + 1);
            }
        }

        private void removeEvent(QName name) {
            Integer current = this.eventReferenceCount.get(name);
            if (current != null) {
                if (current == 1) {
                    this.eventDescriptions.remove(name);
                    this.eventReferenceCount.remove(name);
                } else {
                    this.eventReferenceCount.put(name, current - 1);
                }
            }
        }

        private void addPortletDescription(org.gatein.pc.api.PortletContext context, PortletInfo info) {
            String handle = context.getId();
            PortletDescriptionInfo desc = this.createPortletDescription(info, handle);
            this.portletDescriptions.put(handle, desc);
        }

        private PortletDescriptionInfo createPortletDescription(PortletInfo info, String handle) {
            List supportedLanguages;
            if (ServiceHandler.log.isDebugEnabled()) {
                ServiceHandler.log.debug("Constructing portlet description for: " + handle);
            }
            CapabilitiesInfo capInfo = info.getCapabilities();
            Set allMediaTypes = capInfo.getMediaTypes();
            ArrayList<MarkupType> markupTypes = new ArrayList<MarkupType>(allMediaTypes.size());
            for (MediaType mediaType : allMediaTypes) {
                MarkupType markupType = WSRPTypeFactory.createMarkupType((String)mediaType.getValue(), (List)ServiceDescriptionHandler.getModeNamesFrom(capInfo.getModes(mediaType)), (List)ServiceDescriptionHandler.getWindowStateNamesFrom(capInfo.getWindowStates(mediaType)), (List)ServiceDescriptionHandler.getLocaleNamesFrom(capInfo.getLocales(mediaType)));
                markupTypes.add(markupType);
            }
            MetaInfo metaInfo = info.getMeta();
            Set<Locale> supportedLocales = info.getCapabilities().getAllLocales();
            if (supportedLocales.size() == 0) {
                supportedLocales = Collections.singleton(Locale.ENGLISH);
                supportedLanguages = Collections.singletonList("en");
            } else {
                supportedLanguages = WSRPUtils.convertLocalesToRFC3066LanguageTags(new ArrayList<Locale>(supportedLocales));
            }
            PortletDescriptionInfo descriptionInfo = this.portletDescriptions.get(handle);
            if (descriptionInfo == null) {
                descriptionInfo = new PortletDescriptionInfo(supportedLanguages);
                this.portletDescriptions.put(handle, descriptionInfo);
            }
            for (Locale localeMatch : supportedLocales) {
                SecurityInfo secInfo;
                Collection parameterInfos;
                NavigationInfo navigationInfo;
                EventingInfo eventsInfo;
                String commaSeparatedKeywords;
                PortletDescription desc = WSRPTypeFactory.createPortletDescription((String)handle, markupTypes);
                desc.setGroupID(info.getApplicationName());
                desc.setDescription(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("description"), localeMatch));
                desc.setShortTitle(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("short-title"), localeMatch));
                desc.setTitle(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("title"), localeMatch));
                desc.setDisplayName(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("display-name"), localeMatch));
                LocalizedString concatenatedKeywords = Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("keywords"), localeMatch);
                if (concatenatedKeywords != null && (commaSeparatedKeywords = concatenatedKeywords.getValue()) != null && commaSeparatedKeywords.length() > 0) {
                    String[] keywordArray;
                    String lang = concatenatedKeywords.getLang();
                    for (String keyword : keywordArray = commaSeparatedKeywords.split(",")) {
                        desc.getKeywords().add(WSRPTypeFactory.createLocalizedString((String)lang, (String)concatenatedKeywords.getResourceName(), (String)keyword.trim()));
                    }
                }
                if ((eventsInfo = info.getEventing()) != null) {
                    Map consumedEvents;
                    Map producedEvents = eventsInfo.getProducedEvents();
                    if (ParameterValidation.existsAndIsNotEmpty((Map)producedEvents)) {
                        List publishedEvents = desc.getPublishedEvents();
                        for (Map.Entry entry : producedEvents.entrySet()) {
                            publishedEvents.add(entry.getKey());
                            this.addEventInfo((EventInfo)entry.getValue(), localeMatch);
                        }
                    }
                    if (ParameterValidation.existsAndIsNotEmpty((Map)(consumedEvents = eventsInfo.getConsumedEvents()))) {
                        List handledEvents = desc.getHandledEvents();
                        for (Map.Entry entry : consumedEvents.entrySet()) {
                            handledEvents.add(entry.getKey());
                            this.addEventInfo((EventInfo)entry.getValue(), localeMatch);
                        }
                    }
                }
                if ((navigationInfo = info.getNavigation()) != null && ParameterValidation.existsAndIsNotEmpty((Collection)(parameterInfos = navigationInfo.getPublicParameters()))) {
                    List publicValueDescriptions = desc.getNavigationalPublicValueDescriptions();
                    for (ParameterInfo parameterInfo : parameterInfos) {
                        String id = parameterInfo.getId();
                        ParameterDescription paramDesc = WSRPTypeFactory.createParameterDescription((String)id);
                        paramDesc.setDescription(Utils.convertToWSRPLocalizedString(parameterInfo.getDescription(), localeMatch));
                        paramDesc.setLabel(WSRPTypeFactory.createLocalizedString((String)id));
                        List names = paramDesc.getNames();
                        names.add(parameterInfo.getName());
                        Collection aliases = parameterInfo.getAliases();
                        if (ParameterValidation.existsAndIsNotEmpty((Collection)aliases)) {
                            names.addAll(aliases);
                        }
                        publicValueDescriptions.add(paramDesc);
                    }
                }
                if ((secInfo = info.getSecurity()).containsTransportGuarantee(TransportGuarantee.INTEGRAL) || secInfo.containsTransportGuarantee(TransportGuarantee.CONFIDENTIAL)) {
                    desc.setOnlySecure(Boolean.valueOf(true));
                }
                descriptionInfo.addDescriptionFor(WSRPUtils.toString((Locale)localeMatch), desc);
            }
            return descriptionInfo;
        }

        public PortletDescription getPortletDescription(PortletContext context, List<String> desiredLocales, Registration registration) {
            this.initIfNeeded();
            org.gatein.pc.api.PortletContext pcContext = WSRPUtils.convertToPortalPortletContext((PortletContext)context);
            if (ServiceDescriptionHandler.this.producer.getRegistrationManager().getPolicy().allowAccessTo(pcContext, registration, "getPortletDescription")) {
                PortletDescription description = this.getPortletDescription(context.getPortletHandle(), desiredLocales);
                if (description == null && registration.knows(pcContext)) {
                    try {
                        Portlet portlet = ServiceDescriptionHandler.this.producer.getPortletWith(pcContext, registration);
                        PortletInfo info = portlet.getInfo();
                        org.gatein.pc.api.PortletContext original = org.gatein.pc.api.PortletContext.createPortletContext((String)info.getApplicationName(), (String)info.getName());
                        return this.getPortletDescription(original.getId(), desiredLocales);
                    }
                    catch (Exception e) {
                        ServiceHandler.log.debug("Couldn't retrieve portlet " + pcContext, (Throwable)e);
                        return null;
                    }
                }
                return description;
            }
            return null;
        }

        private PortletDescription getPortletDescription(String portletHandle, List<String> desiredLocales) {
            PortletDescriptionInfo descriptionInfo = this.portletDescriptions.get(portletHandle);
            if (descriptionInfo != null) {
                return descriptionInfo.getBestDescriptionFor(desiredLocales);
            }
            return null;
        }

        public void removePortletDescription(org.gatein.pc.api.PortletContext pc) {
            String handle = WSRPUtils.convertToWSRPPortletContext((org.gatein.pc.api.PortletContext)pc).getPortletHandle();
            PortletDescription description = this.getPortletDescription(handle, null);
            if (description != null) {
                for (QName event : description.getHandledEvents()) {
                    this.removeEvent(event);
                }
                for (QName event : description.getPublishedEvents()) {
                    this.removeEvent(event);
                }
                this.portletDescriptions.remove(handle);
            }
        }

        private class PortletDescriptionInfo {
            private Map<String, PortletDescription> languageToDescription;

            private PortletDescriptionInfo(List<String> supportedLanguages) {
                this.languageToDescription = new HashMap<String, PortletDescription>(supportedLanguages.size());
                for (String supportedLanguage : supportedLanguages) {
                    this.languageToDescription.put(supportedLanguage, null);
                }
            }

            public Set<String> getSupportedLanguages() {
                return this.languageToDescription.keySet();
            }

            public PortletDescription getBestDescriptionFor(List<String> desiredLanguages) {
                String language = null;
                Set<String> supportedLanguages = this.getSupportedLanguages();
                if (desiredLanguages != null) {
                    for (String languageTag : desiredLanguages) {
                        if (!supportedLanguages.contains(languageTag)) continue;
                        language = languageTag;
                    }
                    if (language == null) {
                        for (String desiredLanguage : desiredLanguages) {
                            for (String supportedLanguage : supportedLanguages) {
                                if (!supportedLanguage.startsWith(desiredLanguage)) continue;
                                language = supportedLanguage;
                            }
                        }
                    }
                }
                if (language == null) {
                    language = "en";
                }
                return this.languageToDescription.get(language);
            }

            public void addDescriptionFor(String language, PortletDescription desc) {
                this.languageToDescription.put(language, desc);
            }
        }
    }
}

