/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers.processors;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.fileupload.RequestContext;
import org.gatein.common.util.ParameterMap;
import org.gatein.wsrp.producer.handlers.processors.MarkupRequest;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.ResourceParams;
import org.oasis.wsrp.v2.UploadContext;

abstract class WSRPRequestContext
implements org.gatein.pc.api.spi.RequestContext,
RequestContext {
    protected String characterEncoding;

    protected WSRPRequestContext(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return -1;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException("Not currently supported");
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Not currently supported");
    }

    public abstract ParameterMap getForm();

    public static WSRPRequestContext createRequestContext(MarkupRequest markupRequest, InteractionParams interactionParams) {
        return WSRPRequestContext.createRequestContext(markupRequest, interactionParams.getFormParameters(), interactionParams.getUploadContexts());
    }

    public static WSRPRequestContext createRequestContext(MarkupRequest markupRequest, ResourceParams resourceParams) {
        return WSRPRequestContext.createRequestContext(markupRequest, resourceParams.getFormParameters(), resourceParams.getUploadContexts());
    }

    public static WSRPRequestContext createRequestContext(MarkupRequest markupRequest, List<NamedString> formParams, List<UploadContext> uploadContexts) {
        if (uploadContexts != null && !uploadContexts.isEmpty()) {
            try {
                return new WSRPMultiRequestContext(markupRequest.getCharacterSet(), formParams, uploadContexts);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid upload contexts", e);
            }
        }
        return new WSRPSimpleRequestContext(markupRequest.getCharacterSet(), markupRequest.getMediaType(), formParams);
    }

    static class WSRPMultiRequestContext
    extends WSRPRequestContext {
        private byte[] content;
        private boolean usingStream;
        private boolean usingReader;
        private String contentType;
        private ParameterMap formParameters;
        private InputStream inputStream;
        private BufferedReader bufferedReader;

        protected WSRPMultiRequestContext(String characterEncoding, List<NamedString> formParams, List<UploadContext> uploadContexts) throws IOException, MessagingException {
            super(characterEncoding);
            MimeMultipart parts = new MimeMultipart();
            if (uploadContexts != null && !uploadContexts.isEmpty()) {
                for (UploadContext uploadContext : uploadContexts) {
                    InternetHeaders headers = new InternetHeaders();
                    headers.addHeader("Content-type", uploadContext.getMimeType());
                    List attributes = uploadContext.getMimeAttributes();
                    if (attributes != null && !attributes.isEmpty()) {
                        for (NamedString attribute : attributes) {
                            headers.addHeader(attribute.getName(), attribute.getValue());
                        }
                    }
                    MimeBodyPart mimeBodyPart = new MimeBodyPart(headers, uploadContext.getUploadData());
                    parts.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            String paramContentDispositionHeader = "form-data; name=\"";
            if (formParams != null && !formParams.isEmpty()) {
                HashMap<String, String[]> params = new HashMap<String, String[]>(formParams.size());
                for (NamedString formParam : formParams) {
                    InternetHeaders headers = new InternetHeaders();
                    StringBuffer paramContentDisposition = new StringBuffer("form-data; name=\"");
                    paramContentDisposition.append(formParam.getName()).append("\"");
                    headers.addHeader("Content-disposition", paramContentDisposition.toString());
                    MimeBodyPart mimeBodyPart = new MimeBodyPart(headers, formParam.getValue().getBytes());
                    parts.addBodyPart((BodyPart)mimeBodyPart);
                    String paramName = formParam.getName();
                    String paramValue = formParam.getValue();
                    if (params.containsKey(paramName)) {
                        String[] oldValues = (String[])params.get(paramName);
                        int valuesLength = oldValues.length;
                        String[] newValues = new String[valuesLength + 1];
                        System.arraycopy(oldValues, 0, newValues, 0, valuesLength);
                        newValues[valuesLength] = paramValue;
                        params.put(paramName, newValues);
                        continue;
                    }
                    params.put(paramName, new String[]{paramValue});
                }
                this.formParameters = new ParameterMap(params);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            parts.writeTo((OutputStream)baos);
            this.content = baos.toByteArray();
            this.contentType = parts.getContentType();
        }

        @Override
        public ParameterMap getForm() {
            if (this.formParameters == null) {
                this.formParameters = new ParameterMap();
            }
            return this.formParameters;
        }

        public String getContentType() {
            return this.contentType;
        }

        @Override
        public int getContentLength() {
            return this.content.length;
        }

        @Override
        public BufferedReader getReader() throws IOException {
            if (this.usingStream) {
                throw new IllegalStateException("getInputStream has already been called on this ActionContext!");
            }
            this.usingReader = true;
            if (this.bufferedReader == null) {
                this.bufferedReader = new BufferedReader(new InputStreamReader(this.getInputStreamFromContent()));
            }
            return this.bufferedReader;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.usingReader) {
                throw new IllegalStateException("getReader has already been called on this ActionContext!");
            }
            this.usingStream = true;
            return this.getInputStreamFromContent();
        }

        private InputStream getInputStreamFromContent() {
            if (this.inputStream == null) {
                this.inputStream = new ByteArrayInputStream(this.content);
            }
            return this.inputStream;
        }
    }

    static class WSRPSimpleRequestContext
    extends WSRPRequestContext {
        private ParameterMap formParameters;
        private String contentType;

        protected WSRPSimpleRequestContext(String characterEncoding, String contentType, List<NamedString> formParams) {
            super(characterEncoding);
            this.contentType = contentType;
            if (formParams != null && !formParams.isEmpty()) {
                HashMap<String, String[]> params = new HashMap<String, String[]>(formParams.size());
                for (NamedString formParam : formParams) {
                    String paramName = formParam.getName();
                    String paramValue = formParam.getValue();
                    if (params.containsKey(paramName)) {
                        String[] oldValues = (String[])params.get(paramName);
                        int valuesLength = oldValues.length;
                        String[] newValues = new String[valuesLength + 1];
                        System.arraycopy(oldValues, 0, newValues, 0, valuesLength);
                        newValues[valuesLength] = paramValue;
                        params.put(paramName, newValues);
                        continue;
                    }
                    params.put(paramName, new String[]{paramValue});
                }
                this.formParameters = new ParameterMap(params);
            } else {
                this.formParameters = new ParameterMap();
            }
        }

        @Override
        public ParameterMap getForm() {
            return this.formParameters;
        }

        public String getContentType() {
            return this.contentType;
        }

        @Override
        public int getContentLength() {
            return 0;
        }
    }
}

