/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.blueprint;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.bus.blueprint.BlueprintBeanLocator;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class ConfigurerImpl
implements Configurer {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurerImpl.class);
    BlueprintContainer container;
    private final Map<String, List<MatcherHolder>> wildCardBeanDefinitions = new HashMap<String, List<MatcherHolder>>();

    public ConfigurerImpl(BlueprintContainer con) {
        this.container = con;
        this.initializeWildcardMap();
    }

    private boolean isWildcardBeanName(String bn) {
        return bn.indexOf(42) != -1 || bn.indexOf(63) != -1 || bn.indexOf(40) != -1 && bn.indexOf(41) != -1;
    }

    private void initializeWildcardMap() {
        for (String s : this.container.getComponentIds()) {
            ComponentMetadata cmd;
            Class<?> cls;
            if (!this.isWildcardBeanName(s) || (cls = BlueprintBeanLocator.getClassForMetaData(this.container, cmd = this.container.getComponentMetadata(s))) == null) continue;
            String orig = s;
            if (s.charAt(0) == '*') {
                s = "." + s.replaceAll("\\.", "\\.");
            }
            Matcher matcher = Pattern.compile(s).matcher("");
            List<MatcherHolder> m = this.wildCardBeanDefinitions.get(cls.getName());
            if (m == null) {
                m = new ArrayList<MatcherHolder>();
                this.wildCardBeanDefinitions.put(cls.getName(), m);
            }
            MatcherHolder holder = new MatcherHolder(orig, matcher);
            m.add(holder);
        }
    }

    public void configureBean(Object beanInstance) {
        this.configureBean(null, beanInstance, true);
    }

    public void configureBean(String bn, Object beanInstance) {
        this.configureBean(bn, beanInstance, true);
    }

    public synchronized void configureBean(String bn, Object beanInstance, boolean checkWildcards) {
        block12: {
            if (null == bn) {
                bn = this.getBeanName(beanInstance);
            }
            if (null == bn) {
                return;
            }
            if (checkWildcards) {
                this.configureWithWildCard(bn, beanInstance);
            }
            Method m = ReflectionUtil.findMethod(this.container.getClass(), (String)"injectBeanInstance", (Class[])new Class[]{BeanMetadata.class, Object.class});
            try {
                if (m != null) {
                    ComponentMetadata cm = null;
                    try {
                        cm = this.container.getComponentMetadata(bn);
                    }
                    catch (NoSuchComponentException nsce) {
                        cm = null;
                    }
                    if (cm instanceof BeanMetadata) {
                        ReflectionUtil.setAccessible((AccessibleObject)m);
                        m.invoke((Object)this.container, (BeanMetadata)cm, beanInstance);
                    }
                    break block12;
                }
                m = ReflectionUtil.findMethod(this.container.getClass(), (String)"getRepository", (Class[])new Class[0]);
                Object o = ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)this.container, new Object[0]);
                m = ReflectionUtil.findMethod(this.container.getClass(), (String)"getRecipe", (Class[])new Class[]{String.class});
                o = ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke(o, bn);
                m = ReflectionUtil.findMethod(o.getClass(), (String)"setProperties", (Class[])new Class[]{Object.class});
                if (m != null) {
                    ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke(o, beanInstance);
                }
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Could not configure object " + bn, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureWithWildCard(String bn, Object beanInstance) {
        if (!this.wildCardBeanDefinitions.isEmpty()) {
            Class<?> clazz = beanInstance.getClass();
            while (!Object.class.equals(clazz)) {
                String className = clazz.getName();
                List<MatcherHolder> matchers = this.wildCardBeanDefinitions.get(className);
                if (matchers != null) {
                    for (MatcherHolder m : matchers) {
                        Matcher matcher = m.matcher;
                        synchronized (matcher) {
                            m.matcher.reset(bn);
                            if (m.matcher.matches()) {
                                this.configureBean(m.wildCardId, beanInstance, false);
                                return;
                            }
                        }
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    protected String getBeanName(Object beanInstance) {
        if (beanInstance instanceof Configurable) {
            return ((Configurable)beanInstance).getBeanName();
        }
        String beanName = null;
        Method m = null;
        try {
            m = beanInstance.getClass().getDeclaredMethod("getBeanName", null);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = beanInstance.getClass().getMethod("getBeanName", null);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (m != null) {
            try {
                beanName = (String)m.invoke(beanInstance, new Object[0]);
            }
            catch (Exception ex) {
                LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"ERROR_DETERMINING_BEAN_NAME_EXC", (Throwable)ex);
            }
        }
        if (null == beanName) {
            LogUtils.log((Logger)LOG, (Level)Level.FINE, (String)"COULD_NOT_DETERMINE_BEAN_NAME_MSG", (Object)beanInstance.getClass().getName());
        }
        return beanName;
    }

    static class MatcherHolder {
        Matcher matcher;
        String wildCardId;

        public MatcherHolder(String orig, Matcher matcher) {
            this.wildCardId = orig;
            this.matcher = matcher;
        }
    }
}

