/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.HashMap;
import java.util.Map;
import nu.xom.Element;
import nu.xom.NamespaceConflictException;
import nu.xom.Verifier;
import org.jaxen.NamespaceContext;

public final class XPathContext {
    private Map namespaces = new HashMap();

    public XPathContext(String string, String string2) {
        this();
        this.addNamespace(string, string2);
    }

    public XPathContext() {
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public void addNamespace(String string, String string2) {
        if ("xml".equals(string) && !"http://www.w3.org/XML/1998/namespace".equals(string2)) {
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + string2);
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        if (string == null) {
            throw new NullPointerException("Prefixes used in XPath expressions cannot be null");
        }
        if ("".equals(string)) {
            throw new NamespaceConflictException("XPath expressions do not use the default namespace");
        }
        Verifier.checkNCName(string);
        if (string2 == null) {
            this.namespaces.remove(string);
        } else {
            this.namespaces.put(string, string2);
        }
    }

    public static XPathContext makeNamespaceContext(Element element) {
        XPathContext xPathContext = new XPathContext();
        xPathContext.namespaces = element.getNamespacePrefixesInScope();
        return xPathContext;
    }

    NamespaceContext getJaxenContext() {
        return new JaxenNamespaceContext();
    }

    public String lookup(String string) {
        return (String)this.namespaces.get(string);
    }

    private class JaxenNamespaceContext
    implements NamespaceContext {
        private JaxenNamespaceContext() {
        }

        public String translateNamespacePrefixToUri(String string) {
            return XPathContext.this.lookup(string);
        }
    }
}

