/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public abstract class AbstractAddStepHandler
implements OperationStepHandler {
    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = this.createResource(context);
        this.populateModel(context, operation, resource);
        final ModelNode model = resource.getModel();
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ArrayList controllers = new ArrayList();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    AbstractAddStepHandler.this.performRuntime(context, operation, model, verificationHandler, controllers);
                    if (AbstractAddStepHandler.this.requiresRuntimeVerification()) {
                        context.addStep(verificationHandler, OperationContext.Stage.VERIFY);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractAddStepHandler.this.rollbackRuntime(context, operation, model, controllers);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected Resource createResource(OperationContext context) {
        return context.createResource(PathAddress.EMPTY_ADDRESS);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource);
    }

    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource.getModel());
    }

    protected abstract void populateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

    protected boolean requiresRuntime(OperationContext context) {
        return context.isNormalServer();
    }

    protected boolean requiresRuntimeVerification() {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        for (ServiceController<?> controller : controllers) {
            context.removeService(controller.getName());
        }
    }
}

