/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Iterator;
import java.util.Locale;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ValidateAddressOperationHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "validate-address";
    public static final ValidateAddressOperationHandler INSTANCE = new ValidateAddressOperationHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource;
        ModelNode address = operation.require("value");
        PathAddress pathAddr = PathAddress.pathAddress(address);
        Resource model = resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Iterator iterator = pathAddr.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            PathElement next = (PathElement)iterator.next();
            ++index;
            if (model.hasChild(next)) {
                model = model.getChild(next);
                continue;
            }
            PathAddress subAddress = pathAddr.subAddress(0, index);
            ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(subAddress);
            if (registration != null) {
                boolean remote = registration.isRemote();
                if (remote && !iterator.hasNext()) break;
                PathAddress newAddress = pathAddr.subAddress(index);
                ModelNode newOperation = operation.clone();
                newOperation.get("address").set(subAddress.toModelNode());
                newOperation.get("value").set(newAddress.toModelNode());
                OperationStepHandler proxyHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, OPERATION_NAME);
                if (proxyHandler != null) {
                    context.addStep(newOperation, proxyHandler, OperationContext.Stage.IMMEDIATE);
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                    return;
                }
            }
            context.getResult().get("valid").set(false);
            context.getResult().get("problem").set(ControllerMessages.MESSAGES.childResourceNotFound(next));
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        context.getResult().get("valid").set(true);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getValidateAddressOperation(locale);
    }
}

