/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp;

public class MIMEUtils {
    public static final String UTF_8 = "UTF-8";
    public static final String CHARSET = "charset=";
    public static final int CHARSET_LENGTH = "charset=".length();
    public static final String JAVASCRIPT = "javascript";
    public static final String TEXT = "text";
    public static final String ECMASCRIPT = "ecmascript";
    public static final String CSS = "css";
    public static final String HTML = "html";
    public static final String XML = "xml";
    public static final String APPLICATION_XML = "application/xml";

    public static boolean isInterpretableAsText(String contentType) {
        return contentType != null && (contentType.startsWith(TEXT) || MIMEUtils.isJavascript(contentType) || MIMEUtils.isApplicationXML(contentType));
    }

    public static boolean needsRewriting(String contentType) {
        return contentType != null && (contentType.startsWith(TEXT) && (contentType.contains(CSS) || contentType.contains(HTML) || contentType.contains(XML)) || MIMEUtils.isJavascript(contentType) || MIMEUtils.isApplicationXML(contentType));
    }

    private static boolean isApplicationXML(String contentType) {
        return contentType.startsWith(APPLICATION_XML);
    }

    private static boolean isJavascript(String contentType) {
        return contentType.contains(JAVASCRIPT) || contentType.contains(ECMASCRIPT);
    }

    public static String getCharsetFrom(String contentType) {
        String charset = UTF_8;
        if (contentType != null) {
            for (String part : contentType.split(";")) {
                if (!part.startsWith(CHARSET)) continue;
                charset = part.substring(CHARSET_LENGTH);
            }
        }
        return charset;
    }
}

