/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.api.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.api.extensions.UnmarshalledExtension;
import org.gatein.wsrp.payload.PayloadUtils;
import org.oasis.wsrp.v2.Extension;

public class AbstractExtensionAccessor {
    private final ThreadLocal<Map<Class, List<Extension>>> extensions = new ThreadLocal();
    private final ThreadLocal<Map<Class, List<UnmarshalledExtension>>> unmarshalledExtensions = new ThreadLocal();

    public List<Extension> getExtensions(Class targetClass) {
        return this.get(this.extensions, targetClass);
    }

    public List<UnmarshalledExtension> getUnmarshalledExtensions(Class targetClass) {
        return this.get(this.unmarshalledExtensions, targetClass);
    }

    private <T> List<T> get(ThreadLocal<Map<Class, List<T>>> mapThreadLocal, Class targetClass) {
        Map<Class, List<T>> extensionsMap;
        List extensions = null;
        if (targetClass != null && (extensionsMap = mapThreadLocal.get()) != null) {
            extensions = extensionsMap.get(targetClass);
        }
        return extensions != null ? extensions : Collections.emptyList();
    }

    public void addExtension(Class targetClass, Object extension) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)extension, (String)"Extension");
        this.add(this.extensions, targetClass, WSRPTypeFactory.createExtension(PayloadUtils.marshallExtension(extension)));
    }

    public void addUnmarshalledExtension(Class targetClass, UnmarshalledExtension extension) {
        this.add(this.unmarshalledExtensions, targetClass, extension);
    }

    private <T> void add(ThreadLocal<Map<Class, List<T>>> mapThreadLocal, Class targetClass, T toAdd) {
        Map<Class, List<T>> extensionsMap = mapThreadLocal.get();
        if (extensionsMap == null) {
            extensionsMap = new ConcurrentHashMap<Class, List<T>>(7);
            mapThreadLocal.set(extensionsMap);
        }
        List<T> extensions = extensionsMap.get(targetClass);
        if (toAdd != null) {
            if (extensions == null) {
                extensions = new ArrayList<T>(3);
                extensionsMap.put(targetClass, extensions);
            }
            extensions.add(toAdd);
        }
    }

    public void clear() {
        this.extensions.set(null);
        this.unmarshalledExtensions.set(null);
    }
}

