/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionResourceDefinition;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.controller.operations.common.InterfaceCriteriaWriteHandler;
import org.jboss.as.controller.operations.common.InterfaceRemoveHandler;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyValueWriteAttributeHandler;
import org.jboss.as.controller.operations.common.ValidateAddressOperationHandler;
import org.jboss.as.controller.operations.common.XmlMarshallingHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.transform.SubsystemDescriptionDump;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.DomainTransformers;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.descriptions.DomainAttributes;
import org.jboss.as.domain.controller.descriptions.DomainDescriptionProviders;
import org.jboss.as.domain.controller.descriptions.DomainRootDescription;
import org.jboss.as.domain.controller.operations.ApplyExtensionsHandler;
import org.jboss.as.domain.controller.operations.ApplyRemoteMasterDomainModelHandler;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.operations.DomainSocketBindingGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.LocalHostNameOperationHandler;
import org.jboss.as.domain.controller.operations.ProcessTypeHandler;
import org.jboss.as.domain.controller.operations.ProfileAddHandler;
import org.jboss.as.domain.controller.operations.ProfileDescribeHandler;
import org.jboss.as.domain.controller.operations.ProfileRemoveHandler;
import org.jboss.as.domain.controller.operations.ResolveExpressionOnDomainHandler;
import org.jboss.as.domain.controller.operations.ServerGroupAddHandler;
import org.jboss.as.domain.controller.operations.ServerGroupProfileWriteAttributeHandler;
import org.jboss.as.domain.controller.operations.ServerGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.SocketBindingGroupAddHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadURLHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentDeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentRedeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentReplaceHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentUndeployHandler;
import org.jboss.as.domain.controller.resource.SocketBindingResourceDefinition;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.model.jvm.JvmResourceDefinition;
import org.jboss.as.management.client.content.ManagedDMRContentResourceDefinition;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResourceDefinition;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.operations.LaunchTypeHandler;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DomainModelUtil {
    private static final List<String> ALLOWED_SERVER_GROUP_CHILDREN = Arrays.asList("rolling-to-servers", "max-failure-percentage", "max-failed-servers");

    public static void updateCoreModel(Resource rootResource, HostControllerEnvironment environment) {
        ModelNode rootModel = rootResource.getModel();
        rootModel.get("release-version").set(Version.AS_VERSION);
        rootModel.get("release-codename").set(Version.AS_RELEASE_CODENAME);
        rootModel.get("management-major-version").set(1);
        rootModel.get("management-minor-version").set(3);
        rootModel.get("management-micro-version").set(0);
        ModelNode nameNode = rootModel.get("product-name");
        ModelNode versionNode = rootModel.get("product-version");
        if (environment != null) {
            String productName = environment.getProductConfig().getProductName();
            String productVersion = environment.getProductConfig().getProductVersion();
            if (productName != null) {
                nameNode.set(productName);
            }
            if (productVersion != null) {
                versionNode.set(productVersion);
            }
        }
    }

    public static void initializeMasterDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, DomainController domainController, ExtensionRegistry extensionRegistry, PathManagerService pathManager) {
        DomainModelUtil.initializeDomainRegistry(root, configurationPersister, contentRepository, fileRepository, true, domainController.getLocalHostInfo(), extensionRegistry, null, pathManager);
    }

    public static void initializeSlaveDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, HostFileRepository fileRepository, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        DomainModelUtil.initializeDomainRegistry(root, configurationPersister, contentRepository, fileRepository, false, hostControllerInfo, extensionRegistry, ignoredDomainResourceRegistry, pathManager);
    }

    private static void initializeDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepo, HostFileRepository fileRepository, boolean isMaster, LocalHostControllerInfo hostControllerInfo, ExtensionRegistry extensionRegistry, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, PathManagerService pathManager) {
        EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY);
        EnumSet<OperationEntry.Flag> masterOnly = EnumSet.of(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY);
        XmlMarshallingHandler xmh = new XmlMarshallingHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("read-config-as-xml", (OperationStepHandler)xmh, (DescriptionProvider)xmh, false, OperationEntry.EntryType.PUBLIC, readOnly);
        root.registerOperationHandler("add-namespace", (OperationStepHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-namespace", (OperationStepHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-schema-location", (OperationStepHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-schema-location", (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        DeploymentUploadBytesHandler dubh = isMaster ? new DeploymentUploadBytesHandler(contentRepo) : new DeploymentUploadBytesHandler();
        root.registerOperationHandler("upload-deployment-bytes", (OperationStepHandler)dubh, (DescriptionProvider)dubh, false, OperationEntry.EntryType.PUBLIC, masterOnly);
        DeploymentUploadURLHandler duuh = isMaster ? new DeploymentUploadURLHandler(contentRepo) : new DeploymentUploadURLHandler();
        root.registerOperationHandler("upload-deployment-url", (OperationStepHandler)duuh, (DescriptionProvider)duuh, false, OperationEntry.EntryType.PUBLIC, masterOnly);
        DeploymentUploadStreamAttachmentHandler dush = isMaster ? new DeploymentUploadStreamAttachmentHandler(contentRepo) : new DeploymentUploadStreamAttachmentHandler();
        root.registerOperationHandler("upload-deployment-stream", (OperationStepHandler)dush, (DescriptionProvider)dush, false, OperationEntry.EntryType.PUBLIC, masterOnly);
        DeploymentFullReplaceHandler dfrh = isMaster ? new DeploymentFullReplaceHandler(contentRepo) : new DeploymentFullReplaceHandler(fileRepository);
        root.registerOperationHandler("full-replace-deployment", (OperationStepHandler)dfrh, (DescriptionProvider)dfrh);
        if (isMaster) {
            SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)configurationPersister);
            root.registerOperationHandler("delete-snapshot", (OperationStepHandler)snapshotDelete, (DescriptionProvider)snapshotDelete, false, OperationEntry.EntryType.PUBLIC, masterOnly);
            SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)configurationPersister);
            root.registerOperationHandler("list-snapshots", (OperationStepHandler)snapshotList, (DescriptionProvider)snapshotList, false, OperationEntry.EntryType.PUBLIC, masterOnly);
            SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)configurationPersister);
            root.registerOperationHandler("take-snapshot", (OperationStepHandler)snapshotTake, (DescriptionProvider)snapshotTake, false, OperationEntry.EntryType.PUBLIC, masterOnly);
        }
        root.registerReadOnlyAttribute("process-type", (OperationStepHandler)(isMaster ? ProcessTypeHandler.MASTER : ProcessTypeHandler.SLAVE), AttributeAccess.Storage.RUNTIME);
        root.registerReadOnlyAttribute("launch-type", (OperationStepHandler)new LaunchTypeHandler(ServerEnvironment.LaunchType.DOMAIN), AttributeAccess.Storage.RUNTIME);
        root.registerReadOnlyAttribute("local-host-name", (OperationStepHandler)new LocalHostNameOperationHandler(hostControllerInfo), AttributeAccess.Storage.RUNTIME);
        root.registerReadWriteAttribute((AttributeDefinition)DomainAttributes.NAME, null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true, true));
        root.registerOperationHandler("validate-address", (OperationStepHandler)ValidateAddressOperationHandler.INSTANCE, (DescriptionProvider)ValidateAddressOperationHandler.INSTANCE, false, EnumSet.of(OperationEntry.Flag.READ_ONLY));
        root.registerOperationHandler("resolve-expression-on-domain", (OperationStepHandler)ResolveExpressionOnDomainHandler.INSTANCE, (DescriptionProvider)ResolveExpressionOnDomainHandler.INSTANCE, EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS));
        DomainServerLifecycleHandlers.registerDomainHandlers(root);
        ManagementResourceRegistration systemProperties = root.registerSubModel(PathElement.pathElement((String)"system-property"), DomainDescriptionProviders.SYSTEM_PROPERTY_PROVIDER);
        systemProperties.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        systemProperties.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        systemProperties.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        systemProperties.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration interfaces = root.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.NAMED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationStepHandler)InterfaceAddHandler.NAMED_INSTANCE, (DescriptionProvider)InterfaceAddHandler.NAMED_INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationStepHandler)InterfaceRemoveHandler.INSTANCE, (DescriptionProvider)InterfaceRemoveHandler.INSTANCE, false);
        InterfaceCriteriaWriteHandler.CONFIG_ONLY.register(interfaces);
        ManagementResourceRegistration profile = root.registerSubModel(PathElement.pathElement((String)"profile"), DomainDescriptionProviders.PROFILE);
        profile.registerOperationHandler("add", (OperationStepHandler)ProfileAddHandler.INSTANCE, (DescriptionProvider)ProfileAddHandler.INSTANCE, false);
        profile.registerOperationHandler("remove", (OperationStepHandler)ProfileRemoveHandler.INSTANCE, (DescriptionProvider)ProfileRemoveHandler.INSTANCE, false);
        profile.registerOperationHandler("describe", (OperationStepHandler)ProfileDescribeHandler.INSTANCE, (DescriptionProvider)ProfileDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE, readOnly);
        root.registerSubModel((ResourceDefinition)PathResourceDefinition.createNamed((PathManagerService)pathManager));
        ManagementResourceRegistration socketBindingGroup = root.registerSubModel((ResourceDefinition)new SocketBindingGroupResourceDefinition((OperationStepHandler)SocketBindingGroupAddHandler.INSTANCE, (OperationStepHandler)DomainSocketBindingGroupRemoveHandler.INSTANCE, true));
        socketBindingGroup.registerSubModel((ResourceDefinition)SocketBindingResourceDefinition.INSTANCE);
        socketBindingGroup.registerSubModel((ResourceDefinition)RemoteDestinationOutboundSocketBindingResourceDefinition.INSTANCE);
        socketBindingGroup.registerSubModel((ResourceDefinition)LocalDestinationOutboundSocketBindingResourceDefinition.INSTANCE);
        ManagementResourceRegistration serverGroups = root.registerSubModel(PathElement.pathElement((String)"server-group"), DomainDescriptionProviders.SERVER_GROUP);
        serverGroups.registerOperationHandler("add", (OperationStepHandler)ServerGroupAddHandler.INSTANCE, (DescriptionProvider)ServerGroupAddHandler.INSTANCE, false);
        serverGroups.registerOperationHandler("remove", (OperationStepHandler)ServerGroupRemoveHandler.INSTANCE, (DescriptionProvider)ServerGroupRemoveHandler.INSTANCE, false);
        serverGroups.registerReadWriteAttribute("socket-binding-group", null, (OperationStepHandler)WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        serverGroups.registerReadWriteAttribute("socket-binding-port-offset", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, true), AttributeAccess.Storage.CONFIGURATION);
        serverGroups.registerReadWriteAttribute("profile", null, (OperationStepHandler)ServerGroupProfileWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        DomainServerLifecycleHandlers.registerServerGroupHandlers(serverGroups);
        ManagementResourceRegistration groupVMs = serverGroups.registerSubModel((ResourceDefinition)JvmResourceDefinition.GLOBAL);
        ServerGroupDeploymentReplaceHandler sgdrh = new ServerGroupDeploymentReplaceHandler(fileRepository);
        serverGroups.registerOperationHandler("replace-deployment", (OperationStepHandler)sgdrh, (DescriptionProvider)sgdrh);
        ManagementResourceRegistration serverGroupDeployments = serverGroups.registerSubModel(PathElement.pathElement((String)"deployment"), DomainDescriptionProviders.SERVER_GROUP_DEPLOYMENT);
        ServerGroupDeploymentAddHandler sgdah = new ServerGroupDeploymentAddHandler(fileRepository);
        serverGroupDeployments.registerOperationHandler("add", (OperationStepHandler)sgdah, (DescriptionProvider)sgdah);
        serverGroupDeployments.registerOperationHandler("deploy", (OperationStepHandler)ServerGroupDeploymentDeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentDeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("redeploy", (OperationStepHandler)ServerGroupDeploymentRedeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentRedeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("undeploy", (OperationStepHandler)ServerGroupDeploymentUndeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentUndeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("remove", (OperationStepHandler)ServerGroupDeploymentRemoveHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentRemoveHandler.INSTANCE);
        ManagementResourceRegistration serverGroupSystemProperties = serverGroups.registerSubModel(PathElement.pathElement((String)"system-property"), DomainDescriptionProviders.SERVER_GROUP_SYSTEM_PROPERTY_PROVIDER);
        serverGroupSystemProperties.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        serverGroupSystemProperties.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        serverGroupSystemProperties.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        serverGroupSystemProperties.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration deployments = root.registerSubModel(PathElement.pathElement((String)"deployment"), DomainDescriptionProviders.DEPLOYMENT_PROVIDER);
        DeploymentAddHandler dah = isMaster ? new DeploymentAddHandler(contentRepo) : new DeploymentAddHandler();
        deployments.registerOperationHandler("add", (OperationStepHandler)dah, (DescriptionProvider)dah);
        DeploymentRemoveHandler drh = isMaster ? DeploymentRemoveHandler.createForMaster(contentRepo) : DeploymentRemoveHandler.createForSlave((DeploymentFileRepository)fileRepository);
        deployments.registerOperationHandler("remove", (OperationStepHandler)drh, (DescriptionProvider)drh);
        ManagedDMRContentTypeResourceDefinition plansDef = new ManagedDMRContentTypeResourceDefinition(contentRepo, "rollout-plan", PathElement.pathElement((String)"management-client-content", (String)"rollout-plans"), DomainRootDescription.getResourceDescriptionResolver("rollout-plans"));
        ManagementResourceRegistration mgmtContent = root.registerSubModel((ResourceDefinition)plansDef);
        AbstractParameterValidator contentValidator = new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                DomainModelUtil.validateRolloutPlanStructure(value);
            }
        };
        ManagedDMRContentResourceDefinition planDef = ManagedDMRContentResourceDefinition.create((String)"rollout-plan", (ParameterValidator)contentValidator, (ResourceDescriptionResolver)DomainRootDescription.getResourceDescriptionResolver("rollout-plan"));
        mgmtContent.registerSubModel((ResourceDefinition)planDef);
        root.registerSubModel((ResourceDefinition)new ExtensionResourceDefinition(extensionRegistry, true, !isMaster));
        extensionRegistry.setSubsystemParentResourceRegistrations(profile, null);
        if (!isMaster) {
            ApplyExtensionsHandler aexh = new ApplyExtensionsHandler(extensionRegistry, hostControllerInfo, ignoredDomainResourceRegistry);
            root.registerOperationHandler("resolve-subsystems", (OperationStepHandler)aexh, (DescriptionProvider)aexh, false, OperationEntry.EntryType.PRIVATE);
            ApplyRemoteMasterDomainModelHandler armdmh = new ApplyRemoteMasterDomainModelHandler(fileRepository, contentRepo, hostControllerInfo, ignoredDomainResourceRegistry);
            root.registerOperationHandler("apply-remote-domain-model", (OperationStepHandler)armdmh, (DescriptionProvider)armdmh, false, OperationEntry.EntryType.PRIVATE);
        } else {
            SubsystemDescriptionDump dumper = new SubsystemDescriptionDump(extensionRegistry);
            root.registerOperationHandler("subsystem-description-dump", (OperationStepHandler)dumper, SubsystemDescriptionDump.DESCRIPTION, false, OperationEntry.EntryType.PRIVATE, EnumSet.of(OperationEntry.Flag.READ_ONLY));
        }
        DomainTransformers.initializeDomainRegistry(extensionRegistry.getTransformerRegistry());
    }

    public static void validateRolloutPlanStructure(ModelNode plan) throws OperationFailedException {
        Set keys;
        if (plan == null) {
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.nullVar("plan").getLocalizedMessage());
        }
        if (!plan.hasDefined("rollout-plan")) {
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.requiredChildIsMissing("rollout-plan", "rollout-plan", plan.toString()));
        }
        ModelNode rolloutPlan1 = plan.get("rollout-plan");
        try {
            keys = rolloutPlan1.keys();
        }
        catch (IllegalArgumentException e) {
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.requiredChildIsMissing("rollout-plan", "in-series", plan.toString()));
        }
        if (!keys.contains("in-series")) {
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.requiredChildIsMissing("rollout-plan", "in-series", plan.toString()));
        }
        if (keys.size() > 2 || keys.size() == 2 && !keys.contains("rollback-across-groups")) {
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.unrecognizedChildren("rollout-plan", "in-series, rollback-across-groups", plan.toString()));
        }
        ModelNode inSeries = rolloutPlan1.get("in-series");
        if (!inSeries.isDefined()) {
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.requiredChildIsMissing("rollout-plan", "in-series", plan.toString()));
        }
        List groups = inSeries.asList();
        if (groups.isEmpty()) {
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.inSeriesIsMissingGroups(plan.toString()));
        }
        for (ModelNode group : groups) {
            if (group.hasDefined("server-group")) {
                Set groupKeys;
                ModelNode serverGroup = group.get("server-group");
                try {
                    groupKeys = serverGroup.keys();
                }
                catch (IllegalArgumentException e) {
                    throw new OperationFailedException(DomainControllerMessages.MESSAGES.serverGroupExpectsSingleChild(plan.toString()));
                }
                if (groupKeys.size() != 1) {
                    throw new OperationFailedException(DomainControllerMessages.MESSAGES.serverGroupExpectsSingleChild(plan.toString()));
                }
                DomainModelUtil.validateInSeriesServerGroup(serverGroup.asProperty().getValue());
                continue;
            }
            if (group.hasDefined("concurrent-groups")) {
                ModelNode concurrent = group.get("concurrent-groups");
                for (ModelNode child : concurrent.asList()) {
                    DomainModelUtil.validateInSeriesServerGroup(child.asProperty().getValue());
                }
                continue;
            }
            throw new OperationFailedException(DomainControllerMessages.MESSAGES.unexpectedInSeriesGroup(plan.toString()));
        }
    }

    private static void validateInSeriesServerGroup(ModelNode serverGroup) throws OperationFailedException {
        if (serverGroup.isDefined()) {
            try {
                Set specKeys = serverGroup.keys();
                if (!ALLOWED_SERVER_GROUP_CHILDREN.containsAll(specKeys)) {
                    throw new OperationFailedException(DomainControllerMessages.MESSAGES.unrecognizedChildren("server-group", ALLOWED_SERVER_GROUP_CHILDREN.toString(), specKeys.toString()));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

