/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.SystemPathsProvider;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleReferenceClassLoader;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.osgi.framework.Bundle;

final class DefaultFrameworkModuleProvider
extends AbstractPluginService<FrameworkModuleProvider>
implements FrameworkModuleProvider {
    private static final ModuleIdentifier FRAMEWORK_MODULE_IDENTIFIER = ModuleIdentifier.create((String)"jbosgi.framework");
    private final InjectedValue<SystemPathsProvider> injectedSystemPaths = new InjectedValue();
    private Module frameworkModule;

    static void addIntegrationService(ServiceRegistry registry, ServiceTarget serviceTarget) {
        if (registry.getService(IntegrationServices.FRAMEWORK_MODULE_PROVIDER) == null) {
            DefaultFrameworkModuleProvider service = new DefaultFrameworkModuleProvider();
            ServiceBuilder builder = serviceTarget.addService(IntegrationServices.FRAMEWORK_MODULE_PROVIDER, (Service)service);
            builder.addDependency(IntegrationServices.SYSTEM_PATHS_PROVIDER, SystemPathsProvider.class, service.injectedSystemPaths);
            builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
            builder.install();
        }
    }

    private DefaultFrameworkModuleProvider() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.frameworkModule = null;
    }

    public FrameworkModuleProvider getValue() {
        return this;
    }

    @Override
    public Module getFrameworkModule(Bundle bundle2) {
        if (this.frameworkModule == null) {
            SystemBundleState systemBundle = (SystemBundleState)bundle2;
            this.frameworkModule = this.createFrameworkModule(systemBundle);
        }
        return this.frameworkModule;
    }

    private Module createFrameworkModule(SystemBundleState systemBundle) {
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)FRAMEWORK_MODULE_IDENTIFIER);
        SystemPathsProvider plugin = (SystemPathsProvider)this.injectedSystemPaths.getValue();
        Set<String> bootPaths = plugin.getBootDelegationPaths();
        PathFilter bootFilter = plugin.getBootDelegationFilter();
        PathFilter acceptAll = PathFilters.acceptAll();
        specBuilder.addDependency(DependencySpec.createSystemDependencySpec((PathFilter)bootFilter, (PathFilter)acceptAll, bootPaths));
        final ClassLoader classLoader = BundleManagerPlugin.class.getClassLoader();
        LocalLoader localLoader = new LocalLoader(){

            public Class<?> loadClassLocal(String name, boolean resolve) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            public Package loadPackageLocal(String name) {
                throw new UnsupportedOperationException();
            }

            public List<Resource> loadResourceLocal(String name) {
                return Collections.emptyList();
            }
        };
        Set<String> systemPaths = plugin.getSystemPaths();
        PathFilter systemFilter = plugin.getSystemFilter();
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)systemFilter, (PathFilter)PathFilters.acceptAll(), (LocalLoader)localLoader, systemPaths));
        specBuilder.setModuleClassLoaderFactory(new BundleReferenceClassLoader.Factory<SystemBundleState>(systemBundle));
        try {
            final ModuleSpec moduleSpec = specBuilder.create();
            ModuleLoader moduleLoader = new ModuleLoader(){

                protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                    return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                }

                public String toString() {
                    return ((Object)((Object)this)).getClass().getSimpleName();
                }
            };
            return moduleLoader.loadModule(specBuilder.getIdentifier());
        }
        catch (ModuleLoadException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotCreateFrameworkModule(ex);
        }
    }
}

