/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractFrameworkService;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;

public final class FrameworkInit
extends AbstractFrameworkService {
    private final InjectedValue<FrameworkState> injectedFramework = new InjectedValue();

    static void addService(ServiceTarget serviceTarget) {
        FrameworkInit service = new FrameworkInit();
        ServiceBuilder builder = serviceTarget.addService(Services.FRAMEWORK_INIT, (Service)service);
        builder.addDependency(Services.FRAMEWORK_CREATE, FrameworkState.class, service.injectedFramework);
        builder.addDependencies(new ServiceName[]{IntegrationServices.AUTOINSTALL_HANDLER, IntegrationServices.AUTOINSTALL_COMPLETE});
        builder.addDependencies(new ServiceName[]{IntegrationServices.PERSISTENT_BUNDLES_HANDLER, IntegrationServices.PERSISTENT_BUNDLES_COMPLETE});
        builder.addDependencies(new ServiceName[]{InternalServices.FRAMEWORK_CORE_SERVICES});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private FrameworkInit() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        FrameworkLogger.LOGGER.debugf("OSGi Framework initialized", new Object[0]);
    }

    public FrameworkState getValue() {
        return (FrameworkState)this.injectedFramework.getValue();
    }
}

