/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.url.URLStreamHandlerService;

@MessageBundle(projectCode="JBOSGI")
public interface FrameworkMessages {
    public static final FrameworkMessages MESSAGES = (FrameworkMessages)Messages.getBundle(FrameworkMessages.class);

    @Message(id=11200, value="%s is null")
    public IllegalArgumentException illegalArgumentNull(String var1);

    @Message(id=11201, value="Unknown bundle state: %d")
    public IllegalArgumentException illegalArgumentUnknownBundleState(int var1);

    @Message(id=11202, value="Required property '%s' missing in: %s")
    public IllegalArgumentException illegalArgumentRequiredPropertyMissing(String var1, File var2);

    @Message(id=11203, value="Invalid path: %s")
    public IllegalArgumentException illegalArgumentInvalidPath(@Cause Throwable var1, String var2);

    @Message(id=11204, value="Invalid object class in: %s")
    public IllegalArgumentException illegalArgumentInvalidObjectClass(String var1);

    @Message(id=11205, value="Invalid service reference: %s")
    public IllegalArgumentException illegalArgumentInvalidServiceRef(Object var1);

    @Message(id=11206, value="Cannot set the start level on system bundle")
    public IllegalArgumentException illegalArgumentStartLevelOnSystemBundles();

    @Message(id=11207, value="Cannot obtain paths from: %s")
    public IllegalArgumentException illegalArgumentCannotObtainPaths(@Cause Throwable var1, VirtualFile var2);

    @Message(id=11208, value="Cannot obtain service name for installed bundle: %s")
    public IllegalStateException illegalStateCannotObtainPaths(Deployment var1);

    @Message(id=11209, value="Invalid bundle context for: %s")
    public IllegalStateException illegalStateInvalidBundleContext(Bundle var1);

    @Message(id=11210, value="Bundle already uninstalled: %s")
    public IllegalStateException illegalStateBundleAlreadyUninstalled(Bundle var1);

    @Message(id=11211, value="Cannot read resouce bundle: %s")
    public IllegalStateException illegalStateCannotReadResourceBundle(@Cause Throwable var1, URL var2);

    @Message(id=11212, value="Framework not ACTIVE")
    public IllegalStateException illegalStateFrameworkNotActive();

    @Message(id=11213, value="Cannot add property to ACTIVE framework")
    public IllegalStateException illegalStateCannotAddProperty();

    @Message(id=11214, value="Cannot create storage area")
    public IllegalStateException illegalStateCannotCreateStorageArea(@Cause Throwable var1);

    @Message(id=11215, value="Cannot create framework module")
    public IllegalStateException illegalStateCannotCreateFrameworkModule(@Cause Throwable var1);

    @Message(id=11216, value="Module already exists: %s")
    public IllegalStateException illegalStateModuleAlreadyExists(ModuleIdentifier var1);

    @Message(id=11217, value="Cannot load module: %s")
    public IllegalStateException illegalStateCannotLoadModule(@Cause Throwable var1, ModuleIdentifier var2);

    @Message(id=11218, value="System paths provider not initialized")
    public IllegalStateException illegalStateSystemPathsNotInitialized();

    @Message(id=11219, value="Cannot obtain attached host for: %s")
    public IllegalStateException illegalStateCannotObtainAttachedHost(BundleRevision var1);

    @Message(id=11220, value="Framework builder already closed")
    public IllegalStateException illegalStateFrameworkBuilderClosed();

    @Message(id=11221, value="Framework already stopped")
    public IllegalStateException illegalStateFrameworkAlreadyStopped();

    @Message(id=11222, value="Framework not initialized")
    public IllegalStateException illegalStateFrameworkNotInitialized();

    @Message(id=11223, value="Cannot find native library: %s")
    public IllegalStateException illegalStateCannotFindNativeLibrary(String var1);

    @Message(id=11224, value="Service unregistered: %s")
    public IllegalStateException illegalStateServiceUnregistered(ServiceState var1);

    @Message(id=11225, value="Cannot create system bundle storage")
    public IllegalStateException illegalStateCannotCreateSystemBundleStorage(@Cause Throwable var1);

    @Message(id=11226, value="No stream handlers for protocol: %s")
    public IllegalStateException illegalStateNoStreamHandlersForProtocol(String var1);

    @Message(id=11227, value="Attempt to refresh an unresolved bundle: %s")
    public IllegalStateException illegalStateRefreshUnresolvedBundle(Bundle var1);

    @Message(id=11228, value="Cannot obtain URL for: %s")
    public IllegalStateException illegalStateCannotObtainURL(VirtualFile var1);

    @Message(id=11229, value="Cannot obtain virtual file from input stream")
    public BundleException bundleCannotObtainVirtualFile(@Cause Throwable var1);

    @Message(id=11230, value="Cannot obtain virtual file for: %s")
    public BundleException bundleCannotObtainVirtualFileForLocation(@Cause Throwable var1, String var2);

    @Message(id=11231, value="Cannot install bundle for: %s")
    public BundleException bundleCannotInstallBundleForLocation(@Cause Throwable var1, String var2);

    @Message(id=11232, value="Unsupported bundle manifest version %d in: %s")
    public BundleException bundleUnsupportedBundleManifestVersion(int var1, Bundle var2);

    @Message(id=11233, value="Missing Bundle-SymbolicName in: %s")
    public BundleException bundleMissingBundleSymbolicName(Bundle var1);

    @Message(id=11234, value="Duplicate import of package '%s' in: %s")
    public BundleException bundleDuplicatePackageImport(String var1, Bundle var2);

    @Message(id=11235, value="Not allowed to import java.* in: %s")
    public BundleException bundleNotAllowdToImportJavaPackage(Bundle var1);

    @Message(id=11236, value="Not allowed to export java.* in: %s")
    public BundleException bundleNotAllowdToExportJavaPackage(Bundle var1);

    @Message(id=11237, value="Version and specification version for package '%s' missmatch in: %s")
    public BundleException bundlePackageVersionAndSpecificationVersionMissmatch(String var1, Bundle var2);

    @Message(id=11238, value="Package '%s' cannot specify explicit bundle-symbolicname in: %s")
    public BundleException bundlePackageCannotSpecifyBundleSymbolicName(String var1, Bundle var2);

    @Message(id=11239, value="Package '%s' cannot specify explicit bundle-version in: %s")
    public BundleException bundlePackageCannotSpecifyBundleVersion(String var1, Bundle var2);

    @Message(id=11240, value="Bundle name and version already installed: %s")
    public BundleException bundleNameAndVersionAlreadyInstalled(Bundle var1);

    @Message(id=11241, value="Invalid Fragment-Host for extension fragment: %s")
    public BundleException bundleInvalidFragmentHostForExtensionFragment(Bundle var1);

    @Message(id=11242, value="Invalid number format: %s")
    public BundleException bundleInvalidNumberFormat(@Cause Throwable var1, String var2);

    @Message(id=11243, value="Not a valid deployment: %s")
    public BundleException bundleInvalidDeployment(Deployment var1);

    @Message(id=11244, value="Fragments cannot be started")
    public BundleException bundleCannotStartFragment();

    @Message(id=11245, value="Fragments cannot be stopped")
    public BundleException bundleCannotStopFragment();

    @Message(id=11246, value="Cannot initialize Framework")
    public BundleException bundleCannotInitializeFramework(@Cause Throwable var1);

    @Message(id=11247, value="Cannot start Framework")
    public BundleException bundleCannotStartFramework(@Cause Throwable var1);

    @Message(id=11248, value="System bundle cannot be uninstalled")
    public BundleException bundleCannotUninstallSystemBundle();

    @Message(id=11249, value="Bundle cannot be started due to current start level")
    public BundleException bundleCannotStartBundleDueToStartLevel();

    @Message(id=11250, value="Cannot resolve bundle: %s")
    public BundleException bundleCannotResolveBundle(@Cause Throwable var1, Bundle var2);

    @Message(id=11251, value="Unsupported execution environment %s we have: %s")
    public BundleException bundleUnsupportedExecutionEnvironment(List<String> var1, List<String> var2);

    @Message(id=11252, value="Cannot transition to STARTING: %s")
    public BundleException bundleCannotTransitionToStarting(@Cause Throwable var1, Bundle var2);

    @Message(id=11253, value="Invalid bundle activator: %s")
    public BundleException bundleInvalidBundleActivator(String var1);

    @Message(id=11254, value="Cannot start bundle: %s")
    public BundleException bundleCannotStartBundle(@Cause Throwable var1, Bundle var2);

    @Message(id=11255, value="Bundle was uninstalled during activator start: %s")
    public BundleException bundleBundleUninstalledDuringActivatorStart(Bundle var1);

    @Message(id=11256, value="Bundle was uninstalled during activator stop: %s")
    public BundleException bundleBundleUninstalledDuringActivatorStop(Bundle var1);

    @Message(id=11257, value="Error during activator stop: %s")
    public BundleException bundleErrorDuringActivatorStop(@Cause Throwable var1, Bundle var2);

    @Message(id=11258, value="Cannot acquire start/stop lock for: %s")
    public BundleException bundleCannotAcquireStartStopLock(Bundle var1);

    @Message(id=11259, value="Cannot find Bundle-NativeCode header for: %s")
    public BundleException bundleCannotFindNativeCodeHeader(BundleRevision var1);

    @Message(id=11260, value="No native code clause selected for: %s")
    public BundleException bundleNoNativeCodeClauseSelected(List<ParameterizedAttribute> var1);

    @Message(id=11261, value="Invalid filter expression: %s")
    public BundleException bundleInvalidFilterExpression(@Cause Throwable var1, String var2);

    @Message(id=11262, value="Cannot install persisted bundles")
    public BundleException bundleCannotInstallPersistedBundles(@Cause Throwable var1);

    @Message(id=11263, value="Cannot setup storage for: %s")
    public BundleException bundleCannotSetupStorage(@Cause Throwable var1, VirtualFile var2);

    @Message(id=11264, value="Cannot obtain revision content for: %s")
    public IOException ioCannotObtainRevisionContent(URL var1);

    @Message(id=11265, value="Cannot obtain content for: %s")
    public IOException ioCannotObtainContent(URL var1);

    @Message(id=11266, value="Cannot open connection on: %s")
    public IOException ioCannotOpenConnectionOnHandler(@Cause Throwable var1, URLStreamHandlerService var2);

    @Message(id=11267, value="Cannot load class from fragment: %s")
    public ClassNotFoundException cannotLoadClassFromFragment(BundleRevision var1);

    @Message(id=11268, value="Class '%s' not found in bundle revision: %s")
    public ClassNotFoundException classNotFoundInRevision(String var1, BundleRevision var2);

    @Message(id=11269, value="Cannot load class '%s' from bundle revision: %s")
    public ClassNotFoundException cannotLoadClassFromBundleRevision(@Cause Throwable var1, String var2, BundleRevision var3);

    @Message(id=11270, value="Cannot obtain web.xml from: %s")
    public LifecycleInterceptorException lifecycleInterceptorCannotObtainWebXML(URL var1);

    @Message(id=11271, value="Cannot obtain web.xml")
    public LifecycleInterceptorException lifecycleInterceptorCannotObtainWebXML(@Cause Throwable var1);

    @Message(id=11272, value="Timeout getting: %s")
    public TimeoutException timeoutGettingService(String var1);

    @Message(id=11273, value="Cannot get service value for: %s")
    public ExecutionException executionCannotGetServiceValue(@Cause Throwable var1, String var2);

    @Message(id=11274, value="Boot classpath extension not supported")
    public UnsupportedOperationException unsupportedBootClasspathExtension();

    @Message(id=11275, value="Framework extension not supported")
    public UnsupportedOperationException unsupportedFrameworkExtension();

    @Message(id=11276, value="Timeout waiting for bundle install service: %s")
    public TimeoutException timeoutWaitingForBundleInstallService(Set<ServiceName> var1);
}

